package com.polestar.naosdk.managers;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.helpers.Log;
import com.polestar.naosdk.api.INAOBeaconReportingClient;
import com.polestar.naosdk.api.INAOServiceProvider;
import com.polestar.naosdk.api.external.NAOBeaconReportingListener;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.TPOWERMODE;

/**
 * Created by asimonigh on 18/01/2016.
 */
public class NAOBeaconReportingProvider extends INAOServiceProvider<NAOBeaconReportingListener, INAOBeaconReportingClient>{


    public NAOBeaconReportingProvider(Context context, Class<?> cls, @NonNull String apiKey, @NonNull NAOBeaconReportingListener client, @NonNull NAOSensorsListener sensorListener) {
        super(context, cls, apiKey, client, sensorListener);
    }

    @Override
    protected boolean registerClient() {
        return getServiceManager().registerBeaconReportingClient(mInternalClient, myApiKey, myISensorRequestListener);
    }

    @Override
    public void unregisterClient() {
        getServiceManager().unregisterBeaconReportingClient(mInternalClient);
    }

    @Override
    protected INAOBeaconReportingClient createInternalClient(){
        return this.new InternalClient();
    }

    private class InternalClient extends INAOBeaconReportingClient {

        @Override
        public void onError(final NAOERRORCODE code, final String msg) {
            Log.writeToLog(this.getClass().getName(), "onError code=" + code + " msg=" + msg);
            NAOBeaconReportingProvider.this.executeInHandler(new Runnable() {
                @Override
                public void run() {
                    myExternalListener.onError(code, msg);
                }
            });
        }
    }

    @Override
    public void setPowerModeInternal(@NonNull TPOWERMODE mode) {
        Log.restricted(this.getClass().getName(), "set Power Mode has no effect for Beacon Reporting client");
    }

}
