package com.polestar.naosdk.fota.service;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.RequiresApi;

import com.polestar.naosdk.api.ICrashLogHelper;
import com.polestar.naosdk.api.INAOBeaconConfClient;
import com.polestar.naosdk.api.IUIHelper;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.fota.BLESettings;
import com.polestar.naosdk.fota.Beacon;
import com.polestar.naosdk.fota.BeaconConfiguration;
import com.polestar.naosdk.fota.BeaconState;
import com.polestar.naosdk.fota.IBeaconConfListener;
import com.polestar.naosdk.fota.IBeaconConfService;
import com.polestar.naosdk.fota.MissionState;
import com.polestar.naosdk.gatt.GattManager;
import com.polestar.naosdk.gatt.INAOGattListener;
import com.polestar.naosdk.managers.ISensorRequestListenerImpl;
import com.polestar.naosdk.managers.NaoServiceManager;

import java.util.List;

/**
 * Created by asimonigh on 12/05/2017.
 */
@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class BeaconConfClient extends INAOBeaconConfClient {

    private ContextWrapper mContext;
    private GattManager gattManager;
    private String mClouURL;
    private String mCloudToken;
    private int mSiteID;
    private IUIHelper muiHelper;
    private ICrashLogHelper mCrashLogHelper;
    private IBeaconConfService nativeService;
    private IBeaconConfListener beaconConfListener;

    private Handler myHandler;
    private ISensorRequestListenerImpl myISensorRequestListener;


    public BeaconConfClient(Context ctxt, int siteID, String cloudURL, String cloudToken,
                            IUIHelper uiHelper, ICrashLogHelper crashLogHelper,
                            IBeaconConfListener confListener){
        mContext = new ContextWrapper(ctxt);
        mSiteID = siteID;
        mCloudToken = cloudToken;
        mClouURL = cloudURL;
        muiHelper = uiHelper;
        mCrashLogHelper = crashLogHelper;
        beaconConfListener = confListener;

        myHandler = new Handler(mContext.getApplicationContext().getMainLooper());
    }

    public void registerClient(String deploymentID, NAOSensorsListener sensorsListener){
        myISensorRequestListener = new ISensorRequestListenerImpl(myHandler, sensorsListener, mContext);
        NaoServiceManager.getService().getNaoContext()
                .naoServiceManager.registerBeaconConfSynchroClient("NAOLogger_"+deploymentID,
                        this,
                        myISensorRequestListener);
    }

    public void unregisterClient(){
        NaoServiceManager.getService().getNaoContext()
                .naoServiceManager.unregisterBeaconConfSynchroClient(this);
    }

    public void downloadMissions() {
        nativeService.downloadMissions();
    }

    public void startMission(int id, boolean restart){
        nativeService.startMission(id, restart);
    }

    public void stopMission(){
        nativeService.stopMission();
    }

    public List<Beacon> getBeaconsFromMission(int missionID){
        return nativeService.getBeaconsFromMission(missionID);
    }

    public BeaconConfiguration getBeaconConf(int beaconID, int missionID){
        return nativeService.getBeaconConfToSynchronize(beaconID, missionID);
    }

    public void sendMissionReports(){
        nativeService.sendMissionsReports();
    }

    public MissionState getMissionState(int missionID){
        return nativeService.getMissionState(missionID);
    }

    public BeaconState getBeaconStatre(int missionID, int beaconID){
        return nativeService.getBeaconState(missionID, beaconID);
    }

    public void setBleSettings(BLESettings settings){
        nativeService.setBLESettings(settings);
    }
     public BLESettings getBleSettings(){
         return nativeService.getBLESettings();
     }

     public void synchroConfiguration(Beacon beacon, BeaconConfiguration conf, BLESettings settings){
         nativeService.synchronizeBeaconWithConf(beacon, conf, settings);
     }

    @Override
    public void setBeaconConfGattListener(INAOGattListener listener) {
        gattManager = new GattManager(mContext, listener);
    }

    @Override
    public void setBeaconConfService(IBeaconConfService service) {
        nativeService = service;
        nativeService.setBeaconConfListener(beaconConfListener);
        nativeService.setGattInterface(gattManager);
        nativeService.setCloudToken(mCloudToken);
        nativeService.setSiteID(mSiteID);
    }

    @Override
    public String getCloudURL() {
        return mClouURL;
    }

    @Override
    public IUIHelper getUIHelper() {
        return muiHelper;
    }

    @Override
    public ICrashLogHelper getCrashLogHelper() {
        return mCrashLogHelper;
    }

    @Override
    public void onError(NAOERRORCODE code, String msg) {
        //TODO
    }
}
