package com.polestar.naosdk.api.external;

import android.app.Notification;
import android.content.Context;

/**
 * Handles app wake-up behavior
 */
public abstract class NAOWakeUpNotifier {
	/**
	 * android context.
	 */
	private Context context;

	/**
	 * Constructor.
	 */
	public NAOWakeUpNotifier() {
		super();
	}

	/**
	 * Method called to wake-up the app when user enter Beacon area.
	 * Should be overriden by the service client app
	 */
	public abstract void onEnterBeaconArea();

	/**
	 * @exclude
	 */
	public void onExitBeaconArea(){}
	/**
	 * @exclude
	 */
	public void onEnterGPSArea(){}
	/**
	 * @exclude
	 */
	public void onExitGPSArea(){}

	public Context getContext() {
		return context;
	}

	public void setContext(Context context) {
		this.context = context;
	}
	/**
	 * @exclude
	 */
	public void onExitCoverage() {}

	public Notification wakeUpNotification() {
		//return an default empty Notification
		return new Notification();
	}
}
