package com.polestar.naosdk.api.external;

import android.location.Location;

/**
 * Location Service callbacks
 */
public interface NAOLocationListener extends NAOErrorListener {

    /**
     * Receives notification of a new user location. The location coordinates are in WGS84 format.
     * The locations are sent each second when the status of the NAOLocationHandle is **AVAILABLE**.
     * @param loc Location of the user provided as a Location object. HasBearing() will return False at
     *            the start of the service and it may take up to 6 locations to switch to True.
     *            Value will stay at False if compass is disabled. If compass isn't calibrated, hasBearing() will return False.
     *            When the compass is calibrated again, hasBearing() will return True.
     */
    void onLocationChanged(Location loc);

    /**
     * Receives notification when the status of the location service changes.
     * @param status see TNAOFIXSTATUS doc for status values description
     */
    void onLocationStatusChanged(TNAOFIXSTATUS status);


    /**
     * Receives notification that a user has just entered a certain site.
     * The site is defined as the positioning area which is actually where the positioning graph is drawn.
     * @param name Name of the site
     */
    void onEnterSite(String name);

    /**
     * Receives notification that a user has just left a certain site.
     * @param name Name of the site
     */
    void onExitSite(String name);
}
