package com.polestar.naosdk.api.external;

/**
 * Geofencing service callbacks
 */
public interface NAOGeofencingListener extends NAOErrorListener{

     /**
      * Receives notification that a new alert has been fired.
      * @param alert An alert is an event which is sent to the application on entering or exiting a geofence.
      *              You can configure alerts on the NAO Cloud page dedicated to geonotifications.
      *              Alerts are an easy way to contextualize the digital content of your application.
      *              If no alert is configured for a given geofence, nothing will be send
      *              to the application, it is as if the geofence were inactive.
      */
     void onFireNaoAlert(NaoAlert alert);
}
