
package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.naosdk.managers.NAOGeofencingProvider;

public final class NAOGeofencingHandle extends NAOServiceHandle<NAOGeofencingProvider> {

    /**
     * @param context context of your application
     * @param cls your service class that inherits from NaoServiceManager
     * @param key API key to activate that service. Key is available on your NAO Cloud account.
     * @param client listener for geofence updates
     * @param sensorsListener listener for sensor activation requests
     */
    public NAOGeofencingHandle(Context context, Class<?> cls, @NonNull String key, @NonNull NAOGeofencingListener client, @NonNull NAOSensorsListener sensorsListener) {
        myProvider = new NAOGeofencingProvider(context, cls, key, client, sensorsListener);
    }


    /**
     * @since 4.2.2
     * get Data Information for geofence defined with regionId
     * @param regionId: id of the region affected by the change
     */
    public NAOGeofenceData getGeofenceData(int regionId) {
        return myProvider.getGeofenceData(regionId);
    }

}
