package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.naosdk.managers.NAOBeaconReportingProvider;

public final class NAOBeaconReportingHandle extends NAOServiceHandle<NAOBeaconReportingProvider>{

    /**
     * @param context the context of your application
     * @param cls your service class that inherit from NaoServiceManager
     * @param key API key to activate that service. Key is available on your NAO Cloud account.
     * @param client listener for service updates
     * @param sensorsListener listener for sensor activation requests
     */
    public NAOBeaconReportingHandle(Context context, Class<?> cls, @NonNull String key, @NonNull NAOBeaconReportingListener client, @NonNull NAOSensorsListener sensorsListener){
        myProvider = new NAOBeaconReportingProvider(context, cls, key, client, sensorsListener);
    }

}
