package com.polestar.naosdk.api.external;

/**
 * Beacon Proximity service callbacks
 */
public interface NAOBeaconProximityListener extends NAOErrorListener{

    /**
     * Receives notifications when a beacon position changes relative to the device.
     * @param beaconState beacon state relative to the device.
     * @param label beacon identifier.
     */
    void onProximityChange(TBEACONSTATE beaconState, String label);

    /**
     * Receives notifications when the device receives a signal from a beacon.
     * @param rssi RSSI (signal strength) received from the beacon.
     * @param label beacon identifier.
     */
    void onBeaconRange(int rssi, String label);
}
