package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.naosdk.managers.NAOBeaconProximityProvider;


public final class NAOBeaconProximityHandle extends NAOServiceHandle<NAOBeaconProximityProvider> {

    /**
     * @param context context of your application
     * @param cls your service class that inherits from NaoServiceManager
     * @param key API key to activate the service. Key is available on your NAO Cloud account.
     * @param client listener for beacon proximity updates
     * @param sensorsListener listener for sensor activation requests
     */
    public NAOBeaconProximityHandle(Context context, Class<?> cls, @NonNull String key, @NonNull NAOBeaconProximityListener client, @NonNull NAOSensorsListener sensorsListener) {
        myProvider = new NAOBeaconProximityProvider(context, cls, key, client, sensorsListener);
    }

}
