package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.naosdk.managers.NAOAnalyticsProvider;


public final class NAOAnalyticsHandle  extends NAOServiceHandle<NAOAnalyticsProvider> {

    /**
     * @param context the context of your application
     * @param cls your service class that inherits from NaoServiceManager
     * @param key your API key available on NAO Cloud
     * @param client listener for service updates
     * @param sensorsListener listener for sensor activation requests
     */
    public NAOAnalyticsHandle(Context context, Class<?> cls, @NonNull String key, @NonNull NAOAnalyticsListener client, @NonNull NAOSensorsListener sensorsListener) {
        myProvider = new NAOAnalyticsProvider(context, cls, key, client, sensorsListener);
    }

}

