// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from com_polestar_naosdk_api.djinni

package com.polestar.naosdk.api;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 *@DLL_EXPORT_ALL
 * Platform service providing pluggable access to thread functionality
 * which may vary by platform.  Some language runtimes don't interact
 * well with threads they didn't create, so this interface can be used
 * as a factory for threads which can freely call across languages
 * without issues.
 * Function to call on a thread created by platform interface.
 */
public abstract class ThreadFunc {
    /** Will be run on thread start.  The thread will exit when this returns. */
    public abstract void run();

    private static final class CppProxy extends ThreadFunc
    {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef)
        {
            if (nativeRef == 0) throw new RuntimeException("nativeRef is zero");
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long nativeRef);
        public void destroy()
        {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) nativeDestroy(this.nativeRef);
        }
        protected void finalize() throws java.lang.Throwable
        {
            destroy();
            super.finalize();
        }

        @Override
        public void run()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_run(this.nativeRef);
        }
        private native void native_run(long _nativeRef);
    }
}
