package com.polestar.naosdk.api;

import com.polestar.models.BleMeasurement;
import com.polestar.naosdk.api.external.NAOERRORCODE;

import java.util.ArrayList;

/**
 * Created by jchouki on 09/12/2015.
 */
public interface NAOInternalListener {

    /**
     * Receives notification when an error occured
     * @param errCode error code. Check NAOERRORCODE doc for a description of error codes.
     * @param message message providing extra information about the error.
     */
    void onError(NAOERRORCODE errCode, String message);

    //When the app receives this callback, it is expected to display a warning message about the fact that the device
    //is not able to provide as good a location service as usual, but the service will be provided nonetheless.
    void deviceHasLimitedAccuracy();

    void onWifiAPsNumberChanged( int nAPs);
    void onBleBeaconsNumberChanged( int nAPs);
    void onBleListChanged(ArrayList<LoggerBeaconData> data);

    void onReplayComplete();
}
