package com.polestar.naosdk.api;

import com.polestar.naosdk.api.external.NAOERRORCODE;

import java.util.ArrayList;

/**
 * Created by jchouki on 04/12/2015.
 */
public interface LoggerNaoLocationListener {

    /**
     * Receives notification when an error occured
     * @param errCode error code. Check NAOERRORCODE doc for a description of error codes.
     * @param message message providing extra information about the error.
     */
    void onError(NAOERRORCODE errCode, String message);
     /**
     * Notify the Service of an event that has caused a critical error, which can not be
     * resolved and thus no functionality can be accessed anymore.
     */
    void onUnrecoverableError();

    /**
     * Change the number of WIFI APs and broadcast updates for the clients of the Service.
     * @param numberOfAps number of APs to be updated
     */
    void NotifyWifiAPsNumberUpdate(int numberOfAps);

    /**
     * Change the number of BLE Beacons and broadcast updates for the clients of the Service.
     * @param numberOfBeacons number of beacons to be updated
     */
    void NotifyBleBeaconsNumberUpdate(int numberOfBeacons);

    /**
     * Notify the Service that the end of the binary file to be replayed has been reached.
     */
    void onReplayComplete();

    /**
     * Notify the Service that client app need to display a warning message about the fact
     * that the device is not able to provide as good a location service as usual,
     */
    void deviceHasLimitedAccuracy();

    /**
     * Notify the service List of Ble Measurements
     * @param data
     */
    void onNewNativeBleListArray(ArrayList<LoggerBeaconData> data);
}
