// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from com_polestar_naosdk_api.djinni

package com.polestar.naosdk.api;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IPlatformThreadFactory {
    /** Creates and starts a new thread which will call the given function. */
    public abstract void createThread(String name, ThreadFunc func);

    /**
     * Determines whether the calling thread is the main UI thread of the
     * app.  Some platforms do not have a notion of a main thread, in which
     * case this method returns null.
     */
    public abstract boolean isMainThread();

    public abstract void postToUIThread(ThreadFunc task);

    private static final class CppProxy extends IPlatformThreadFactory
    {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef)
        {
            if (nativeRef == 0) throw new RuntimeException("nativeRef is zero");
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long nativeRef);
        public void destroy()
        {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) nativeDestroy(this.nativeRef);
        }
        protected void finalize() throws java.lang.Throwable
        {
            destroy();
            super.finalize();
        }

        @Override
        public void createThread(String name, ThreadFunc func)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_createThread(this.nativeRef, name, func);
        }
        private native void native_createThread(long _nativeRef, String name, ThreadFunc func);

        @Override
        public boolean isMainThread()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_isMainThread(this.nativeRef);
        }
        private native boolean native_isMainThread(long _nativeRef);

        @Override
        public void postToUIThread(ThreadFunc task)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_postToUIThread(this.nativeRef, task);
        }
        private native void native_postToUIThread(long _nativeRef, ThreadFunc task);
    }
}
