// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from com_polestar_naosdk_api.djinni

package com.polestar.naosdk.api;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class INAOServiceManager {
    public abstract void synchronizeData(String apiKey, INAOSyncListener listener);

    public abstract void resetServices();

    public abstract com.polestar.naosdk.api.ISensorObserver getSensorObserver();

    public abstract String getRootDir();

    public abstract String getAppLocalDir(String apiKey);

    public abstract String getAppFilePath(String apiKey);

    public abstract com.polestar.naosdk.api.external.NAOGeofenceData getGeofenceData(int regionId);

    public abstract ArrayList<com.polestar.naosdk.api.external.NAOGeofenceData> getRegionsWithAlerts();

    public abstract ArrayList<com.polestar.naosdk.api.CGeofencePolygon> getGeofencePolygons(String apiKey);

    public abstract void setGPSGeofenceController(IGPSGeofencingManager gpsGeofenceController);

    public abstract boolean registerLocationClient(INAOLocationClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterLocationClient(INAOLocationClient client);

    public abstract boolean setLocationClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOLocationClient client);

    public abstract boolean registerGeofencingClient(INAOGeofencingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterGeofencingClient(INAOGeofencingClient client);

    public abstract boolean setGeofencingClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOGeofencingClient client);

    /** true on success. false if, e.g. client is not registered */
    public abstract boolean registerProximityClient(INAOProximityClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterProximityClient(INAOProximityClient client);

    public abstract boolean setBeaconProximityClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOProximityClient client);

    public abstract boolean registerAnalyticsClient(INAOAnalyticsClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterAnalyticsClient(INAOAnalyticsClient client);

    public abstract boolean setAnalyticsClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOAnalyticsClient client);

    public abstract boolean registerBeaconReportingClient(INAOBeaconReportingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterBeaconReportingClient(INAOBeaconReportingClient client);

    public abstract boolean setBeaconReportingClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOBeaconReportingClient client);

    public abstract boolean registerInternalClient(INAOInternalClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterInternalClient(INAOInternalClient client);

    public abstract boolean registerBeaconConfSynchroClient(String deploymentID, INAOBeaconConfClient client, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

    public abstract boolean unregisterBeaconConfSynchroClient(INAOBeaconConfClient client);

    /** start the measurement processing loop - will be called automatically on a client registration so in general, no need to call it explicitely */
    public abstract void start();

    /** stop the measurement processing loop - will be called automatically on last client unregistration so in general, no need to call it explicitely */
    public abstract void stop();

    /** whether any service is running */
    public abstract boolean isRunning();

    /** stop the measurement processing loop and unregister existing clients, resetting services */
    public abstract void stopAndDestroyServices();

    /**
     * onReplayFinished can be null
     * replaySpeed of 0 is maximum speed
     */
    public abstract void startReplay(String measurementFilePath, int startDelaySec, float replaySpeed, com.polestar.naosdk.api.ICallback onReplayFinished);

    public abstract void stopReplay();

    public abstract boolean isInReplay();

    public abstract void setAutoStartStop(boolean val);

    /** has any service client */
    public abstract boolean hasServiceClients();

    public abstract String getClientServiceStatus();

    /** stop NAO services logging and close log file descriptors - introduced for closing file descriptors when running integration tests in succession */
    public abstract void stopServiceLog();

    /** sleep time in main loop if there is no measurement to process. Impacts CPU usage. */
    public abstract void setMainLoopSleepIntervalMs(int sleepIntervalMs);

    public abstract IMeasureLogger getMeasureLogger();

    public abstract com.polestar.naosdk.api.external.TPOWERMODE getPowerMode();

    public abstract String getDatabaseVersions();

    public abstract void setRootURL(String rootURL);

    public abstract String getRootURL();

    public abstract void writeToLog(String msg);

    public abstract void uploadNAOLogInfo(String msg);

    public abstract boolean hasTriggeredEnterSite();

    /** set minimum time between calls to synchronize data */
    public abstract void setMinTimeBetweenSyncs(int minTimeSec);

    /** minTime in seconds; any call to synchronize data within minTime of the previous one will be ignored. */
    public abstract int getMinTimeBetweenSyncs();

    /** State of running services */
    public abstract String getServiceState();

    /** Ignore some sensor measurements for testing purposes */
    public abstract void setSensorBypass(com.polestar.naosdk.api.TSENSORTYPE sensorType, boolean flag);

    /** ID used to identify client instance, e.g. user id for analytics service */
    public abstract void setInstanceID(String id);

    public abstract String getInstanceID();

    public static native String getAPIKeyRelDirectory(String apiKey);

    public static native String getSoftwareVersion();

    public static native ArrayList<GeofencePDB> getGeofenceGPS(String roothPath, String apiKey);

    public static native ArrayList<com.polestar.naosdk.api.external.NaoAlert> parseAlertsFromFile(String filename);

    public static native INAOServiceManager createInstance(com.polestar.naosdk.api.ISensorProxyFactory sensorFactory, com.polestar.naosdk.api.IPlatformThreadFactory threadFactory, ISynchroBroker synchroBroker, com.polestar.naosdk.api.IHttpHelper httpHelper, com.polestar.naosdk.api.IPrefHelper prefHelper, com.polestar.naosdk.api.IConnectivityHelper connectivityHelper, DeviceInfo deviceInfo, String rootPath);

    public static native String getDefaultRootURL();

    /**check when need to copy assets */
    public static native boolean needsToCopyAssets(String jsonSrc, String jsonAssets);

    private static final class CppProxy extends INAOServiceManager
    {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef)
        {
            if (nativeRef == 0) throw new RuntimeException("nativeRef is zero");
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long nativeRef);
        public void destroy()
        {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) nativeDestroy(this.nativeRef);
        }
        protected void finalize() throws java.lang.Throwable
        {
            destroy();
            super.finalize();
        }

        @Override
        public void synchronizeData(String apiKey, INAOSyncListener listener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_synchronizeData(this.nativeRef, apiKey, listener);
        }
        private native void native_synchronizeData(long _nativeRef, String apiKey, INAOSyncListener listener);

        @Override
        public void resetServices()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_resetServices(this.nativeRef);
        }
        private native void native_resetServices(long _nativeRef);

        @Override
        public com.polestar.naosdk.api.ISensorObserver getSensorObserver()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getSensorObserver(this.nativeRef);
        }
        private native com.polestar.naosdk.api.ISensorObserver native_getSensorObserver(long _nativeRef);

        @Override
        public String getRootDir()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getRootDir(this.nativeRef);
        }
        private native String native_getRootDir(long _nativeRef);

        @Override
        public String getAppLocalDir(String apiKey)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getAppLocalDir(this.nativeRef, apiKey);
        }
        private native String native_getAppLocalDir(long _nativeRef, String apiKey);

        @Override
        public String getAppFilePath(String apiKey)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getAppFilePath(this.nativeRef, apiKey);
        }
        private native String native_getAppFilePath(long _nativeRef, String apiKey);

        @Override
        public com.polestar.naosdk.api.external.NAOGeofenceData getGeofenceData(int regionId)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getGeofenceData(this.nativeRef, regionId);
        }
        private native com.polestar.naosdk.api.external.NAOGeofenceData native_getGeofenceData(long _nativeRef, int regionId);

        @Override
        public ArrayList<com.polestar.naosdk.api.external.NAOGeofenceData> getRegionsWithAlerts()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getRegionsWithAlerts(this.nativeRef);
        }
        private native ArrayList<com.polestar.naosdk.api.external.NAOGeofenceData> native_getRegionsWithAlerts(long _nativeRef);

        @Override
        public ArrayList<com.polestar.naosdk.api.CGeofencePolygon> getGeofencePolygons(String apiKey)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getGeofencePolygons(this.nativeRef, apiKey);
        }
        private native ArrayList<com.polestar.naosdk.api.CGeofencePolygon> native_getGeofencePolygons(long _nativeRef, String apiKey);

        @Override
        public void setGPSGeofenceController(IGPSGeofencingManager gpsGeofenceController)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setGPSGeofenceController(this.nativeRef, gpsGeofenceController);
        }
        private native void native_setGPSGeofenceController(long _nativeRef, IGPSGeofencingManager gpsGeofenceController);

        @Override
        public boolean registerLocationClient(INAOLocationClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerLocationClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerLocationClient(long _nativeRef, INAOLocationClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterLocationClient(INAOLocationClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterLocationClient(this.nativeRef, client);
        }
        private native boolean native_unregisterLocationClient(long _nativeRef, INAOLocationClient client);

        @Override
        public boolean setLocationClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOLocationClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_setLocationClientPowerMode(this.nativeRef, mode, client);
        }
        private native boolean native_setLocationClientPowerMode(long _nativeRef, com.polestar.naosdk.api.external.TPOWERMODE mode, INAOLocationClient client);

        @Override
        public boolean registerGeofencingClient(INAOGeofencingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerGeofencingClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerGeofencingClient(long _nativeRef, INAOGeofencingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterGeofencingClient(INAOGeofencingClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterGeofencingClient(this.nativeRef, client);
        }
        private native boolean native_unregisterGeofencingClient(long _nativeRef, INAOGeofencingClient client);

        @Override
        public boolean setGeofencingClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOGeofencingClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_setGeofencingClientPowerMode(this.nativeRef, mode, client);
        }
        private native boolean native_setGeofencingClientPowerMode(long _nativeRef, com.polestar.naosdk.api.external.TPOWERMODE mode, INAOGeofencingClient client);

        @Override
        public boolean registerProximityClient(INAOProximityClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerProximityClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerProximityClient(long _nativeRef, INAOProximityClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterProximityClient(INAOProximityClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterProximityClient(this.nativeRef, client);
        }
        private native boolean native_unregisterProximityClient(long _nativeRef, INAOProximityClient client);

        @Override
        public boolean setBeaconProximityClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOProximityClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_setBeaconProximityClientPowerMode(this.nativeRef, mode, client);
        }
        private native boolean native_setBeaconProximityClientPowerMode(long _nativeRef, com.polestar.naosdk.api.external.TPOWERMODE mode, INAOProximityClient client);

        @Override
        public boolean registerAnalyticsClient(INAOAnalyticsClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerAnalyticsClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerAnalyticsClient(long _nativeRef, INAOAnalyticsClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterAnalyticsClient(INAOAnalyticsClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterAnalyticsClient(this.nativeRef, client);
        }
        private native boolean native_unregisterAnalyticsClient(long _nativeRef, INAOAnalyticsClient client);

        @Override
        public boolean setAnalyticsClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOAnalyticsClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_setAnalyticsClientPowerMode(this.nativeRef, mode, client);
        }
        private native boolean native_setAnalyticsClientPowerMode(long _nativeRef, com.polestar.naosdk.api.external.TPOWERMODE mode, INAOAnalyticsClient client);

        @Override
        public boolean registerBeaconReportingClient(INAOBeaconReportingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerBeaconReportingClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerBeaconReportingClient(long _nativeRef, INAOBeaconReportingClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterBeaconReportingClient(INAOBeaconReportingClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterBeaconReportingClient(this.nativeRef, client);
        }
        private native boolean native_unregisterBeaconReportingClient(long _nativeRef, INAOBeaconReportingClient client);

        @Override
        public boolean setBeaconReportingClientPowerMode(com.polestar.naosdk.api.external.TPOWERMODE mode, INAOBeaconReportingClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_setBeaconReportingClientPowerMode(this.nativeRef, mode, client);
        }
        private native boolean native_setBeaconReportingClientPowerMode(long _nativeRef, com.polestar.naosdk.api.external.TPOWERMODE mode, INAOBeaconReportingClient client);

        @Override
        public boolean registerInternalClient(INAOInternalClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerInternalClient(this.nativeRef, client, apiKey, sensorReqListener);
        }
        private native boolean native_registerInternalClient(long _nativeRef, INAOInternalClient client, String apiKey, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterInternalClient(INAOInternalClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterInternalClient(this.nativeRef, client);
        }
        private native boolean native_unregisterInternalClient(long _nativeRef, INAOInternalClient client);

        @Override
        public boolean registerBeaconConfSynchroClient(String deploymentID, INAOBeaconConfClient client, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_registerBeaconConfSynchroClient(this.nativeRef, deploymentID, client, sensorReqListener);
        }
        private native boolean native_registerBeaconConfSynchroClient(long _nativeRef, String deploymentID, INAOBeaconConfClient client, com.polestar.naosdk.api.ISensorRequestListener sensorReqListener);

        @Override
        public boolean unregisterBeaconConfSynchroClient(INAOBeaconConfClient client)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_unregisterBeaconConfSynchroClient(this.nativeRef, client);
        }
        private native boolean native_unregisterBeaconConfSynchroClient(long _nativeRef, INAOBeaconConfClient client);

        @Override
        public void start()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_start(this.nativeRef);
        }
        private native void native_start(long _nativeRef);

        @Override
        public void stop()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_stop(this.nativeRef);
        }
        private native void native_stop(long _nativeRef);

        @Override
        public boolean isRunning()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_isRunning(this.nativeRef);
        }
        private native boolean native_isRunning(long _nativeRef);

        @Override
        public void stopAndDestroyServices()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_stopAndDestroyServices(this.nativeRef);
        }
        private native void native_stopAndDestroyServices(long _nativeRef);

        @Override
        public void startReplay(String measurementFilePath, int startDelaySec, float replaySpeed, com.polestar.naosdk.api.ICallback onReplayFinished)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_startReplay(this.nativeRef, measurementFilePath, startDelaySec, replaySpeed, onReplayFinished);
        }
        private native void native_startReplay(long _nativeRef, String measurementFilePath, int startDelaySec, float replaySpeed, com.polestar.naosdk.api.ICallback onReplayFinished);

        @Override
        public void stopReplay()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_stopReplay(this.nativeRef);
        }
        private native void native_stopReplay(long _nativeRef);

        @Override
        public boolean isInReplay()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_isInReplay(this.nativeRef);
        }
        private native boolean native_isInReplay(long _nativeRef);

        @Override
        public void setAutoStartStop(boolean val)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setAutoStartStop(this.nativeRef, val);
        }
        private native void native_setAutoStartStop(long _nativeRef, boolean val);

        @Override
        public boolean hasServiceClients()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_hasServiceClients(this.nativeRef);
        }
        private native boolean native_hasServiceClients(long _nativeRef);

        @Override
        public String getClientServiceStatus()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getClientServiceStatus(this.nativeRef);
        }
        private native String native_getClientServiceStatus(long _nativeRef);

        @Override
        public void stopServiceLog()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_stopServiceLog(this.nativeRef);
        }
        private native void native_stopServiceLog(long _nativeRef);

        @Override
        public void setMainLoopSleepIntervalMs(int sleepIntervalMs)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setMainLoopSleepIntervalMs(this.nativeRef, sleepIntervalMs);
        }
        private native void native_setMainLoopSleepIntervalMs(long _nativeRef, int sleepIntervalMs);

        @Override
        public IMeasureLogger getMeasureLogger()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getMeasureLogger(this.nativeRef);
        }
        private native IMeasureLogger native_getMeasureLogger(long _nativeRef);

        @Override
        public com.polestar.naosdk.api.external.TPOWERMODE getPowerMode()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getPowerMode(this.nativeRef);
        }
        private native com.polestar.naosdk.api.external.TPOWERMODE native_getPowerMode(long _nativeRef);

        @Override
        public String getDatabaseVersions()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getDatabaseVersions(this.nativeRef);
        }
        private native String native_getDatabaseVersions(long _nativeRef);

        @Override
        public void setRootURL(String rootURL)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setRootURL(this.nativeRef, rootURL);
        }
        private native void native_setRootURL(long _nativeRef, String rootURL);

        @Override
        public String getRootURL()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getRootURL(this.nativeRef);
        }
        private native String native_getRootURL(long _nativeRef);

        @Override
        public void writeToLog(String msg)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_writeToLog(this.nativeRef, msg);
        }
        private native void native_writeToLog(long _nativeRef, String msg);

        @Override
        public void uploadNAOLogInfo(String msg)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_uploadNAOLogInfo(this.nativeRef, msg);
        }
        private native void native_uploadNAOLogInfo(long _nativeRef, String msg);

        @Override
        public boolean hasTriggeredEnterSite()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_hasTriggeredEnterSite(this.nativeRef);
        }
        private native boolean native_hasTriggeredEnterSite(long _nativeRef);

        @Override
        public void setMinTimeBetweenSyncs(int minTimeSec)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setMinTimeBetweenSyncs(this.nativeRef, minTimeSec);
        }
        private native void native_setMinTimeBetweenSyncs(long _nativeRef, int minTimeSec);

        @Override
        public int getMinTimeBetweenSyncs()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getMinTimeBetweenSyncs(this.nativeRef);
        }
        private native int native_getMinTimeBetweenSyncs(long _nativeRef);

        @Override
        public String getServiceState()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getServiceState(this.nativeRef);
        }
        private native String native_getServiceState(long _nativeRef);

        @Override
        public void setSensorBypass(com.polestar.naosdk.api.TSENSORTYPE sensorType, boolean flag)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setSensorBypass(this.nativeRef, sensorType, flag);
        }
        private native void native_setSensorBypass(long _nativeRef, com.polestar.naosdk.api.TSENSORTYPE sensorType, boolean flag);

        @Override
        public void setInstanceID(String id)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setInstanceID(this.nativeRef, id);
        }
        private native void native_setInstanceID(long _nativeRef, String id);

        @Override
        public String getInstanceID()
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getInstanceID(this.nativeRef);
        }
        private native String native_getInstanceID(long _nativeRef);
    }
}
