// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from com_polestar_naosdk_api.djinni

package com.polestar.naosdk.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IHttpHelper {
    /** returns http code */
    public abstract int sendFile(String url, String outputPath);

    /** returns http code */
    public abstract int getFile(String url, String outputPath);

    /** returns http code */
    public abstract int getFileIfModified(String url, String outputPath, String modifiedSince);

    public abstract String getText(String url);

    public abstract String postText(String url, HashMap<String, String> params);

    /** get a list of files to zip and upload on cloud, return true if upload is success */
    public abstract boolean zipAndUploadFiles(ArrayList<String> filesPath, String zipPath, String s3URL, String cloudURL, ArrayList<String> params);

    private static final class CppProxy extends IHttpHelper
    {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef)
        {
            if (nativeRef == 0) throw new RuntimeException("nativeRef is zero");
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long nativeRef);
        public void destroy()
        {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) nativeDestroy(this.nativeRef);
        }
        protected void finalize() throws java.lang.Throwable
        {
            destroy();
            super.finalize();
        }

        @Override
        public int sendFile(String url, String outputPath)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_sendFile(this.nativeRef, url, outputPath);
        }
        private native int native_sendFile(long _nativeRef, String url, String outputPath);

        @Override
        public int getFile(String url, String outputPath)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getFile(this.nativeRef, url, outputPath);
        }
        private native int native_getFile(long _nativeRef, String url, String outputPath);

        @Override
        public int getFileIfModified(String url, String outputPath, String modifiedSince)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getFileIfModified(this.nativeRef, url, outputPath, modifiedSince);
        }
        private native int native_getFileIfModified(long _nativeRef, String url, String outputPath, String modifiedSince);

        @Override
        public String getText(String url)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_getText(this.nativeRef, url);
        }
        private native String native_getText(long _nativeRef, String url);

        @Override
        public String postText(String url, HashMap<String, String> params)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_postText(this.nativeRef, url, params);
        }
        private native String native_postText(long _nativeRef, String url, HashMap<String, String> params);

        @Override
        public boolean zipAndUploadFiles(ArrayList<String> filesPath, String zipPath, String s3URL, String cloudURL, ArrayList<String> params)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_zipAndUploadFiles(this.nativeRef, filesPath, zipPath, s3URL, cloudURL, params);
        }
        private native boolean native_zipAndUploadFiles(long _nativeRef, ArrayList<String> filesPath, String zipPath, String s3URL, String cloudURL, ArrayList<String> params);
    }
}
