//______________________________________________________________________________________
//
//  Sensor.java
// 
//  Pole Star Confidential Proprietary
//    Copyright (c) Pole Star 2010, All Rights Reserved
//    No publication authorized. Reverse engineering prohibited
//______________________________________________________________________________________
package com.polestar.models;


import android.content.ContextWrapper;
import android.os.Looper;
import android.util.Log;

import com.polestar.naosdk.api.ISensorObserver;
import com.polestar.naosdk.api.ISensorProxy;
import com.polestar.naosdk.api.TSENSORPOWERMODE;

/**
 * An abstract class to define Sensors (Wifi, GPS, emulators) at high level.
 *    
 * <br/><br/><b>Revision history:</b><br/>
 * <table border>
 * <tr>
 *   <td>Author</td>
 *   <td>Modification date</td>
 *   <td>Tracking Number</td>
 *   <td>Description of Change</td>
 * </tr>
 * <!-- add lines to the table for modifications, following the model -->
 * <tr>
 *   <td>sterrenoir</td>
 *   <td>15 mars 2010</td>
 *   <td>trunk</td>
 *   <td>Creation of this class</td>
 * </tr>
 * </table>    
 * @author sterrenoir
 */
public abstract class SensorNao extends ISensorProxy implements Runnable {

	// constants : states
	public static final int STATUS_ERROR = -1;
	public static final int STATUS_OFF = 0;
	public static final int STATUS_READY = 1;
	public static final int STATUS_RUNNING = 2;
	// constants : states
	public static final int ORDER_UNDEFINED = -1;
	public static final int ORDER_TURN_ON = 0;
	public static final int ORDER_TURN_OFF = 1;
	// constants : states
	public static final int ORDER_PROVENANCE_UNDEFINED = -1;
	public static final int ORDER_PROVENANCE_SERVICE = 0;
	public static final int ORDER_PROVENANCE_LOGGER = 1;
	
	protected int mStatus;
	protected int mOrder = ORDER_TURN_OFF ;
	protected int mOrderProvenance = ORDER_PROVENANCE_UNDEFINED ;
	protected boolean mIsLogger = false;

	protected ISensorObserver mSensorObserver;
	protected Thread mThread;
	protected Looper myLooper;
	/** Reference to the calling context, in order to call upon Android OS services */
	protected ContextWrapper mCtxtWrap = null;

	/**
	 * Set sensor observer (sensorManager c++)
	 * @param observer
	 */
	public void setSensorObserver(ISensorObserver observer) {
		mSensorObserver = observer;
	}

	/**
	 * This method starts the sensor
	 * @return true if successful, false else
	 */
	public abstract boolean startSensor();
	
	/**
	 * This method stops the sensor
	 * 
	 */
	public abstract void stopSensor();
	
	/**
	 * This method start or stop the sensor
	 * 
	 */
	public void switchSensor(int newOrder,int orderProvenance) {
		if(orderProvenance == ORDER_PROVENANCE_LOGGER) {
			mIsLogger = true;
		}
		if(this.mOrder != ORDER_TURN_ON && newOrder==ORDER_TURN_ON)
		{
			this.mOrderProvenance = orderProvenance ;
			startSensor();

		} else if (this.mOrder != ORDER_TURN_OFF && newOrder==ORDER_TURN_OFF) {
			this.mOrderProvenance = orderProvenance ;
			stopSensor() ;
		}
	}

	@Override
	public void setPowerMode(TSENSORPOWERMODE mode) {
		//TODO
	}

	/**
	 * register an output interface to send measurements update to
	 */
	public abstract void registerOutputInterface(ISensorListener targetInterface);
	
	/**
	 * @return true if the sensor is currently up and running
	 */
	public abstract boolean isOn();
	
	/**
	 * @return true if the sensor has a position fix (will always return false for sensors not providing location such as the Wifi sensor)
	 */
	public abstract boolean hasFix();

	/**
	 * @return true if the sensor has a hardware capability
	 */
	public abstract boolean isHardwareCompatible();
	
	/**
	 * set  sensor chip to the state it was before Nao was started
	 * @return true if the sensor has a hardware capability
	 */
	public abstract boolean setStateAsBefore();

	public void quit() {
		if (myLooper!=null) {
			Log.d("SdkSensor", "Looper quit");
//			myLooper.quitSafely();
			myLooper.quit();
		}
	}
}
