package com.polestar.models;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;

import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.naosdk.controllers.GeofencingOSController;
import com.polestar.naosdk.managers.NaoServiceManager;
import com.polestar.sensors.OSLocSensor;

/**
*  That class is used to ensure on-site wake-up behavior persists across on re-activation of OS Location service.
 *  OS location service de-activation causes GPS geofences registration to be cleared.
*   So on re-activation we must register with GPS geofences again.
*/
public class RegisterGeofenceGPSReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(final Context context, Intent intent) {

        // Get gps geofences List associated with apikey from app-preferences and register them with AndroidGeofencingManager
        final ContextWrapper contextWrapper = new ContextWrapper(context);

        if(OSLocSensor.checkLocationProviders(contextWrapper)){
            GeofencingOSController geofencingOSController = new GeofencingOSController(context);
            boolean isEnabled =  geofencingOSController.isEnabled();
            boolean isRegistered =  geofencingOSController.isRegistered();

            if (isEnabled && isRegistered /*&& NaoServiceManager.getService()!=null*/){
                Log.writeToLog(this.getClass().getName(), "RegisterGeofenceGPSReceiver >> register GPS geo-fences");
                geofencingOSController.registerGeofencesWithKey(PrefHelper.get(context, PrefHelper.PREF_APP_KEY, null));
            }else{
                Log.writeToLog(this.getClass().getName(), "RegisterGeofenceGPSReceiver >> no GPS geofence to register. GPS geofences isEnabled " + isEnabled + " isRegistered " + isRegistered);
            }
        } else {
            NaoServiceManager.releaseWakeLock();
        }
    }
}
