package com.polestar.models;


import com.polestar.enums.NRProximityEnum;

public class Ranger {
	
	private NRProximityEnum currentProximity = NRProximityEnum.NRProximityUnknown;
	private int lastRssi;
	private int nbOfSteadyNewProximity = 0;
	private NRProximityEnum newProximity = NRProximityEnum.NRProximityUnknown;
	private Beacon beacon;
	
	
	public Ranger(Beacon beacon) {
		super();
		this.beacon = beacon;
		
	}

	// range = update proximity given a mesurement
	public void range(int rssi){
		NRProximityEnum measProx = null;
		// first time seen
		if (currentProximity == NRProximityEnum.NRProximityUnknown){
			currentProximity = getProximityFromRssi(rssi);
			nbOfSteadyNewProximity = GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_STEADY_THRES);
		}else{ // not the first time seen
			measProx = getProximityWithMargin(rssi);
			if (currentProximity.getValue() != measProx.getValue() && nbOfSteadyNewProximity == 0){
				newProximity = measProx;
				nbOfSteadyNewProximity++;
			}else if (currentProximity.getValue() != measProx.getValue() && nbOfSteadyNewProximity > 0
					&& measProx.getValue() == newProximity.getValue()){
				newProximity = measProx;
				nbOfSteadyNewProximity++;
			}else if (currentProximity.getValue() != measProx.getValue() && nbOfSteadyNewProximity > 0
					&& measProx.getValue() != newProximity.getValue()){
				newProximity = measProx;
				nbOfSteadyNewProximity = 1;
			}else{
				nbOfSteadyNewProximity = 0;
			}
			if (hasChangedProximity()){
				currentProximity = measProx;
			}
		}
		lastRssi = rssi;
//		if (beacon.getBabid() == 1758){
//			String str = "Micro 1758 " + rssi + " " + measProx + " x " + newProximityRepeats.size();
//			LogHelper.e("dbg", str);
//		}
	}
	
	private NRProximityEnum getProximityWithMargin(int rssi) {
		NRProximityEnum measProx = getProximityFromRssi(rssi);
		boolean res = currentProximity.getValue() == measProx.getValue();
		
		// add margin to the comparison
		if (!res){
			if (measProx.getValue() > currentProximity.getValue()){
				measProx = getProximityFromRssi(rssi - GlobalAlgoParams.instance().getInt(GlobalAlgoParams.RSSI_BORDER_MARGIN));
			}
			if (measProx.getValue() < currentProximity.getValue()){
				measProx = getProximityFromRssi(rssi + GlobalAlgoParams.instance().getInt(GlobalAlgoParams.RSSI_BORDER_MARGIN));
			}
		}
		return measProx;
	}

	public boolean hasChangedProximity(){
		return nbOfSteadyNewProximity == GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_STEADY_THRES);
	}
	
	public NRProximityEnum getProximity(){
		return this.currentProximity;
	}
	
	public int getLastRssi() {
		return lastRssi;
	}

	public void setLastRssi(int lastRssi) {
		this.lastRssi = lastRssi;
	}
	
	private NRProximityEnum getProximityFromRssi(int rssi){
		if (rssi > GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_NEAR_THRES) && rssi <= 0){
			return NRProximityEnum.NRProximityImmediate;
		}else if (rssi > GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_FAR_THRES) && rssi <= GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_NEAR_THRES)){
			return NRProximityEnum.NRProximityNear;
		}else if (rssi <= GlobalAlgoParams.instance().getInt(GlobalAlgoParams.NAO_RANGING_FAR_THRES)){
			return NRProximityEnum.NRProximityFar;
		}
		return NRProximityEnum.NRProximityUnknown;
	}
		
}
