package com.polestar.models;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

import android.location.Location;
import android.location.LocationManager;


public class OSLocMeasurement extends Measurement {
	/** GPS fix system timestamp in milliseconds */
	private long mSystemTimestamp;
	/** location fix */
	private Location mLocation;
	
	/**
	 * 
	 * GpsMeasurement constructor : initializes members.
	 */
	public OSLocMeasurement() {
		mLocation = new Location(LocationManager.NETWORK_PROVIDER);
	}

	@Override
	public byte[] toByteArray() {
		// compute array length :
		// 24 = 8+12+4 bytes
		int serializedBytes = 24;
		
		// create new output stream with default size
		ByteArrayOutputStream bos = new ByteArrayOutputStream(serializedBytes);
		DataOutputStream dos = new DataOutputStream(bos);
		
		// add date (hex (16) value )
		try {
			// timestamp
			dos.writeLong(mSystemTimestamp);
			
			// location fix data
			if (mLocation != null) {
				// add number of characters in Provider string name
				dos.writeShort((short) (mLocation.getProvider().length()));
				// add Provider string value
				dos.writeBytes(mLocation.getProvider());
				dos.writeInt((int) Math.round(mLocation.getLatitude()*GpsMeasurement.LATLON_SCALE));
				dos.writeInt((int) Math.round(mLocation.getLongitude()*GpsMeasurement.LATLON_SCALE));
				dos.writeInt((int) Math.round(mLocation.getAltitude()*GpsMeasurement.ALT_SCALE));
				//add accuracy v/h
				float Accuracy_h = mLocation.getAccuracy();
				float Accuracy_v = 0;
				dos.writeShort((int)(Accuracy_h * GpsMeasurement.ACCURACY_SCALE));
				dos.writeShort((int)(Accuracy_v * GpsMeasurement.ACCURACY_SCALE));
				dos.writeShort((int)((mLocation.hasSpeed())?mLocation.getSpeed() * GpsMeasurement.SPEED_SCALE:0xffff));
				dos.writeShort((int)((mLocation.hasBearing())?mLocation.getBearing() * GpsMeasurement.SPEED_SCALE:0xffff));
				} else {
				dos.writeShort(0);
				dos.writeInt(0);
				dos.writeInt(0);
				dos.writeInt(0);
				dos.writeShort(0);
				dos.writeShort(0);
			}				
			
			dos.flush();	
			dos.close();	
		} catch (IOException ie) {
			// error : impossible to write in the stream
			return null;
		}
		
		return bos.toByteArray();
	}

	@Override
	public String toHumanString() {
		String hstr = "";
		
		// timestamp
		if (mLocation == null) {
			hstr += "Error in NetworkMeasurement.toHumanString() :  mLocation is null\n";
		} else { 
			Date timestamp = new Date(mLocation.getTime());
			hstr += "Date "+timestamp.toLocaleString()+"\n";
			// location
			hstr += "Location :\n\tlat. "+String.valueOf(mLocation.getLatitude())+"°\n\tlon. "+String.valueOf(mLocation.getLongitude())+"°\n\talt. "+String.valueOf(mLocation.getAltitude())+"\n";
		}
		return hstr;
	}

	/**
	 * 
	 * sets new location data
	 * @param systemTimestamp : system time associated with the location in milliseconds since 1/1/1970
	 * @param newLocation : new location object to be recorded in this instance
	 */
	public void setLocation(long systemTimestamp,Location newLocation) {
		mLocation.reset();
		mSystemTimestamp = 0;
		// copy location data
		if (newLocation != null) {
			mLocation = newLocation;
			mSystemTimestamp = systemTimestamp;
		}
	}
	
	public long getystemTimeStamp() {
		return mSystemTimestamp;
	}
	
	public Location getLocation() {
		return mLocation;
	}
}
