package com.polestar.models;

public class MemsData {
    public long timestamp;
    public float[] acceleration; //TYPE_ACCELEROMETER
    public float[] gravity; // deduced from accelerometer with low pass filter
	public float[] rotation; //TYPE_ROTATION_VECTOR (Roll, Pitch, Yaw)
	public float[] userAcceleration; //TYPE_LINEAR_ACCELERATION
    public float[] rotationRate; //TYPE_GYROSCOPE
    public float[] magField; //TYPE_MAGNETIC_FIELD
    public float trueHeading, magHeading, headingAccuracy;
    
	public MemsData() {
	    timestamp = 0;
	    acceleration = new float[3];
		gravity = new float[3];
		rotation = new float[3];
		userAcceleration = new float[3];
		rotationRate = new float[3];
		magField = new float[3];
	    trueHeading= 0.0f; magHeading= 0.0f; headingAccuracy= 0.0f;
	}
	
	public MemsData(MemsData aMemsData){
	    timestamp = aMemsData.timestamp;
	    acceleration = aMemsData.acceleration.clone();
	    gravity = aMemsData.gravity.clone();
		rotation = aMemsData.rotation.clone();
		userAcceleration = aMemsData.userAcceleration.clone();
		rotationRate = aMemsData.rotationRate.clone();
		magField = aMemsData.magField.clone();
	    trueHeading= aMemsData.trueHeading;
	    magHeading= aMemsData.magHeading;
	    headingAccuracy= aMemsData.headingAccuracy;
	}

}
