package com.polestar.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalAlgoParams {

    private static GlobalAlgoParams instance = new GlobalAlgoParams(); // always ordered by RSSI

    public final static String NAO_RANGING_FAR_THRES = "NAO_RANGING_FAR_THRES";
    public final static String NAO_RANGING_NEAR_THRES = "NAO_RANGING_NEAR_THRES";

    // if we see 3 times in a row the same as our, we say it is steady
    public final static String NAO_RANGING_STEADY_THRES = "NAO_RANGING_STEADY_THRES";

    public final static String RSSI_BORDER_MARGIN = "RSSI_BORDER_MAGIN";

    public final static String BG_SILENCE_TIME = "BG_SILENCE_TIME"; //s
    public final static String BG_EMPTY_SCAN_TIME = "BG_EMPTY_SCAN_TIME"; //s
    public final static String BG_STOP_TIME = "BG_STOP_TIME"; //s
    public final static String FULL_SCAN_TO_ECO_GUARD = "FULL_SCAN_TO_ECO_GUARD"; //s

    public final static String USERID_PERIOD = "USERID_PERIOD"; //h
    public final static String ANALYTICS_UPLOAD_PERIOD = "ANALYTICS_UPLOAD_PERIOD"; //mn
    public final static String REPORTING_UPLOAD_PERIOD = "REPORTING_UPLOAD_PERIOD"; //mn
    public final static String CORE_BLUETOOTH = "CORE_BLUETOOTH"; //s
    public final static String BLE_UUID_LIST = "BLE_UUID_LIST";

    public final static String MAX_TIME_NOT_SEEN_BEACON_BEFORE_EXIT_IN_S = "MAX_TIME_NOT_SEEN_BEACON_BEFORE_EXIT_IN_S";

    public final static String NAO_ALERT_COUNTER_MAX_BEFORE_UPLOAD_SEC = "NAO_ALERT_COUNTER_MAX_BEFORE_UPLOAD_SEC";


    public Map<String, String> params;

    public static GlobalAlgoParams instance() {
        if (instance == null) {
            instance = new GlobalAlgoParams();
        }
        return instance;
    }

    public GlobalAlgoParams() {
        params = new HashMap<String, String>();

        /**
         * Proximity detection thresholds
         */
        params.put(NAO_RANGING_FAR_THRES, "-70");
        params.put(NAO_RANGING_NEAR_THRES, "-40");

        // if we see 3 times in a row the same as our, we say it is steady
        params.put(NAO_RANGING_STEADY_THRES, "4");

        params.put(RSSI_BORDER_MARGIN, "5");

        // when not seen a beacon more than this value, the beacon is exited
        params.put(MAX_TIME_NOT_SEEN_BEACON_BEFORE_EXIT_IN_S, "20");

        params.put(NAO_ALERT_COUNTER_MAX_BEFORE_UPLOAD_SEC, "21600");
        /**
         * Background behavior
         */
        params.put(BG_SILENCE_TIME, "30");
        params.put(BG_EMPTY_SCAN_TIME, "30");
        params.put(BG_STOP_TIME, "60");
        params.put(FULL_SCAN_TO_ECO_GUARD, "5");

        params.put(USERID_PERIOD, "24");
        params.put(ANALYTICS_UPLOAD_PERIOD, "150");
        params.put(REPORTING_UPLOAD_PERIOD, "150");

        params.put(CORE_BLUETOOTH, "false");

        params.put(BLE_UUID_LIST, "504F4C45535441520000000000000000,504F4C45535441520000000000000001,504F4C45535441520000000000000002,504F4C45535441520000000000000003,504F4C45535441520000000000000004,504F4C45535441520000000000000005,504F4C45535441520000000000000006,504F4C45535441520000000000000007,504F4C45535441520000000000000008,504F4C45535441520000000000000009,504F4C4553544152000000000000000A,504F4C4553544152000000000000000B,504F4C4553544152000000000000000C,504F4C4553544152000000000000000D,504F4C4553544152000000000000000F");

    }

    public List<String> getStringList(String key) {
        List<String> list = new ArrayList<String>();
        String val = params.get(key);
        if (val != null) {
            String[] array = val.split(",");
            for (int i = 0; i < array.length; i++) {
                list.add(array[i]);
            }
        }
        return list;
    }

    public int getInt(String key) {
        int i = -999; // undefined
        String val = params.get(key);
        if (val != null) {
            i = Integer.parseInt(val);
        }
        return i;
    }

    public boolean getBool(String key) {
        boolean b = false;
        String val = params.get(key);
        if (val != null) {
            b = Boolean.parseBoolean(val);
        }
        return b;
    }

    public void put(String key, String val) {
        params.put(key, val);
    }

}
