package com.polestar.helpers.UI;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.support.v4.app.NotificationCompat;
import android.widget.ArrayAdapter;
import android.widget.Toast;


import com.polestar.naosdk.api.ICallback;
import com.polestar.naosdk.api.IUIHelper;

import java.util.ArrayList;

import static android.widget.Toast.LENGTH_SHORT;

/**
 * Created by ggiraud on 12/1/2016.
 */

public class UIHelper extends IUIHelper {

    UIHelperProxy muiHelperProxy;
    Handler mHandler = new Handler(Looper.getMainLooper());

    public UIHelper(Activity activity) {
        muiHelperProxy = new UIHelperProxy(activity);
    }

    @Override
    public void showToast(final String msg) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showToast(msg);
            }
        });
    }

    @Override
    public void showPopup(final String title, final String content) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showPopup(title, content);
            }
        });
    }

    @Override
    public void showWaitingScreen(final String message) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showWaitingScreen(message);
            }
        });
    }

    @Override
    public void showWaitingScreenWithTimeOut(final String message, final int timeout) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showWaitingScreenWithTimeOut(message, timeout);
            }
        });
    }

    @Override
    public void dismissWaitingScreen() {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.dismissWaitingScreen();
            }
        });
    }

    @Override
    public void showProgressBar(final String title, final String txt, final boolean cancellable, final ICallback cancelCallback, final boolean isprogress) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showProgressBar(title, txt, cancellable, cancelCallback, isprogress);
            }
        });
    }


    @Override
    public void hideProgressBar() {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.hideProgressBar();
            }
        });

    }

    @Override
    public void updateProgressBar(final int percent) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.updateProgressBar(percent);
            }
        });

    }

    @Override
    public void showNotification(final String title, final String message, final int id) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showNotification(title, message, id);
            }
        });

    }

    @Override
    public void showAlertDialog(final String title, final String message, final ICallback callback) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showAlertDialog(title, message, callback);
            }
        });
    }

    @Override
    public void showSelectionDialog(final String title, final ArrayList<String> options, final ICallback callback) {
        mHandler.post(new Runnable() {
            @Override
            public void run() {
                muiHelperProxy.showSelectionDialog(title, options, callback);
            }
        });
    }


    private class UIHelperProxy extends IUIHelper {
        Activity mActivity;
        ProgressDialog progressDialog;

        public UIHelperProxy(Activity activity) {
            mActivity = activity;
            progressDialog = new ProgressDialog(activity);
        }

        @Override
        public void showToast(String msg) {
            if(mActivity.isFinishing()){
                // check activity before to avoid BadTokenException: Unable to add window — token
                return;
            }

            Toast toast = Toast.makeText(mActivity, msg, LENGTH_SHORT);
            toast.show();
        }

        @Override
        public void showPopup(String messageName, String messageContent) {

            if(mActivity.isFinishing()){
                return;
            }
            // Vibrate for 500 milliseconds
            Vibrator vibrator = (Vibrator) mActivity.getSystemService(Context.VIBRATOR_SERVICE);
            vibrator.vibrate(500);

            new AlertDialog.Builder(mActivity)
                    .setTitle(messageName)
                    .setMessage(messageContent)
                    .setPositiveButton(android.R.string.ok, null)
                    .setIcon(android.R.drawable.ic_dialog_info)
                    .show();
        }

        @Override
        public void showProgressBar(
                String title,
                String txt,
                boolean cancellable,
                final ICallback cancelCallback,
                boolean isProgress) {

            if(mActivity.isFinishing()){
                return;
            }

            progressDialog = new ProgressDialog(mActivity);
            progressDialog.setTitle(title);
            progressDialog.setMessage(txt);
            progressDialog.setCancelable(cancellable);
            if(cancellable) {
                progressDialog.setButton(DialogInterface.BUTTON_NEGATIVE, "Cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if(cancelCallback != null)
                            cancelCallback.onSuccess("");
                    }
                });
            }
            if (isProgress) {
                progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
                progressDialog.setProgress(0);
                progressDialog.setMax(100);
            }
            progressDialog.show();
        }

        @Override
        public void hideProgressBar() {
            try {
                progressDialog.dismiss();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void updateProgressBar(int percent) {
            if (progressDialog != null) {
                progressDialog.setProgress(percent);
            }
        }


        @Override
        public void showWaitingScreen(String message) {
            if(mActivity.isFinishing()){
                return;
            }
            progressDialog = new ProgressDialog(mActivity);
            progressDialog.setCancelable(false);
            progressDialog.setTitle(message);
            progressDialog.setMessage("Please wait..");
            progressDialog.show();

        }

        @Override
        public void showWaitingScreenWithTimeOut(String message, int timeout) {
            if(mActivity.isFinishing()){
                return;
            }
            progressDialog = new ProgressDialog(mActivity);
            progressDialog.setCancelable(false);
            progressDialog.setTitle(message);
            progressDialog.setMessage("Please wait..");
            progressDialog.show();
            progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener() {
                @Override
                public void onCancel(DialogInterface dialogInterface) {
                    showToast("Operation failed");
                }
            });

            Runnable progressRunnable = new Runnable() {

                @Override
                public void run() {
                    if(progressDialog != null){
                        progressDialog.cancel();
                    }
                }
            };

            Handler pdCanceller = new Handler();
            pdCanceller.postDelayed(progressRunnable, timeout);



        }

        @Override
        public void dismissWaitingScreen() {
            if(progressDialog != null){
                progressDialog.dismiss();
                progressDialog = null;
            }
        }

        /*************************
         * Android Notifications
         *************************/

        @Override
        public void showNotification(String title, String message, int id) {

            Intent notificationIntent = new Intent(mActivity, mActivity.getClass());
            notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            notificationIntent.setAction(Long.toString(System.currentTimeMillis()));
            PendingIntent intent = PendingIntent.getActivity(mActivity, 0, notificationIntent, 0);

            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(mActivity)
                    .setSmallIcon(android.R.drawable.ic_dialog_info)
                    .setContentTitle(title)
                    .setContentIntent(intent)
                    .setContentText(message)
                    .setAutoCancel(false)
                    .setDefaults(Notification.DEFAULT_SOUND | Notification.DEFAULT_VIBRATE | Notification.DEFAULT_LIGHTS);
            NotificationManager mNotificationManager = (NotificationManager) mActivity.getSystemService(Context.NOTIFICATION_SERVICE);
            mNotificationManager.notify(id, mBuilder.build());
        }

        @Override
        public void showAlertDialog(String title, String message, final ICallback callback) {
            AlertDialog.Builder dlg = new AlertDialog.Builder(mActivity);
            if (dlg != null) {
                dlg.setTitle(title).setMessage(message).setIcon(android.R.drawable.ic_dialog_info);

                dlg.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (callback != null) {
                            callback.onSuccess("");
                        }
                    }
                });

                if(callback != null) {
                    dlg.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            if (callback != null) {
                                callback.onFailure("");
                            }
                        }
                    });
                }
                dlg.show();
            }
        }

        @Override
        public void showSelectionDialog(final String title, final ArrayList<String> options, final ICallback callback) {
            AlertDialog.Builder builderSingle = new AlertDialog.Builder(mActivity);
            builderSingle.setTitle(title);
            boolean askConfirmation = false;
            final ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(mActivity, android.R.layout.select_dialog_singlechoice);
            for (String option:options) {
                arrayAdapter.add(option);
            }

            builderSingle.setNegativeButton("cancel", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    if(callback != null) {
                        callback.onFailure("");
                    }
                    dialog.dismiss();
                }
            });

            builderSingle.setAdapter(arrayAdapter, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    String strName = arrayAdapter.getItem(which);
                    if(callback != null) {
                        callback.onSuccess(strName);
                    }
                    dialog.dismiss();
                }
            });
            builderSingle.show();
        }

    }
}
