package com.polestar.helpers;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;

import com.polestar.naosdk.managers.NaoServiceManager;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;

public class NaoUtils {

	private static final String TAG = "NaoUtils";

	public static int androidVersion(){
		return android.os.Build.VERSION.SDK_INT;
	}

	public static String randomString( int len ) 
	{
	   String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	   StringBuilder sb = new StringBuilder( len );
	   for( int i = 0; i < len; i++ ) 
	      sb.append( AB.charAt( new Random().nextInt(AB.length()) ) );
	   return sb.toString();
	}



	/**
	 * Minimum key size
	 */
	protected static final int MIN_KEY_SIZE = 7;

	/**
	 * States whether or not the key has a valid format.
	 *
	 * @param key
	 *            The key
	 *
	 * @return whether or not the key has a valid format.
	 */
	public static boolean isKeyValid(String key) {
		boolean valid;

		if (key != null && (key.length() >= MIN_KEY_SIZE ||
				key.hashCode() == 97406 // "master key" hashcode
		)) {
			valid = true;
		} else {
			valid = false;
		}

		return valid;
	}


	/**
	 * States whether or not the key has a valid format.
	 *
	 * @param key
	 *            The key
	 *
	 * @return whether or not the key has a valid format.
	 */
	public static boolean isKeyTrial(String key) {
		boolean valid;

		if (key != null && key.hashCode() == 97406 )// "master key" hashcode
		{
			valid = true;
		} else {
			valid = false;
		}

		return valid;
	}

	public static void startNaoService(Context context, Class<?> cls) {
		if (context != null) {
			Log.alwaysWarn(TAG, "startNaoService");
			startNaoServiceManager(context, cls);
		} else {
			Log.alwaysWarn(TAG, "Problem to start Nao Service: context is null !!");
		}
	}

	public static void startNaoServiceManager(Context ctx, Class<?> myServiceClass) {
		if (ctx != null && myServiceClass != null && isMyServiceRunning(ctx,myServiceClass) == false) {
			/* Connect to NaoServiceManager and starts it if not started */
			if(myServiceClass == null) {
				Log.alwaysWarn(TAG, "Starting Recovery Service ... ");
			} else {
				Log.alwaysWarn(TAG, "Starting Service ... " + myServiceClass.getName());
				ctx.startService(new Intent(ctx, myServiceClass));
			}
		} else {
			Log.alwaysWarn(TAG, "Ouups: Service is already staring ..." );
		}
	}

	public static void stopNaoServiceManager(Context ctx, Class<?> myServiceClass) {

		if (ctx != null && myServiceClass != null && isMyServiceRunning(ctx,myServiceClass) == true) {
			/* disconnect from NaoServiceManager */
			ctx.stopService(new Intent(ctx, myServiceClass));
		}

	}

	public static boolean isMyServiceRunning(Context ctx , Class<?> serviceClass) {
		ActivityManager manager = (ActivityManager) ctx.getSystemService(Context.ACTIVITY_SERVICE);
		for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
			//Log.alwaysWarn(this.getClass().getName(),"service: " + service.service.getClassName());
			if (serviceClass.getName().equals(service.service.getClassName())) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Returns a string version of date formatted using ISO-8601 (only the date,
	 * not the time).
	 *
	 * @param date
	 *            The date to get data from.
	 *
	 * @return a string version of date formatted using ISO-8601 (only the date,
	 *         not the time).
	 */
	public static String toIso8601StringDate(Date date) {
		TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd",
				Locale.ENGLISH);
		dateFormat.setTimeZone(utcTimeZone);
		return dateFormat.format(date);
	}


	/**
	 * Checks whether or not the application is alive, using PrefHelper.PREF_APP_NAME.
	 *
	 * @param context The context.
	 *
	 * @return Whether or not the application is alive.
	 */
	public static final boolean isApplicationAlive(Context context){
		ActivityManager am = (ActivityManager)context.getSystemService(Context.ACTIVITY_SERVICE);


		List<ActivityManager.RunningAppProcessInfo> list2= am.getRunningAppProcesses();
		String appPackageName = context.getApplicationContext().getPackageName();

		for (ActivityManager.RunningAppProcessInfo ti : list2) {
			if(appPackageName!=null && ti.processName.equalsIgnoreCase(appPackageName)){
					Log.restricted(appPackageName, " is Alive");
					return true;
			}
		}

		return false;
	}


	public static boolean isServiceAvailable(Context context, String serviceName) {
		final PackageManager packageManager = context.getPackageManager();
		try {
			final Intent intent = new Intent(context, Class.forName(serviceName));
			List resolveInfo = packageManager.queryIntentServices(intent,PackageManager.MATCH_DEFAULT_ONLY);
			if (resolveInfo.size() > 0) {
				return true;
			}
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}

		return false;
	}

	/**
	 * wait for nao context to be instantiated
	 * @return true if NaoContext was created before timeout, false otherwise
	 */
	public static boolean waitForNaoService() {
		long ts = System.currentTimeMillis();
		long MaxDelay = 5000;

		while(NaoServiceManager.getService() == null) {
			Log.alwaysWarn(TAG, "Waiting for NAO service ...");
			try {
				Thread.sleep(200);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}

			long elapsedTime = System.currentTimeMillis() - ts;

			if(elapsedTime > MaxDelay) {
				Log.alwaysError(TAG, "timeout waiting for NAO Service");
				return false; // timeout
			}
		}

		return true;
	}
}
