package com.polestar.helpers;

import java.io.File;

import android.content.Context;

import com.polestar.Constants;
import com.polestar.naosdk.api.INAOServiceManager;


public class LocalPathHelper {

    public static final String NAO_ROOT_DIR = Constants.NAO_ROOT_DIRECTORY;

    public static final String NAO_RELATIVE_PDBS_DIRECTORY = "pdbs";
    public static final String APP_JSON_FILE_NAME = "app.json";

    private Context myContext;

    public LocalPathHelper(Context myContext) {
        this.myContext = myContext.getApplicationContext();
    }

    // .nao
    public String localDir() {
        return getAppDirectory() + File.separator;
    }

    public String getAppDirectory() {
        return myContext.getExternalFilesDir(NAO_ROOT_DIR).getAbsolutePath();
    }

    public String getAppFilePath(String apiKey) {
        return localDir() + INAOServiceManager.getAPIKeyRelDirectory(apiKey) + File.separator + "app.json";
    }

}
