package com.polestar.helpers;

import com.polestar.models.Beacon;
import com.polestar.models.NAORegion;
import com.polestar.models.NaoApplication;
import com.polestar.models.Region;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonHelper {

    // jsonResponse = response from cloud to a login for test mode
    public static void buildDataFromApplicationsJson(String jsonResponse) {
        Beacon.list.clear();
        NAORegion.list.clear();
        NaoApplication.list.clear();
        NaoApplication.current = null;
        try {
            JSONArray jApps = new JSONArray(jsonResponse);
            if (jApps != null) {
                for (int i = 0; i < jApps.length(); i++) {
                    JSONObject empApp = jApps.getJSONObject(i);
                    String name = empApp.getString("name");
                    if (name == null || name.isEmpty()) {
                        name = "undefined";
                    }
                    String serviceKey = empApp.getString("service_key");
                    new NaoApplication(i, name, serviceKey);
                }
            }
        } catch (JSONException e) {
            Log.alwaysError("JsonHelper", "Error buildDataFromApplicationsJson " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }


}
