package com.polestar.helpers;
//____________________________________________________________________________________
//
//  AndroidDeviceInfo.java
// 
//  Pole Star Confidential Proprietary
//    Copyright (c) Pole Star 2012, All Rights Reserved
//    No publication authorized. Reverse engineering prohibited
//______________________________________________________________________________________


import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;

import com.polestar.naosdk.api.TMOBILETYPE;

/**
 * Holds the device information  (IMEI, etc.)<br />
 * Implemented as a singleton.
 *
 * @author sterrenoir
 */
public class AndroidDeviceInfo {

    public static com.polestar.naosdk.api.DeviceInfo get(Context context){

        String fullIMEI;
        String shortIMEI;
        String deviceModel;
        String osVersion;

        if (context == null) {
            Log.alwaysWarn(AndroidDeviceInfo.class.getName(), "AndroidDeviceInfo: Context null: defaulting fullIMEI to 0000");
            fullIMEI = "0000";
        }
        else if (checkPermission(context, Manifest.permission.READ_PHONE_STATE))
        {
            // THIS CODE MUST REMAIN THE SAME AS NaoLogger's NaoController::startLogging()!!
            fullIMEI = ((android.telephony.TelephonyManager) (context.getSystemService(Context.TELEPHONY_SERVICE))).getDeviceId();
            if ((fullIMEI == null) || (fullIMEI.length() < 4)) {
                // Note: imei == null on emulator, not seen on a real phone.
                Log.restricted(AndroidDeviceInfo.class.getName(), "IMEI could not be fetched; defaulting to 0000.");
                fullIMEI = "0000";
            }
        } else {
            Log.alwaysWarn(AndroidDeviceInfo.class.getName(), "android.permission.READ_PHONE_STATE  --> PERMISSION_DENIED");
            fullIMEI = "0000";
        }

        shortIMEI = fullIMEI.substring(fullIMEI.length() - 4, fullIMEI.length());

        // get device model replacing non alphanumeric characters
        deviceModel = android.os.Build.MODEL.replaceAll("[^A-Za-z0-9]", "-");

        osVersion = "Android" + Build.VERSION.RELEASE;

        Log.alwaysWarn(AndroidDeviceInfo.class.getName(), "Device model : \"" + deviceModel + "\"");
        String deviceName = deviceModel + shortIMEI;

        return new com.polestar.naosdk.api.DeviceInfo(
                    TMOBILETYPE.MOBILE_ANDROID,
                    deviceName,
                    shortIMEI,
                    System.getProperty("http.agent"),
                    osVersion,
                    context.getApplicationContext().getPackageName());
    }

    /**
     * checkPermission
     * Permission check
     *
     * @return true if the permission has been granted to the given package.
     */
    public static boolean checkPermission(Context ctx, String permission) {
		//String permission = "android.permission.READ_PHONE_STATE";
		if(android.os.Build.VERSION.SDK_INT >=  android.os.Build.VERSION_CODES.M){
			return (ctx.getApplicationContext().checkSelfPermission(permission) == PackageManager.PERMISSION_GRANTED);
		}

		return (ctx.getApplicationContext().checkCallingOrSelfPermission(permission) == PackageManager.PERMISSION_GRANTED);

    }
}
