/*
 * Decompiled with CFR 0.152.
 */
package com.alanapi.navigation;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.alanapi.navigation.BottomNavigationHelper;
import com.alanapi.navigation.BottomNavigationItem;
import com.alanapi.navigation.BottomNavigationTab;
import com.alanapi.navigation.FixedBottomNavigationTab;
import com.alanapi.navigation.R;
import com.alanapi.navigation.ShiftingBottomNavigationTab;
import com.alanapi.navigation.behaviour.BottomNavBarFabBehaviour;
import com.alanapi.navigation.behaviour.BottomVerticalScrollBehavior;
import com.alanapi.navigation.util.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

@CoordinatorLayout.DefaultBehavior(value=BottomVerticalScrollBehavior.class)
public class BottomNavigationBar
extends FrameLayout {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_FIXED = 1;
    public static final int MODE_SHIFTING = 2;
    public static final int BACKGROUND_STYLE_DEFAULT = 0;
    public static final int BACKGROUND_STYLE_STATIC = 1;
    public static final int BACKGROUND_STYLE_RIPPLE = 2;
    private static final int FAB_BEHAVIOUR_TRANSLATE_AND_STICK = 0;
    private static final int FAB_BEHAVIOUR_DISAPPEAR = 1;
    private static final int FAB_BEHAVIOUR_TRANSLATE_OUT = 2;
    private int mMode = 0;
    private int mBackgroundStyle = 0;
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private boolean mScrollable = false;
    private static final int MIN_SIZE = 3;
    private static final int MAX_SIZE = 5;
    ArrayList<BottomNavigationItem> mBottomNavigationItems = new ArrayList();
    ArrayList<BottomNavigationTab> mBottomNavigationTabs = new ArrayList();
    private static final int DEFAULT_SELECTED_POSITION = -1;
    private int mSelectedPosition = -1;
    private int mFirstSelectedPosition = 0;
    private OnTabSelectedListener mTabSelectedListener;
    private int mActiveColor;
    private int mInActiveColor;
    private int mBackgroundColor;
    private FrameLayout mBackgroundOverlay;
    private FrameLayout mContainer;
    private LinearLayout mTabContainer;
    private static final int DEFAULT_ANIMATION_DURATION = 200;
    private int mAnimationDuration = 200;
    private int mRippleAnimationDuration = 500;
    private float mElevation;
    private boolean mAutoHideEnabled;
    private boolean mIsHidden = false;

    public BottomNavigationBar(Context context) {
        this(context, null);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.parseAttrs(context, attrs);
        this.init();
    }

    @TargetApi(value=21)
    public BottomNavigationBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.parseAttrs(context, attrs);
        this.init();
    }

    private void parseAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BottomNavigationBar, 0, 0);
            this.mActiveColor = typedArray.getColor(R.styleable.BottomNavigationBar_bnbActiveColor, Utils.fetchContextColor(context, R.attr.colorAccent));
            this.mInActiveColor = typedArray.getColor(R.styleable.BottomNavigationBar_bnbInactiveColor, -3355444);
            this.mBackgroundColor = typedArray.getColor(R.styleable.BottomNavigationBar_bnbBackgroundColor, -1);
            this.mAutoHideEnabled = typedArray.getBoolean(R.styleable.BottomNavigationBar_bnbAutoHideEnabled, true);
            this.mElevation = typedArray.getDimension(R.styleable.BottomNavigationBar_bnbElevation, this.getResources().getDimension(R.dimen.bottomnavigationbar_elevation));
            this.setAnimationDuration(typedArray.getInt(R.styleable.BottomNavigationBar_bnbAnimationDuration, 200));
            switch (typedArray.getInt(R.styleable.BottomNavigationBar_bnbMode, 0)) {
                case 1: {
                    this.mMode = 1;
                    break;
                }
                case 2: {
                    this.mMode = 2;
                    break;
                }
                default: {
                    this.mMode = 0;
                }
            }
            switch (typedArray.getInt(R.styleable.BottomNavigationBar_bnbBackgroundStyle, 0)) {
                case 1: {
                    this.mBackgroundStyle = 1;
                    break;
                }
                case 2: {
                    this.mBackgroundStyle = 2;
                    break;
                }
                default: {
                    this.mBackgroundStyle = 0;
                }
            }
            typedArray.recycle();
        } else {
            this.mActiveColor = Utils.fetchContextColor(context, R.attr.colorAccent);
            this.mInActiveColor = -3355444;
            this.mBackgroundColor = -1;
            this.mElevation = this.getResources().getDimension(R.dimen.bottomnavigationbar_elevation);
        }
    }

    private void init() {
        this.setLayoutParams(new ViewGroup.LayoutParams(new ViewGroup.LayoutParams(-1, -2)));
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View parentView = inflater.inflate(R.layout.view_bottomnavigationbar_container, (ViewGroup)this, true);
        this.mBackgroundOverlay = (FrameLayout)parentView.findViewById(R.id.viewBottomNavigationBarContainer_flOverLay);
        this.mContainer = (FrameLayout)parentView.findViewById(R.id.viewBottomNavigationBarContainer_flContainer);
        this.mTabContainer = (LinearLayout)parentView.findViewById(R.id.viewBottomNavigationBarContainer_llItemContainer);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        }
        ViewCompat.setElevation((View)this, (float)this.mElevation);
        this.setClipToPadding(false);
    }

    public BottomNavigationBar addItem(BottomNavigationItem item) {
        this.mBottomNavigationItems.add(item);
        return this;
    }

    public BottomNavigationBar removeItem(BottomNavigationItem item) {
        this.mBottomNavigationItems.remove(item);
        return this;
    }

    public BottomNavigationBar setMode(int mode) {
        this.mMode = mode;
        return this;
    }

    public BottomNavigationBar setBackgroundStyle(int backgroundStyle) {
        this.mBackgroundStyle = backgroundStyle;
        return this;
    }

    public BottomNavigationBar setActiveColor(@ColorRes int activeColor) {
        this.mActiveColor = ContextCompat.getColor((Context)this.getContext(), (int)activeColor);
        return this;
    }

    public BottomNavigationBar setActiveColor(String activeColorCode) {
        this.mActiveColor = Color.parseColor((String)activeColorCode);
        return this;
    }

    public BottomNavigationBar setInActiveColor(@ColorRes int inActiveColor) {
        this.mInActiveColor = ContextCompat.getColor((Context)this.getContext(), (int)inActiveColor);
        return this;
    }

    public BottomNavigationBar setInActiveColor(String inActiveColorCode) {
        this.mInActiveColor = Color.parseColor((String)inActiveColorCode);
        return this;
    }

    public BottomNavigationBar setBarBackgroundColor(@ColorRes int backgroundColor) {
        this.mBackgroundColor = ContextCompat.getColor((Context)this.getContext(), (int)backgroundColor);
        return this;
    }

    public BottomNavigationBar setBarBackgroundColor(String backgroundColorCode) {
        this.mBackgroundColor = Color.parseColor((String)backgroundColorCode);
        return this;
    }

    public BottomNavigationBar setFirstSelectedPosition(int firstSelectedPosition) {
        this.mFirstSelectedPosition = firstSelectedPosition;
        return this;
    }

    private BottomNavigationBar setScrollable(boolean scrollable) {
        this.mScrollable = scrollable;
        return this;
    }

    public void initialise() {
        this.mSelectedPosition = -1;
        this.mBottomNavigationTabs.clear();
        if (!this.mBottomNavigationItems.isEmpty()) {
            this.mTabContainer.removeAllViews();
            if (this.mMode == 0) {
                this.mMode = this.mBottomNavigationItems.size() <= 3 ? 1 : 2;
            }
            if (this.mBackgroundStyle == 0) {
                this.mBackgroundStyle = this.mMode == 1 ? 1 : 2;
            }
            if (this.mBackgroundStyle == 1) {
                this.mBackgroundOverlay.setVisibility(8);
                this.mContainer.setBackgroundColor(this.mBackgroundColor);
            }
            int screenWidth = Utils.getScreenWidth(this.getContext());
            if (this.mMode == 1) {
                int[] widths = BottomNavigationHelper.getMeasurementsForFixedMode(this.getContext(), screenWidth, this.mBottomNavigationItems.size(), this.mScrollable);
                int itemWidth = widths[0];
                for (BottomNavigationItem currentItem : this.mBottomNavigationItems) {
                    FixedBottomNavigationTab bottomNavigationTab = new FixedBottomNavigationTab(this.getContext());
                    this.setUpTab(bottomNavigationTab, currentItem, itemWidth, itemWidth);
                }
            } else if (this.mMode == 2) {
                int[] widths = BottomNavigationHelper.getMeasurementsForShiftingMode(this.getContext(), screenWidth, this.mBottomNavigationItems.size(), this.mScrollable);
                int itemWidth = widths[0];
                int itemActiveWidth = widths[1];
                for (BottomNavigationItem currentItem : this.mBottomNavigationItems) {
                    ShiftingBottomNavigationTab bottomNavigationTab = new ShiftingBottomNavigationTab(this.getContext());
                    this.setUpTab(bottomNavigationTab, currentItem, itemWidth, itemActiveWidth);
                }
            }
            if (this.mBottomNavigationTabs.size() > this.mFirstSelectedPosition) {
                this.selectTabInternal(this.mFirstSelectedPosition, true, false);
            } else if (!this.mBottomNavigationTabs.isEmpty()) {
                this.selectTabInternal(0, true, false);
            }
        }
    }

    public BottomNavigationBar setTabSelectedListener(OnTabSelectedListener tabSelectedListener) {
        this.mTabSelectedListener = tabSelectedListener;
        return this;
    }

    public BottomNavigationBar setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mRippleAnimationDuration = (int)((double)animationDuration * 2.5);
        return this;
    }

    public void clearAll() {
        this.mTabContainer.removeAllViews();
        this.mBottomNavigationTabs.clear();
        this.mBottomNavigationItems.clear();
        this.mBackgroundOverlay.setVisibility(8);
        this.mContainer.setBackgroundColor(0);
        this.mSelectedPosition = -1;
    }

    public void selectTab(int newPosition) {
        this.selectTab(newPosition, true);
    }

    public void selectTab(int newPosition, boolean callListener) {
        this.selectTabInternal(newPosition, false, callListener);
    }

    private void setUpTab(BottomNavigationTab bottomNavigationTab, BottomNavigationItem currentItem, int itemWidth, int itemActiveWidth) {
        bottomNavigationTab.setInactiveWidth(itemWidth);
        bottomNavigationTab.setActiveWidth(itemActiveWidth);
        bottomNavigationTab.setPosition(this.mBottomNavigationItems.indexOf(currentItem));
        bottomNavigationTab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BottomNavigationTab bottomNavigationTabView = (BottomNavigationTab)v;
                BottomNavigationBar.this.selectTabInternal(bottomNavigationTabView.getPosition(), false, true);
            }
        });
        this.mBottomNavigationTabs.add(bottomNavigationTab);
        BottomNavigationHelper.bindTabWithData(currentItem, bottomNavigationTab, this);
        bottomNavigationTab.initialise(this.mBackgroundStyle == 1);
        this.mTabContainer.addView((View)bottomNavigationTab);
    }

    private void selectTabInternal(int newPosition, boolean firstTab, boolean callListener) {
        int oldPosition = this.mSelectedPosition;
        if (this.mSelectedPosition != newPosition) {
            if (this.mBackgroundStyle == 1) {
                if (this.mSelectedPosition != -1) {
                    this.mBottomNavigationTabs.get(this.mSelectedPosition).unSelect(true, this.mAnimationDuration);
                }
                this.mBottomNavigationTabs.get(newPosition).select(true, this.mAnimationDuration);
            } else if (this.mBackgroundStyle == 2) {
                if (this.mSelectedPosition != -1) {
                    this.mBottomNavigationTabs.get(this.mSelectedPosition).unSelect(false, this.mAnimationDuration);
                }
                this.mBottomNavigationTabs.get(newPosition).select(false, this.mAnimationDuration);
                final BottomNavigationTab clickedView = this.mBottomNavigationTabs.get(newPosition);
                if (firstTab) {
                    this.mContainer.setBackgroundColor(clickedView.getActiveColor());
                    this.mBackgroundOverlay.setVisibility(8);
                } else {
                    this.mBackgroundOverlay.post(new Runnable(){

                        @Override
                        public void run() {
                            BottomNavigationHelper.setBackgroundWithRipple((View)clickedView, (View)BottomNavigationBar.this.mContainer, (View)BottomNavigationBar.this.mBackgroundOverlay, clickedView.getActiveColor(), BottomNavigationBar.this.mRippleAnimationDuration);
                        }
                    });
                }
            }
            this.mSelectedPosition = newPosition;
        }
        if (callListener) {
            this.sendListenerCall(oldPosition, newPosition);
        }
    }

    private void sendListenerCall(int oldPosition, int newPosition) {
        if (this.mTabSelectedListener != null) {
            if (oldPosition == newPosition) {
                this.mTabSelectedListener.onTabReselected(newPosition);
            } else {
                this.mTabSelectedListener.onTabSelected(newPosition);
                if (oldPosition != -1) {
                    this.mTabSelectedListener.onTabUnselected(oldPosition);
                }
            }
        }
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        if (this.mIsHidden) {
            this.show(animate);
        } else {
            this.hide(animate);
        }
    }

    public void hide() {
        this.hide(true);
    }

    public void hide(boolean animate) {
        this.mIsHidden = true;
        this.setTranslationY(this.getHeight(), animate);
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean animate) {
        this.mIsHidden = false;
        this.setTranslationY(0, animate);
    }

    private void setTranslationY(int offset, boolean animate) {
        if (animate) {
            this.animateOffset(offset);
        } else {
            if (this.mTranslationAnimator != null) {
                this.mTranslationAnimator.cancel();
            }
            this.setTranslationY(offset);
        }
    }

    private void animateOffset(int offset) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate((View)this);
            this.mTranslationAnimator.setDuration((long)this.mRippleAnimationDuration);
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.cancel();
        }
        this.mTranslationAnimator.translationY((float)offset).start();
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public boolean isAutoHideEnabled() {
        return this.mAutoHideEnabled;
    }

    public void setAutoHideEnabled(boolean mAutoHideEnabled) {
        this.mAutoHideEnabled = mAutoHideEnabled;
    }

    public void setFab(FloatingActionButton fab) {
        ViewGroup.LayoutParams layoutParams = fab.getLayoutParams();
        if (layoutParams != null && layoutParams instanceof CoordinatorLayout.LayoutParams) {
            CoordinatorLayout.LayoutParams coLayoutParams = (CoordinatorLayout.LayoutParams)layoutParams;
            BottomNavBarFabBehaviour bottomNavBarFabBehaviour = new BottomNavBarFabBehaviour();
            coLayoutParams.setBehavior((CoordinatorLayout.Behavior)bottomNavBarFabBehaviour);
        }
    }

    private void setFab(FloatingActionButton fab, int fabBehaviour) {
        ViewGroup.LayoutParams layoutParams = fab.getLayoutParams();
        if (layoutParams != null && layoutParams instanceof CoordinatorLayout.LayoutParams) {
            CoordinatorLayout.LayoutParams coLayoutParams = (CoordinatorLayout.LayoutParams)layoutParams;
            BottomNavBarFabBehaviour bottomNavBarFabBehaviour = new BottomNavBarFabBehaviour();
            coLayoutParams.setBehavior((CoordinatorLayout.Behavior)bottomNavBarFabBehaviour);
        }
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public int getInActiveColor() {
        return this.mInActiveColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getCurrentSelectedPosition() {
        return this.mSelectedPosition;
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public static class SimpleOnTabSelectedListener
    implements OnTabSelectedListener {
        @Override
        public void onTabSelected(int position) {
        }

        @Override
        public void onTabUnselected(int position) {
        }

        @Override
        public void onTabReselected(int position) {
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1);

        public void onTabUnselected(int var1);

        public void onTabReselected(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabBehaviour {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackgroundStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

