package com.alanapi.navigation;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

class FixedBottomNavigationTab extends BottomNavigationTab {
    float labelScale;
    public FixedBottomNavigationTab(Context context) {
        super(context);
    }

    public FixedBottomNavigationTab(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FixedBottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public FixedBottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    void init() {
        paddingTopActive = (int) getResources().getDimension(R.dimen.bottomnavigationbar_fixed_height_top_padding_active);
        paddingTopInActive = (int) getResources().getDimension(R.dimen.bottomnavigationbar_fixed_height_top_padding_inactive);

        LayoutInflater inflater = LayoutInflater.from(getContext());
        View view = inflater.inflate(R.layout.view_bottomnavigationbar_fixed_item, this, true);
        containerView = view.findViewById(R.id.viewBottomNavigationBarFixedItem_flContainer);
        labelView = (TextView) view.findViewById(R.id.viewBottomNavigationBarFixedItem_tvFixedTitle);
        iconView = (ImageView) view.findViewById(R.id.viewBottomNavigationBarFixedItem_ivFixedIcon);
        badgeView = (TextView) view.findViewById(R.id.viewBottomNavigationBarFixedItem_tvFixedBadge);
        labelScale = getResources().getDimension(R.dimen.bottomnavigationbar_fixed_label_inactive) / getResources().getDimension(R.dimen.bottomnavigationbar_fixed_label_active);
        super.init();
    }

    @Override
    public void select(boolean setActiveColor, int animationDuration) {
        labelView.animate().scaleX(1).scaleY(1).setDuration(animationDuration).start();
        super.select(setActiveColor, animationDuration);
    }

    @Override
    public void unSelect(boolean setActiveColor, int animationDuration) {
        labelView.animate().scaleX(labelScale).scaleY(labelScale).setDuration(animationDuration).start();
        super.unSelect(setActiveColor, animationDuration);
    }
}
