/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.ServiceControl;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Remoting.RemotingChannels;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class ServiceBase
implements IDisposable {
    public static final int DEF_TCP_PORT = 8260;
    public static final int DEF_HTTP_PORT = 8261;
    protected String _serverName;
    protected boolean _useTcp = true;
    protected String _ip = "";
    protected long _port;
    protected RemotingChannels _channel;
    private String _portName;

    public ServiceBase() throws UnknownHostException {
        this._serverName = InetAddress.getLocalHost().getHostName();
    }

    public ServiceBase(String server, long port, boolean useTcp) throws UnknownHostException {
        this.setServerName(server);
        this.setPort(port);
        this.setUseTcp(useTcp);
        if (this._serverName == null || this._serverName.trim().equalsIgnoreCase("")) {
            this._serverName = InetAddress.getLocalHost().getHostName();
        }
    }

    private void dispose(boolean disposing) {
        if (disposing) {
            System.gc();
        }
    }

    public final void dispose() {
        this.dispose(true);
    }

    public String getIp() {
        return this._ip;
    }

    public final String getServerName() {
        return this._serverName;
    }

    public final void setServerName(String value) {
        this._serverName = value;
    }

    public final boolean getUseTcp() {
        return this._useTcp;
    }

    public final void setUseTcp(boolean value) {
        this._useTcp = value;
    }

    public final long getPort() {
        return this._port;
    }

    public final void setPort(long value) {
        this._port = value;
    }

    protected final void Start(TimeSpan timeout, String service) throws ManagementException {
    }
}

