/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management;

import com.alachisoft.ncache.licensing.ExpirationInfo;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.ncactivate.utils.AppUtil;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.Date;

public class ServerLicenseInfo
implements ICompactSerializable {
    public LicenseManager.LicenseType _licenseType;
    public String _version;
    public String _editionID;
    public long _evaluationDate;
    public String _registeredName;
    public String _companyName;
    public int _evalPeriod;
    public boolean _isReactivated;
    public boolean _isEval;
    public String _spVersion;
    public boolean _isServerOnly;
    public boolean _isPrepetual;
    public int _graceDays;
    public long _expirationDate;
    public boolean _isExpiring;
    public String _email = "";
    public boolean _isExpired;
    public boolean _expiredFromEvaluation = false;
    public String _installationVesion;
    public boolean _isTrial = false;
    private String _firstName;
    private String _lastName;
    private String evironmentName;
    private int clientCpus;
    private int clientCpusInUse;

    public ServerLicenseInfo() {
        this.load();
    }

    public boolean getIsExpiring() {
        try {
            return this._isExpiring;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsExpiring(boolean value) {
        this._isExpiring = value;
    }

    public boolean getISReactivated() {
        return this._isReactivated;
    }

    public void setISReactivated(boolean value) {
        this._isReactivated = value;
    }

    public boolean getIsPreEvalLicense() {
        return this._isEval;
    }

    public void setIsPreEvalLicense(boolean value) {
        this._isEval = value;
    }

    public boolean getIsServerOnly() {
        try {
            return this._isServerOnly;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsServerOnly(boolean value) {
        this._isServerOnly = value;
    }

    public boolean getIsTrialLicense() {
        return this._isTrial;
    }

    public void setIsTrialLicense(boolean value) {
        this._isTrial = false;
    }

    public boolean getIsPrepetual() {
        try {
            return this._isPrepetual;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setIsPrepetual(boolean value) {
        this._isPrepetual = value;
    }

    public int getGraceDays() {
        try {
            return this._graceDays;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setGraceDays(int value) {
        this._graceDays = value;
    }

    public long getExpirationDate() {
        try {
            return this._expirationDate;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setExpirationDate(long value) {
        this._expirationDate = value;
    }

    public boolean getIsExpired() {
        return this._isExpired;
    }

    public void setIsExpired(boolean value) {
        this._isExpired = value;
    }

    public boolean getExpiredFromEvaluation() {
        return this._expiredFromEvaluation;
    }

    public void setExpiredFromEvaluation(boolean value) {
        this._expiredFromEvaluation = value;
    }

    public LicenseManager.LicenseType getLicenseType() {
        return this._licenseType;
    }

    public void setLicenseType(LicenseManager.LicenseType value) {
        this._licenseType = value;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public String getInstallationVersion() {
        return this._installationVesion;
    }

    public void setInstallationVersion(String value) {
        this._installationVesion = value;
    }

    public String getSPVersion() {
        return this._spVersion;
    }

    public void setSPVersion(String value) {
        this._spVersion = value;
    }

    public String getEditionID() {
        return this._editionID;
    }

    public void setEditionID(String value) {
        this._editionID = value;
    }

    public long getEvaluationDate() {
        return this._evaluationDate;
    }

    public void setEvaluationDate(long value) {
        this._evaluationDate = value;
    }

    public String getEmail() {
        return this._email;
    }

    public void setEmail(String value) {
        this._email = value;
    }

    public String getRegisteredName() {
        return this._registeredName;
    }

    public void setRegisteredName(String value) {
        this._registeredName = value;
    }

    public String getCompanyName() {
        return this._companyName;
    }

    public void setCompanyName(String value) {
        this._companyName = value;
    }

    public int getEvaluationPeriod() {
        return this._evalPeriod;
    }

    public void setEvaluationPeriod(int value) {
        this._evalPeriod = value;
    }

    public String getEvironmentName() {
        return this.evironmentName;
    }

    public void setEvironmentName(String value) {
        this.evironmentName = value;
    }

    public int getClientCpus() {
        return this.clientCpus;
    }

    public void setClientCpus(int value) {
        this.clientCpus = value;
    }

    public int getClientCpusInUse() {
        return this.clientCpusInUse;
    }

    public void setClientCpusInUse(int value) {
        this.clientCpusInUse = value;
    }

    public String getFirstName() {
        return this._firstName;
    }

    public void setFirstName(String value) {
        this._firstName = value;
    }

    public String getLastName() {
        return this._lastName;
    }

    public void setLastName(String value) {
        this._lastName = value;
    }

    public void load() {
        try {
            this._licenseType = LicenseManager.LicenseMode(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExpirationInfo expirationInfo = LicenseManager.getExpirationInfo();
        this._expirationDate = new NCDateTime(expirationInfo.getExpirationDate().getTime()).getTicks();
        if (NCDateTime.getUTCNow().compareTo(expirationInfo.getExpirationDate().getTime()) < 0) {
            this._isExpiring = TimeSpan.subtract((Date)expirationInfo.getExpirationDate().getTime(), (Date)new Date()).getDays() <= 30;
        } else {
            int daysAfterExpiration = TimeSpan.subtract((Date)expirationInfo.getExpirationDate().getTime(), (Date)NCDateTime.getUTCNow()).getDays();
            if (daysAfterExpiration > this._graceDays) {
                this._isExpired = false;
            } else {
                this._isExpired = true;
                this._isExpiring = false;
            }
        }
        this._isServerOnly = expirationInfo.getIsServerOnly();
        this._graceDays = expirationInfo.getGracePeriod();
        this._isPrepetual = expirationInfo.isPerpetual();
        this._isTrial = expirationInfo.getIsTrial();
        this._isReactivated = LicenseManager.getReactivate();
        this._evalPeriod = LicenseManager.getEvaluationPeriod();
        this._companyName = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.Company);
        this.setEvironmentName(LicenseManager.getEnvironmentName());
        this.setClientCpus(LicenseManager.getClientCpus());
        this._firstName = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.FirstName);
        this._lastName = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.LastName);
        this._registeredName = this._firstName + " " + this._lastName;
        this._email = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.Email);
        this._evaluationDate = new NCDateTime(LicenseManager.getEvaluationDt().getTime()).getTicks();
        this._editionID = LicenseManager.ActivationInfo.getEditionID();
        this._spVersion = RegUtil.getKey((InfoType)InfoType.USER, (RegKeys)RegKeys.SpVersion);
        this._version = LicenseManager.getLicenseInfo().getVersion();
        this._expiredFromEvaluation = LicenseManager.getExpiredFromEvaluation();
        try {
            this._installationVesion = AppUtil.getVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deserialize(NCacheObjectInput reader) throws IOException, ClassNotFoundException {
        this._licenseType = LicenseManager.LicenseType.forValue((int)reader.readInt());
        Object tempVar = reader.readObject();
        this._version = (String)(tempVar instanceof String ? tempVar : null);
        Object tempVar2 = reader.readObject();
        this._editionID = (String)(tempVar2 instanceof String ? tempVar2 : null);
        this._evaluationDate = reader.readLong();
        Object tempVar3 = reader.readObject();
        this._registeredName = (String)(tempVar3 instanceof String ? tempVar3 : null);
        Object tempVar4 = reader.readObject();
        this._companyName = (String)(tempVar4 instanceof String ? tempVar4 : null);
        this._isEval = reader.readBoolean();
        this._evalPeriod = reader.readInt();
        this._isReactivated = reader.readBoolean();
        Object tempVar5 = reader.readObject();
        this._spVersion = (String)(tempVar5 instanceof String ? tempVar5 : null);
        this._isServerOnly = reader.readBoolean();
        this._isPrepetual = reader.readBoolean();
        this._graceDays = reader.readInt();
        this._expirationDate = reader.readLong();
        this._isExpiring = reader.readBoolean();
        Object tempVar6 = reader.readObject();
        this._email = (String)(tempVar6 instanceof String ? tempVar6 : null);
        this._isExpired = reader.readBoolean();
        this._expiredFromEvaluation = reader.readBoolean();
        Object tempVar7 = reader.readObject();
        this._installationVesion = (String)(tempVar7 instanceof String ? tempVar7 : null);
        this.setClientCpus(reader.readInt());
        Object tempVar8 = reader.readObject();
        this.setEvironmentName((String)(tempVar8 instanceof String ? tempVar8 : null));
        this.setClientCpusInUse(reader.readInt());
        this._isTrial = reader.readBoolean();
        Object tempVar9 = reader.readObject();
        this._firstName = (String)(tempVar9 instanceof String ? tempVar9 : null);
        Object tempVar10 = reader.readObject();
        this._lastName = (String)(tempVar10 instanceof String ? tempVar10 : null);
    }

    public void serialize(NCacheObjectOutput writer) throws IOException {
        writer.writeInt(this.getLicenseType().ordinal());
        writer.writeObject((Object)this.getVersion());
        writer.writeObject((Object)this.getEditionID());
        writer.writeLong(this.getEvaluationDate());
        writer.writeObject((Object)this.getRegisteredName());
        writer.writeObject((Object)this.getCompanyName());
        writer.writeBoolean(this.getIsPreEvalLicense());
        writer.write(this.getEvaluationPeriod());
        writer.writeBoolean(this.getISReactivated());
        writer.writeObject((Object)this.getSPVersion());
        writer.writeBoolean(this.getIsServerOnly());
        writer.writeBoolean(this.getIsPrepetual());
        writer.write(this.getGraceDays());
        writer.writeLong(this.getExpirationDate());
        writer.writeBoolean(this.getIsExpiring());
        writer.writeObject((Object)this.getEmail());
        writer.writeBoolean(this.getIsExpired());
        writer.writeBoolean(this.getExpiredFromEvaluation());
        writer.writeObject((Object)this.getInstallationVersion());
        writer.write(this.getClientCpus());
        writer.writeObject((Object)this.getEvironmentName());
        writer.write(this.getClientCpusInUse());
        writer.writeBoolean(this._isTrial);
        writer.writeObject((Object)this._firstName);
        writer.writeObject((Object)this._lastName);
    }
}

