/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Management.RPC;

import Alachisoft.NCache.Common.Communication.IChannel;
import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Communication.ITraceProvider;
import Alachisoft.NCache.Common.Communication.RequestManager;
import Alachisoft.NCache.Common.Communication.TcpChannel;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Net.DnsCache;
import Alachisoft.NCache.Management.CacheServer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class RemoteServerBase
implements IDisposable {
    protected RequestManager _requestManager;
    protected String _server;
    protected int _port;
    protected String _bindIP;

    public RemoteServerBase(String server, int port) throws IllegalAccessException, Exception {
        this(server, port, null);
    }

    public RemoteServerBase(String server, int port, String bindIp) throws IllegalAccessException, Exception {
        if (server == null) {
            throw new IllegalAccessException("server");
        }
        try {
            InetAddress address = DnsCache.ResolveName((String)server);
            if (address == null) {
                throw new Exception("Failed to resolve server address to IP. Server =" + server);
            }
            this._server = address.getHostAddress();
        }
        catch (UnknownHostException uhex) {
            throw new Exception("Cannot start cache on '" + server + "'. This operation might require other privileges.");
        }
        this._port = port;
        this._bindIP = bindIp;
    }

    public final int getRequestTimedout() {
        return this._requestManager.getRequestTimedout();
    }

    public final void setRequestTimedout(int value) {
        this._requestManager.setRequestTimedout(value);
    }

    protected abstract IChannelFormatter GetChannelFormatter();

    protected boolean InitializeInternal() {
        return true;
    }

    public final void Initialize(ITraceProvider traceProvider) throws Exception {
        TcpChannel channel = new TcpChannel(this._server, this._port, this._bindIP, traceProvider);
        channel.setFormatter(this.GetChannelFormatter());
        RequestManager requestManager = new RequestManager((IChannel)channel);
        channel.Connect();
        this._requestManager = requestManager;
        boolean initialized = false;
        try {
            initialized = this.InitializeInternal();
        }
        catch (RuntimeException e) {
            channel.Disconnect();
            this._requestManager = null;
            throw e;
        }
        if (!initialized) {
            channel.Disconnect();
            this._requestManager = null;
        }
    }

    public final void dispose() {
        if (this._requestManager != null) {
            this._requestManager.dispose();
        }
        CacheServer.disposedStaticCall();
    }
}

