package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Util.SecurityUtil;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Config.XmlConfigReader;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;

import java.util.Iterator;

public class ThinClientConfigManager extends CacheConfigManager {

    public static final int DEF_TCP_PORT = 8250;


    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId A string identifier of configuration.
     */
    public static CacheServerConfig GetConfigDom(String cacheId, String filePath, String userId, String password, boolean inProc) throws ManagementException, SecurityException {
        try {
            XmlConfigReader configReader = new XmlConfigReader(filePath, cacheId);
            CacheServerConfig config = configReader.GetConfigDom();

            if (config == null) {
                return config;
            }

            if (!inProc) {
                inProc = config.getInProc();
            }

            if (inProc) {
                boolean isAuthorize = false;

                if (config.getSecurity() != null && config.getSecurity().getEnabled()) {
                    String userName = "";
                    Alachisoft.NCache.Config.NewDom.User[] users = config.getSecurity().getUsers();
                    isAuthorize = false;
                    if (users != null) {
                        userName = ExtractUserName(userId);


                        for (Alachisoft.NCache.Config.NewDom.User user : users) {
                            if (user != null && parsedAdminUser(user.getId().toLowerCase()).equals(userName.toLowerCase())) {
                                isAuthorize = true;
                                break;
                            }
                        }
                    }

                    String domainController = config.getSecurity().getDomainController();
                    String port = config.getSecurity().getPort();

                    if (isAuthorize) {
                        isAuthorize = SecurityUtil.AuthorizeUserNamePassword(domainController, GetUserFullDn(config, userName), password, port);
                    }

                    if (!isAuthorize) {
                        throw new SecurityException("You do not have permissions to perform this operation");
                    }

                }
//#endif
                return config;
            }
            return null;
        } catch (SecurityException e) {
            throw e;
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    public static String parsedAdminUser(String userName) {
        String userNames = "";
        String[] splitUser = userName.split(",");
        String[] splits = new String[splitUser.length];
        for (String str : splitUser) {
            splits = str.split("-");
            if (splits[0].toLowerCase().contains("cn")) {
                userNames = splits[1].toString();
                break;
            }
        }
        return userNames;
    }

    public static String GetUserFullDn(CacheServerConfig config, String userName) {
        String userNames = "";
        Alachisoft.NCache.Config.NewDom.User[] users = config.getSecurity().getUsers();
        if (users != null) {
            for (int i = 0; i < users.length; i++) {
                if (parsedAdminUser(users[i].getId().toString().toLowerCase()).equals(userName)) {
                    userNames = users[i].getId().toString().replace("-", "=");
                }
            }
            return userNames;
        }
        return userNames;
    }

    /**
     * Initialize a registered cache given by the ID.
     *
     * @param cacheId A string identifier of configuration.
     */
    public static java.util.ArrayList GetCacheConfig(String cacheId, String filePath, String userId, String password, boolean inProc) throws ManagementException, Exception {
        try {
            XmlConfigReader configReader = new XmlConfigReader(filePath, cacheId);
            java.util.ArrayList propsList = configReader.getPropertiesList();
            java.util.ArrayList configsList = CacheConfig.GetConfigs(propsList, DEF_TCP_PORT);
            for (Iterator it = configsList.iterator(); it.hasNext(); ) {
                CacheConfig config = (CacheConfig) it.next();
                if (!inProc) {
                    inProc = config.getUseInProc();
                }
                break;
            }

            if (inProc) {

                boolean isAuthorize = false;
                java.util.HashMap ht = (java.util.HashMap) propsList.get(0);
                java.util.HashMap cache = (java.util.HashMap) ht.get("cache");

                if (cache.containsKey("security")) {
                    java.util.HashMap security = (java.util.HashMap) cache.get("security");
                    java.util.HashMap user = (java.util.HashMap) security.get("user");
                    String userName = ExtractUserName(userId);
                    isAuthorize = user.containsKey(userName);
                    String domainController = (String) security.get("domain-controller");
                    String port = (String) security.get("port");
                    //Security
                    //if (isAuthorize)
                    //    isAuthorize = ApiSecurityProvider.AuthorizeUserNamePassword(domainController, userName, password);

                    //if (!isAuthorize)
                    //{
                    //    throw new SecurityException("You do not have permissions to perform this operation");
                    //}


                    if (isAuthorize) {
                        isAuthorize = SecurityUtil.AuthorizeUserNamePassword(domainController, userName, password, port);
                    }

                    if (!isAuthorize) {
                        throw new SecurityException("You do not have permissions to perform this operation");
                    }

                }
                return configsList;
            }
            return null;
        } catch (SecurityException e) {
            throw e;
        } catch (ManagementException e2) {
            throw e2;
        } catch (Exception e) {
            throw new ManagementException(e.getMessage(), e);
        }
    }

    public static String ExtractUserName(String userId) {
        String userName = userId;
        int index = userName.lastIndexOf("\\");
        userName = userName.substring(index + 1);
        return userName;
    }
}
//    [Serializable]
//    public class ClientConfiguration
//    {
//        const string _priorityKey = "priority";
//        const string _balanceNodesKey = "balanceNodes";
//        string _cacheId;
//        Hashtable _cmptTypes;
//        static string _serverName;
//        Hashtable _servers = new Hashtable();
//        ArrayList _serversList = new ArrayList();
//        public ArrayList _serverList_PriorityBased = new ArrayList();
//        static int DEFAULT_PRIORITY = 1;
//        bool _isRegisteredLocal = false;
//        bool _nodeBalance = true;
//        bool _importHashmap = true; //[Ata] true by default. decision made by Sir Iqbal. Mail dated Mon 6/9/2008
//        SecurityConfiguration _securityConfig;
//        string _clientCacheID = "";
//        string _clientCacheSyncMode = "optimistic"; // alam:default mode will be Optimistic
//        static ClientConfiguration()
//        {
//            try
//            {
//                _serverName = System.Environment.MachineName;
//            }
//            catch (Exception) { }
//        }
//        public ClientConfiguration(string cacheId, Hashtable cmptTypes)
//        {
//            _cacheId = cacheId;
//            _cmptTypes = cmptTypes;
//        }
//        public ClientConfiguration(string cacheId, Hashtable cmptTypes, Hashtable servers)
//        {
//            _cacheId = cacheId;
//            _cmptTypes = cmptTypes;
//            _servers = servers;
//        }
//        public ClientConfiguration(string cacheId)
//        {
//            _cacheId = cacheId;
//        }
//        public SecurityConfiguration SecurityConfig
//        {
//            get { return _securityConfig; }
//            set { _securityConfig = value; }
//        }
//        public string CacheId
//        {
//            get { return _cacheId != null ? _cacheId.ToLower() : null; }
//            set { _cacheId = value; }
//        }
//        public bool BalanceNodes
//        {
//            get { return _nodeBalance; }
//            set { _nodeBalance = value; }
//        }
//        public string ClientCacheID
//        {
//            get { return _clientCacheID; }
//            set { _clientCacheID = value; }
//        }
//        public string ClientCacheSyncMode
//        {
//            get { return _clientCacheSyncMode; }
//            set {_clientCacheSyncMode = value; }
//        }
//        public bool ImportHashmap
//        {
//            get { return this._importHashmap; }
//            set { this._importHashmap = value; }
//        }
//        public Hashtable CompactTypes
//        {
//            get { return _cmptTypes; }
//            set { _cmptTypes = value; }
//        }
//        public Hashtable Servers
//        {
//            get { return _servers; }
//            set { _servers = value; }
//        }
//        public ArrayList ServersList
//        {
//            get { return _serversList; }
//            set { _serversList = value; }
//        }
//        public bool IsRegisteredLocal
//        {
//            get { return _isRegisteredLocal; }
//            set { _isRegisteredLocal = value; }
//        }
//        public bool AddServer(string serverName, int priority)
//        {
//            try
//            {
//                Hashtable child = new Hashtable(2);
//                child.Add(_priorityKey, priority);
//                _servers.Add(serverName.ToLower(), child);
//                _serverList_PriorityBased.Add(serverName);
//            }
//            catch (Exception)
//            {
//                return false;
//            }
//            return true;
//        }
///#if !THINCLIENT
//        public string ToXmlOrderedList()
//        {
//            StringBuilder sb = new StringBuilder();
//            string clientCacheID = string.Empty;
///#if !EXPRESS || (EXPRESS && PROFESSIONAL)
//            if (_clientCacheID.Trim().Length > 0)
//                sb.Append(ClientConfigManager.ENDSTRING + " <cache id =\"" + _cacheId + "\" client-cache-id=\"" + _clientCacheID.ToString().ToLower() + "\" client-cache-syncmode=\"" + _clientCacheSyncMode.ToString().ToLower() + "\" load-balance=\"" + _nodeBalance.ToString().ToLower() + "\">");
//            else
//                sb.Append(ClientConfigManager.ENDSTRING + " <cache id =\"" + _cacheId + "\" client-cache-id=\"" + clientCacheID.ToString().ToLower() + "\" client-cache-syncmode=\"" + _clientCacheSyncMode.ToString().ToLower() + "\" load-balance=\"" + _nodeBalance.ToString().ToLower() + "\">");
///#endif
///#if !EXPRESS
//            if (_securityConfig != null)
//            {
//                string securityXml = _securityConfig.ToXml();
//                if (securityXml != String.Empty) sb.Append(securityXml);
//            }
///#else
///#if !PROFESSIONAL
//            if (_clientCacheID.Trim().Length > 0)
//                sb.Append(ClientConfigManager.ENDSTRING + " <cache id =\"" + _cacheId + "\" client-cache-id=\"" + _clientCacheID.ToString().ToLower() + "\" load-balance=\"" + _nodeBalance.ToString().ToLower() + "\">");
//            else
//                sb.Append(ClientConfigManager.ENDSTRING + " <cache id =\"" + _cacheId + "\" load-balance=\"" + _nodeBalance.ToString().ToLower() + "\">");
///#endif
///#endif
//            check_for_localServer();
//            bool localhostIncluded = false;
//            IDictionaryEnumerator serversDict = Servers.GetEnumerator();
//            string tempserverName = ClientConfigManager.BindIP.ToLower();
//            IPAddress serverAddress = null;
//            for (int i = 0; i < _serverList_PriorityBased.Count; i++)
//            {
//                string serverName = _serverList_PriorityBased[i].ToString();
//                if (serverName.Equals(_serverName.ToLower()) || serverName.Equals(ClientConfigManager.BindIP) || ClientConfigManager.IpAddresses.Contains(serverName))
//                {
///#if !VS2003
//                    if (IPAddress.TryParse(tempserverName, out serverAddress))
//                        serverName = tempserverName;
///#endif
//                    localhostIncluded = true;
//                }
//                sb.Append(ClientConfigManager.ENDSTRING + "	<server name=\"" + serverName + "\"/>");
//            }
//            if (!localhostIncluded && IsRegisteredLocal)
//            {
///#if !VS2003
//                if (IPAddress.TryParse(tempserverName, out serverAddress))
//                    ClientConfigManager.LocalCacheId = tempserverName;
//                if (ClientConfigManager.LocalCacheId == "")
//                    ClientConfigManager.LocalCacheId = tempserverName;
///#endif
//                sb.Append(ClientConfigManager.ENDSTRING + "	<server name=\"" + ClientConfigManager.LocalCacheId + "\"/>");
//            }
//            sb.Append(ClientConfigManager.ENDSTRING + " </cache>");
//            return sb.ToString();
//        }
///#endif
//        //Alam : this function checks whether this local server is included in this cluster
//        // if exists then re-arrange the _serverList_PriorityBased
//        public void check_for_localServer()
//        {
//            ArrayList tempList = new ArrayList();
//            int index = _serverList_PriorityBased.IndexOf(_serverName.ToLower(), 0);
//            if (index < 0) index = _serverList_PriorityBased.IndexOf(ClientConfigManager.BindIP.ToLower(), 0);
//            if (index >= 0)
//            {
//                tempList.Add(_serverList_PriorityBased[index]);
//                for (int j = 0; j < _serverList_PriorityBased.Count; j++)
//                {
//                    if (j != index) tempList.Add(_serverList_PriorityBased[j]);
//                }
//                _serverList_PriorityBased = tempList;
//            }
//        }
//    }
