package Alachisoft.NCache.Management;

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:

import Alachisoft.NCache.Common.Exceptions.ManagementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.*;
import java.util.Iterator;
import java.util.Map;


public class SecurityConfigManager {

    public static java.util.HashMap securityMap = new java.util.HashMap();
    public static boolean _securityEnabled = false;
    public static String _ldapPath = "";
    public static String _ldapPort = "";

    public SecurityConfigManager() {
        //
        // TODO: Add constructor logic here
        //
    }

    /**
     * Loads security xml from the given file
     */
    public static void LoadSecurity() {
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS

        try {
            String filePath = SecurityConfiguration.getConfigurationPath();
            String enabled = "";
            File fXmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document document = dBuilder.parse(fXmlFile);
            document.getDocumentElement().normalize();
            NodeList enable = document.getElementsByTagName("enabled");
            NodeList ldap = document.getElementsByTagName("ldap");
            NodeList ldapPort = document.getElementsByTagName("port");

            if (enable != null) {
                Element enableElement = (Element) enable.item(0);
                enabled = enableElement.getFirstChild().getNodeValue().toLowerCase();
            }
            if (ldap != null) {
                Element ldapElement = (Element) ldap.item(0);
                _ldapPath = ldapElement.getFirstChild().getNodeValue();
            }
            if (ldapPort != null) {
                Element ldapPortElement = (Element) ldapPort.item(0);
                _ldapPort = ldapPortElement.getFirstChild().getNodeValue();
            }

            enabled = enabled.toLowerCase();

            _securityEnabled = Boolean.parseBoolean(enabled);

            if (_securityEnabled == true)
                securityMap = LoadSecurityXML(document);
        } catch (java.lang.Exception e) {
            //throw new Exception("Invalid security configuration file");
            _securityEnabled = false;
        }
//#endif
    }

    /**
     * Loads settings from specified xml document.
     */
    private static java.util.HashMap LoadSecurityXML(Document document) {
        java.util.HashMap cacheSecurity = new java.util.HashMap();


        NodeList nodeSec = document.getElementsByTagName("administrators");
        // NodeList apiSec = document.getElementsByTagName("users");

        //as we know there is always going to be single element for these two node.
        java.util.ArrayList cacheAdministrators = LoadNCacheAdministrators(nodeSec.item(0));
        //java.util.HashMap cacheUsers = LoadNCacheUsers(apiSec.item(0));

        cacheSecurity.put("administrators", cacheAdministrators);
        //cacheSecurity.put("users", cacheUsers);

        return cacheSecurity;
    }

    /**
     * Loads settings from specified xml document.
     */
    private static java.util.ArrayList LoadNCacheAdministrators(Node node) {
        java.util.ArrayList uids = new java.util.ArrayList();
        if (node != null) {
            NodeList uidList = ((Element) node).getElementsByTagName("uid");
            if (uidList != null) {
                if (uidList != null && uidList.getLength() > 0) {
                    for (int usersItem = 0; usersItem < uidList.getLength(); usersItem++) {
                        Node userNode = uidList.item(usersItem);
                        if (userNode.getNodeType() == Node.ELEMENT_NODE) {
                            Element userElement = (Element) userNode;
                            uids.add(userElement.getFirstChild().getNodeValue());
                        }
                    }
                }
            }
            ManagmentSecConfig.NCacheAdministrators = uids;
        }
        return uids;
    }

    /**
     * Loads settings from specified xml document.
     */
    private static java.util.HashMap LoadNCacheUsers(Node node) {
        Node cacheIdNodes = (Node) ((Element) node).getElementsByTagName("cache");
        java.util.HashMap caches = new java.util.HashMap();
        while (cacheIdNodes.hasChildNodes()) {
            if (cacheIdNodes.getClass() == Element.class) {
                Element cacheId = (Element) cacheIdNodes;
                if (cacheId.hasAttribute("id")) {
                    String cacheName = cacheId.getAttribute("id").toLowerCase();
                    java.util.ArrayList cacheData = LoadUsers(cacheId);
                    caches.put(cacheName, cacheData);
                }
            }
        }
        APISecConfig.oldCacheUsers = caches;
        APISecConfig.fillCacheList();
        return caches;
    }

    /**
     * Loads settings from specified xml document.
     */
    private static java.util.ArrayList LoadUsers(Element credentials) {
        java.util.ArrayList uids = new java.util.ArrayList();
        if (credentials != null) {
            NodeList uidList = credentials.getElementsByTagName("uid");
            if (uidList != null && uidList.getLength() > 0) {
                for (int usersItem = 0; usersItem < uidList.getLength(); usersItem++) {
                    Node userNode = uidList.item(usersItem);
                    if (userNode.getNodeType() == Node.ELEMENT_NODE) {
                        Element userElement = (Element) userNode;
                        uids.add(userElement.getFirstChild().getNodeValue());
                    }
                }
            }
        }
        return uids;
    }

    /**
     * Loads security xml from the given file
     */
    public static void UpdateSecurity(boolean enabled, java.util.HashMap newSecurityMap, String ldap, String ldapPort) {
        securityMap = new java.util.HashMap();
        try {
            synchronized (securityMap) {
                LoadSecurity();
                _securityEnabled = enabled;
                if (ldap != null) {
                    _ldapPath = "LDAP://" + ldap;
                }

                if (ldapPort == null || ldapPort.isEmpty()) {
                    _ldapPort = "389";
                } else {
                    _ldapPort = ldapPort;
                }

                java.util.ArrayList newAdminsList = (java.util.ArrayList) newSecurityMap.get("administrators");
                securityMap.put("administrators", ManagmentSecConfig.UpdateAdminsList(newAdminsList));

//                java.util.HashMap newCachesUsers = (java.util.HashMap) newSecurityMap.get("users");
//                if (newCachesUsers != null && newCachesUsers.size() > 0)
//                {
//                    securityMap.put("users", APISecConfig.UpdateCacheUserList(newCachesUsers));
//                }

                SaveConfiguration();
            }
        } catch (Exception ex) {
        }
    }

    public static void SaveConfiguration() throws ManagementException, FileNotFoundException, UnsupportedEncodingException, IOException {
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !EXPRESS
        //if (c_configFileName == null || c_configFileName == "")
        //    CombinePath();
        String filePath = SecurityConfiguration.getConfigurationPath();
        if (filePath.length() == 0) {
            throw new ManagementException("Can not locate cache configuration file. Installation might be corrupt.");
        }
        //Muneeb:   NR-1020	:	StreamWriter to changed to Writer/OutputStream/FileOutputStream
        OutputStream os = null;
        Writer writer = null;
        try {
            os = new FileOutputStream(filePath);
            writer = new OutputStreamWriter(os);
            writer.write(ToXml());
            writer.flush();
        } catch (RuntimeException e) {
            throw new ManagementException(e.getMessage(), e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (RuntimeException e) {
                }
                writer = null;
            }
            if (os != null) {
                try {
                    os.close();
                } catch (RuntimeException e2) {
                }
                os = null;
            }
        }


//        FileStream fs = null;
//        StreamWriter sw = null;
//
//        try
//        {
//            fs = new FileStream(filePath, FileMode.Create);
//            sw = new StreamWriter(fs);
//            sw.Write(ToXml());
//            sw.Flush();
//        }
//        catch (Exception e)
//        {
//            throw new ManagementException(e.getMessage(), e);
//        }
//        finally
//        {
//            if (sw != null)
//            {
//                sw.Close();
//            }
//            if (fs != null)
//            {
//                fs.Close();
//            }
//        }
//#endif
    }

    private static String ToXml() {
        StringBuilder sb = new StringBuilder();
        synchronized (securityMap) {
            sb.append("<!-- Security Configuration file for NCache 4.1 and later versions -->");

            sb.append("\n\n<cache-security>");

            String secEnabled = (_securityEnabled) ? "true" : "false";
            sb.append("\n\n\t<enabled>" + secEnabled + "</enabled>");

            sb.append(" <!-- This value shows whether security feature in NCache is enable or disable   -->");

            sb.append("\n\n<!-- LDAP path is required to log-on to domain. -->");

            sb.append("\n\t<ldap>" + _ldapPath + "</ldap>");

            sb.append("\n\t<port>" + _ldapPort + "</port>");

            sb.append("\n\n<!-- Following users are Administrators and are allowed to add 'this' node into their clusters and "
                    + "\n also allowed to perform Cache operations at API level for all Caches.-->");

            sb.append("\n\n\t<administrators>");
            if (ManagmentSecConfig.NCacheAdministrators != null && ManagmentSecConfig.NCacheAdministrators.size() > 0) {
                for (int i = 0; i < ManagmentSecConfig.NCacheAdministrators.size(); i++) {
                    sb.append("\n\t      <uid>" + ManagmentSecConfig.NCacheAdministrators.get(i) + "</uid>");
                }
            }
            sb.append("\n\t</administrators>");

            /*
             * sb.Append("\n\n<!-- Following users are allowed to perform cache operations at API level for a sepcific Cache-Id.-->");
             *
             * sb.Append("\n\n\t<ncache-users>"); if (APISecConfig.oldCacheUsers != null &&APISecConfig.oldCacheUsers.Count > 0) { sb.Append(cachesInfoToXml()); }
             *
             * sb.Append("\n\n\t</ncache-users>");
             */

            sb.append("\n\n</cache-security>");
        }
        return sb.toString();
    }

    private static String cachesInfoToXml() {
        StringBuilder sb = new StringBuilder();

        Iterator ide = APISecConfig.oldCacheUsers.entrySet().iterator();
        while (ide.hasNext()) {
            Map.Entry current = (Map.Entry) ide.next();
            String cacheName = current.getKey().toString();
            sb.append("\n\n\t   <cache id =\"" + cacheName + "\">");
            java.util.ArrayList userIds = (java.util.ArrayList) current.getValue();
            if (userIds != null && userIds.size() > 0) {
                for (int i = 0; i < userIds.size(); i++) {
                    sb.append("\n\t      <uid>" + userIds.get(i) + "</uid>");
                }
            }
            sb.append("\n\t   </cache>");
        }
        return sb.toString();
    }
}