package Alachisoft.NCache.Management.RPC;

import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Communication.ITraceProvider;
import Alachisoft.NCache.Common.Communication.RequestManager;
import Alachisoft.NCache.Common.Communication.TcpChannel;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Net.DnsCache;
import Alachisoft.NCache.Management.CacheServer;

import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class RemoteServerBase implements IDisposable {

    protected RequestManager _requestManager;
    protected String _server;
    protected int _port;
    protected String _bindIP;

    public RemoteServerBase(String server, int port) throws IllegalAccessException, Exception {
        this(server, port, null);

    }

    public RemoteServerBase(String server, int port, String bindIp) throws IllegalAccessException, Exception {
        if (server == null) {
            throw new IllegalAccessException("server");
        }
        //Muneeb: No such function as Resolve changing it to ResolveName
        try {
            InetAddress address = DnsCache.ResolveName(server);

            if (address == null) {
                throw new Exception("Failed to resolve server address to IP. Server =" + server);
            }
            _server = address.getHostAddress();
        } catch (UnknownHostException uhex) {
            throw new Exception("Cannot start cache on '" + server + "'. This operation might require other privileges.");
        }
        _port = port;
        _bindIP = bindIp;
    }

    public final int getRequestTimedout() {
        return _requestManager.getRequestTimedout();
    }

    public final void setRequestTimedout(int value) {
        _requestManager.setRequestTimedout(value);
    }

    protected abstract IChannelFormatter GetChannelFormatter();

    protected boolean InitializeInternal() {
        return true;
    }

    public final void Initialize(ITraceProvider traceProvider) throws Exception {
        TcpChannel channel = new TcpChannel(_server, _port, _bindIP, traceProvider);
        channel.setFormatter(GetChannelFormatter());
        RequestManager requestManager = new RequestManager(channel);
        channel.Connect();
        _requestManager = requestManager;

        boolean initialized = false;
        try {
            initialized = InitializeInternal();
        } catch (RuntimeException e) {
            channel.Disconnect();
            _requestManager = null;
            throw e;
        }

        if (!initialized) {
            channel.Disconnect();
            _requestManager = null;
        }
    }

    public final void dispose() {
        if (_requestManager != null) {
            _requestManager.dispose();
        }
        CacheServer.disposedStaticCall();

    }
}