package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.ServiceConfiguration;
import com.alachisoft.ncache.common.monitoring.*;

import com.alachisoft.ncache.runtime.util.TimeSpan;



public class MetricsTransporterImpl implements MetricsTransporter {
    private ICacheServer _cacheServer;

    private String  _bindedIp;

    public MetricsTransporterImpl()
    {

    }

    @Override
    public boolean getIsConnected() {
        return _cacheServer != null ? _cacheServer.getIsConnected() : false;
    }

    public final void Connect(String bindedIP) throws Exception {
        _bindedIp= bindedIP;
        Initialize();
    }

    public final void Disconnect()
    {
//        throw new ExecutionControl.NotImplementedException("Disconnect");
    }

    public final void dispose()
    {
        if (_cacheServer != null) _cacheServer.dispose();
    }

    public final void PublishMetadata(String sessionId, String version, ClientMetaData clientMeta) throws Exception {
        _cacheServer.PublishMetadata(sessionId, version, clientMeta);
    }

    public final void PublishMetadata(String sessionId, CounterMetadataCollection counterMeta) throws Exception {
        _cacheServer.PublishMetadata(sessionId, counterMeta);
    }

    public final PublishCountersDataResult PublishData(String session, CounterDataCollection data) throws Exception {
        return PublishCountersDataResult.forValue(_cacheServer.PublishData(session, data));
    }

    private void Initialize() throws Exception {

        NCacheRPCService cacheService = new NCacheRPCService(_bindedIp,ServiceConfiguration.getManagementPort());
        _cacheServer = cacheService.GetCacheServer(new TimeSpan(0, 0, 30));


    }

}
