package Alachisoft.NCache.Management;

import Alachisoft.NCache.Caching.*;
import Alachisoft.NCache.Caching.Statistics.CacheStatistics;
import Alachisoft.NCache.Common.Enum.CacheStatusOnServerContainer;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Exceptions.SuspectedException;
import Alachisoft.NCache.Common.Exceptions.TimeoutException;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.LoggingInfo;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatistics;
import Alachisoft.NCache.Common.Monitoring.ConfiguredCacheInfo;
import Alachisoft.NCache.Common.Monitoring.Node;
import Alachisoft.NCache.Common.StatusInfo;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import com.alachisoft.ncache.common.monitoring.ClientCustomCounters;
import com.alachisoft.ncache.common.monitoring.MetricsMonitor;
import com.alachisoft.ncache.common.monitoring.MetricsTransporter;
import com.alachisoft.ncache.licensing.LicenseInfo;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.*;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;

public interface ICacheServer extends IDisposable, MetricsMonitor {

    String GetClusterIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    String GetLocalCacheIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void SetLocalCacheIP(String ip) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * @param name   Name of the file (assembly)
     * @param buffer
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void CopyAssemblies(string cacheName, string assemblyFileName, byte[] buffer);
    void CopyAssemblies(String cacheName, String assemblyFileName, byte[] buffer) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * @param bridgeName
     * @param assemblyFileName
     * @param buffer
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void CopyBridgeAssemblies(string bridgeName, string assemblyFileName, byte[] buffer);
    void CopyBridgeAssemblies(String bridgeName, String assemblyFileName, byte[] buffer) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * @param cacheName
     * @param fileName
     * @return
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: byte[] GetAssembly(string cacheName, string fileName);
    byte[] GetAssembly(String cacheName, String fileName) throws java.io.IOException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Clear cache
     *
     * @param cacheId
     */
    void ClearCache(String cacheId) throws OperationFailedException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: bool Authorize(byte[] userId, byte[] password);

    /**
     * Get a list of running caches (local + clustered)
     *
     * @param userId   user id
     * @param password password
     * @return list of running caches
     */
    java.util.ArrayList GetRunningCaches(String userId, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    java.util.Map GetCacheProps(byte[] userId, byte[] password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * A collection of the cache infos registered with the server.
     * <p>
     * <p>
     * CacheProps are in new format now. Instead of saving the props string, it now saves CacheServerConfig instance:
     * <p>
     * |local-cache-id | CacheServerConfig instance |partitioned-replica-cache-id | IDictionary | replica-id | CacheServerConfig instance
     */
    java.util.Map CacheProps() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    CacheServerConfig GetCacheConfiguration(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    Alachisoft.NCache.Config.NewDom.CacheServerConfig GetNewConfiguration(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException, Exception;

    CacheInfo GetCacheInfo(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    String GetHostName() throws UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void ReloadSrvcConfig() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    int GetSocketServerPort() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    CacheRegisterationInfo GetUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception;

    /**
     * @param cacheId
     * @param partId
     * @param newNode
     * @param isJoining
     * @return
     * @throws ManagementException
     * @throws Exception
     */
    Alachisoft.NCache.Management.NewCacheRegisterationInfo GetNewUpdatedCacheConfiguration(String cacheId, String partId, String newNode, boolean isJoining) throws ManagementException, Exception;

    /**
     * Register cache
     *
     * @param cacheId
     * @param props
     * @param overwrite
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in Visual Basic).
     */
    boolean RegisterCache(String cacheId, CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ConfigurationException, UnknownHostException, ManagementException, java.lang.Exception;

    boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply) throws ConfigurationException, UnknownHostException, ManagementException, java.lang.Exception;

    /**
     * Adds Server Node
     *
     * @param cacheId
     * @param config
     * @param partId
     * @param overwrite
     * @param userId
     * @param password
     * @param hotApply
     * @return
     */
//    boolean RegisterCache(String cacheId, CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply, boolean isLocalNode) throws ManagementException, ConfigurationException, UnknownHostException, Exception, IllegalAccessException;
//   
//    boolean RegisterCache(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig config, String partId, boolean overwrite, byte[] userId, byte[] password, boolean hotApply, boolean isLocalNode) throws ManagementException, ConfigurationException, UnknownHostException, Exception, IllegalAccessException;

    NodeInfoMap GetNodeInfo() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    String CanApplyHotConfiguration(String cacheId, CacheServerConfig config) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void RemoveCacheServerFromClientConfig(String cacheId, String serverName) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, InterruptedException, TimeoutException, SecurityException;

    void RemoveCacheFromClientConfig(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, InterruptedException, TimeoutException, SecurityException;

    void UpdateClientServersList(String cacheId, CacheServerList serversPriorityList, String serverRuntimeContext) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void UpdateClientServersList(String cacheId, String[] servers, tangible.RefObject<String> xml, String clientCacheId, boolean loadBalance) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void UpdateSecurity(boolean enabled, java.util.HashMap newSecurityMap, String ldap, String ldapPort) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void UpdateUserSecurityCredentials(String cacheId, String[] users, String[] passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void GetUserSecurityCredentials(String cacheId, tangible.RefObject<String[]> users, tangible.RefObject<String[]> passwords) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    Object[] GetUserSecurityCredentials(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    ClientConfiguration GetClientConfiguration(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, InterruptedException, TimeoutException, UnsupportedEncodingException, SecurityException;

    void UpdateClientConfiguration(String cacheId, ClientConfiguration configuration) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    String GetBindIP() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    int GetClientConfigId() throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    Alachisoft.NCache.Config.NewDom.ClientNodeStatusWrapper GetClientNodeStatus(String cacheId) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    boolean VerifyWindowsUser(String nodeName, String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    //[salman]
    //Method introduced to check weather a user is a windows administrator or not
    boolean VerfyAdministrator(String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    boolean VerifyNodeAdministrator(String userName, String password) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Disbale logging
     *
     * @param subsystem Subsystem for which logging will be disabled
     * @param type      Type of logging to disable
     */
    void DisableLogging(LoggingInfo.LoggingSubsystem subsystem, LoggingInfo.LoggingType type) throws Exception;

    void SynchronizeClientConfig() throws UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Update TCP cache settings that includes updated list of TCP members
     *
     * @param cacheId
     * @param props
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in Visual Basic).
     */
//ORIGINAL LINE: bool ApplyCacheConfiguration(string cacheId, CacheServerConfig props, byte[] userId, byte[] password, bool hotApply);
    boolean ApplyCacheConfiguration(String cacheId, CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws java.lang.IllegalArgumentException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    boolean ApplyCacheConfiguration(String cacheId, Alachisoft.NCache.Config.NewDom.CacheServerConfig props, byte[] userId, byte[] password, boolean hotApply) throws java.lang.IllegalArgumentException, IllegalAccessException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException, Exception;

    /**
     * Un-register cache
     *
     * @param cacheId
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in Visual Basic).
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void UnregisterCache(string cacheId, string partId, byte[] userId, byte[] password);
    void UnregisterCache(String cacheId, String partId, byte[] userId, byte[] password, Boolean isGracefulShutdown, Boolean removeServerOnly) throws ManagementException, ParserConfigurationException, SAXException, IOException, InstantiationException, IllegalAccessException, Exception, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException;

    void StartCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, Exception;

    void StartCache(String cacheId, String partitionId) throws Exception;

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void StartCache(string cacheId, byte[] userId, byte[] password);
    void StartCache(String cacheId, byte[] userId, byte[] password) throws Exception;

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void StartCache(string cacheId, string partitionId, byte[] userId, byte[] password, bool twoPhaseInitialization);
    void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws SecurityException, Exception;

    void StartCachePhase2(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    //C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void StartCache(string cacheId, string partitionId, byte[] userId, byte[] password);
    void StartCache(String cacheId, String partitionId, byte[] userId, byte[] password) throws Exception;

    void StartCache(String cacheId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate) throws Exception;

    /**
     * Start a cache and provide call backs
     *
     * @param cahcheID
     * @param propertyString
     * @param itemAdded
     * @param itemRemoved
     * @param itemUpdated
     * @param cacheCleared
     * @return
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in Visual Basic).
     */
//C# TO JAVA CONVERTER WARNING: Unsigned integer types have no direct equivalent in Java:
//ORIGINAL LINE: void StartCache(string cacheId, string partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedCallback itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, bool twoPhaseInitialization);
    void StartCache(String cacheId, String partitionId, ItemAddedCallback itemAdded, ItemRemovedCallback itemRemoved, ItemUpdatedListener itemUpdated, CacheClearedCallback cacheCleared, CustomRemoveCallback customRemove, CustomUpdateCallback customUpdate, byte[] userId, byte[] password, boolean twoPhaseInitialization) throws Exception;

    void StopCache(String cacheId, byte[] userId, byte[] password, Boolean isGracefulShutdown) throws Exception;

//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:

    /**
     * Stop a cache
     *
     * @param cacheId
     * @throws IllegalArgumentException cacheId is a null reference (Nothing in Visual Basic).
     */
//ORIGINAL LINE: void StopCache(string cacheId, string partitionId, byte[] userId, byte[] password);
    void StopCache(String cacheId, String partitionId, byte[] userId, byte[] password, boolean isGracefulNodeShutdown) throws Exception;

    /**
     * Detect and return all the available NICs on this machine
     */
    java.util.HashMap DetectNICs() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void BindToIP(BindedIpMap bindIPMap) throws Exception;

    /**
     * @return
     */
    BindedIpMap BindedIp() throws Exception;

    /**
     * Gets the Max port number, among all the ports of registered caches on this machine
     *
     * @return Max cluster port
     */
    int GetMaxPort() throws java.net.UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Checks if the current cache is a Cluster cache or not, used in NCache UnReg cache tool as now UnReg is only applicable to cluster caches only
     *
     * @param cacheId
     * @return true if Cluster Cache
     */
    CacheStatusOnServerContainer IsClusteredCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Checks whether the specified port is available (non-conflicting) or not
     *
     * @param port Cluster port
     * @return 'true' if the port is available, otherwise 'flase'
     * @throws UnknownHostException
     */
    boolean PortIsAvailable(int port) throws UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Checks whether the newly added node arise port conflict or not
     *
     * @param port Cluster port
     * @return 'true' if the node is allowed, otherwise 'flase'
     */
    //internal bool NodeIsAllowed(int port)
    boolean NodeIsAllowed(int port, String id) throws UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Gets the status of NCache on this node.
     *
     * @return The ServerStatus.
     */
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
//#if !VS2003
    StatusInfo GetCacheStatus(String cacheId, String partitionId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

//#endif

    /**
     * Starts monitoring the client activity.
     */
    void StartMonitoringActivity() throws java.lang.Exception;

    /**
     * Stops monitoring client activity.
     */
    void StopMonitoringActivity() throws java.lang.Exception;

    /**
     * Publishes the observed client activity into a file.
     */
    void PublishActivity() throws CloneNotSupportedException, Exception;

    /**
     * Marks a mirror cache running on this node as active cache
     *
     * @param cacheId
     */
    void MakeCacheActive(String cacheId, boolean active) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Checks if given cache is configured ast bridge target cache
     *
     * @param cache
     * @return
     */
    boolean IsBridgeTargetCache(String cache) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Clears the content of given cache
     *
     * @param cacheId Id of the cache
     */
    void ClearCacheContent(String cacheId) throws OperationFailedException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Returns true if given cache is running
     *
     * @param cacheId
     * @return
     */
    boolean IsRunning(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Gets CacheStatistics for a given cache
     *
     * @param cacheId
     * @return
     */
    Alachisoft.NCache.Caching.Statistics.CacheStatistics GetStatistics(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    /**
     * Get count for given cache
     *
     * @param cacheId
     * @return
     */
    long GetCacheCount(String cacheId) throws GeneralFailureException, OperationFailedException, CacheException, ManagementException, InterruptedException, UnsupportedEncodingException, SecurityException;

    void BalanceDataloadOnCache(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, GeneralFailureException, SuspectedException, SecurityException;

    boolean IsCacheRegistered(String cacheId) throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    Node[] GetCacheServers(String cacheId) throws UnknownHostException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    ConfiguredCacheInfo[] GetAllConfiguredCaches() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    CacheNodeStatistics[] GetCacheStatistics(String cacheId) throws CacheException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    CacheStatistics GetCacheStatistics2(String cacheId) throws IllegalArgumentException, ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    ConfiguredCacheInfo[] GetConfiguredPartitionedReplicaCaches() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    LicenseInfo[] GetLicenses() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    String GetLicenseKey() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    java.util.HashMap GetSnmpPorts() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    void StopServer() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    public String GetServerPlatform() throws ManagementException, TimeoutException, UnsupportedEncodingException, InterruptedException, SecurityException;

    public ClientCacheStatus GetClientCahceStatus(String clientCacheID) throws ManagementException, ParserConfigurationException, ParserConfigurationException, InstantiationException, SAXException, IOException, IllegalAccessException;

    ServerLicenseInfo GetServerLicenseInfo() throws Exception;

    public java.util.ArrayList<Alachisoft.NCache.Common.Monitoring.ClientProcessStats> GetClientProcessStats(String cacheId) throws UnknownHostException;

    void PublishCustomClientCounters(String cacheId, ClientCustomCounters customCounters);
}