package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;

public class CacheServer implements Cloneable, InternalCompactSerializable {

    private String _serverName;
    private int _priority;

    @ConfigurationAttributeAnnotation(value = "name", appendText = "")
    public final String getServerName() {
        return _serverName;
    }

    @ConfigurationAttributeAnnotation(value = "name", appendText = "")
    public final void setServerName(String value) {
        _serverName = value;
    }

    public final int getPriority() {
        return _priority;
    }

    public final void setPriority(int value) {
        _priority = value;
    }

    @Override
    public String toString() {
        return _serverName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CacheServer) {
            CacheServer server = (CacheServer) ((obj instanceof CacheServer) ? obj : null);
            return server.getServerName().toLowerCase().equals(_serverName.toLowerCase());
        }

        return false;
    }

    @Override
    public int hashCode() {
        return _serverName.toLowerCase().hashCode();
    }

    //C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#region ICloneable Members
    public final Object clone() {
        CacheServer server = new CacheServer();
        server._serverName = _serverName;
        server._priority = _priority;

        return server;
    }

    //C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion
    //<editor-fold defaultstate="collapsed" desc="CompactS">
    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _serverName = (String) Common.readAs(reader.ReadObject(), String.class);
        _priority = reader.ReadInt32();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(_serverName);
        writer.Write(_priority);
    }
    //</editor-fold>
}