package Alachisoft.NCache.Management.ClientConfiguration.Dom;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Configuration.ConfigurationAttributeAnnotation;
import Alachisoft.NCache.Common.Configuration.ConfigurationSectionAnnotation;
import Alachisoft.NCache.Common.Enum.RtContextValue;
import Alachisoft.NCache.Management.ClientConfiguration.CacheServerList;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheConfiguration implements Cloneable, InternalCompactSerializable {

    private static String _serverName;
    private static String _bindIp;

    static {
        try {
            try {
                _serverName = java.net.InetAddress.getLocalHost().getHostName();
            } catch (UnknownHostException ex) {
                Logger.getLogger(CacheConfiguration.class.getName()).log(Level.SEVERE, null, ex);
            }
        } catch (RuntimeException e) {
        }
    }

    private String _cacheId;
    private String _clientCacheId = "";
    private String _clientCacheSyncMode = "optimistic";
    private String _defaultReadThruProvider = "";
    private String _defaultWriteThruProvider = "";
    private boolean _loadBalance = true;
    private boolean _isRegisteredLocal;
    private SecurityConfiguration _securityConfig;
    private CacheServerList _serversPriorityList = new CacheServerList();
    private RtContextValue _serverRuntimeContext;
    private boolean _enableClientLogs = false;
    private String _logLevel = "error";
    private boolean _skipUnavailableClientCache=true;
    private int _retryL1ConnectionInterval = 10;

    private Alachisoft.NCache.Config.NewDom.Encryption _encryption;

    public final boolean getIsRegisteredLocal() {
        return _isRegisteredLocal;
    }

    public final void setIsRegisteredLocal(boolean value) {
        _isRegisteredLocal = value;
    }

    //C# TO JAVA CONVERTER TODO TASK: Java annotations will not correspond to .NET attributes:
    //[ConfigurationAttribute("id")]
    @ConfigurationAttributeAnnotation(value = "id", appendText = "")
    public final String getCacheId() {
        return _cacheId;
    }

    @ConfigurationAttributeAnnotation(value = "id", appendText = "")
    public final void setCacheId(String value) {
        _cacheId = value;
    }

    @ConfigurationAttributeAnnotation(value = "client-cache-id", appendText = "")
    public final String getClientCacheId() {
        return _clientCacheId;
    }

    @ConfigurationAttributeAnnotation(value = "client-cache-id", appendText = "")
    public final void setClientCacheId(String value) {
        _clientCacheId = value;
    }

    @ConfigurationAttributeAnnotation(value = "client-cache-syncmode", appendText = "")
    public final String getClientCacheSyncMode() {
        return _clientCacheSyncMode;
    }

    @ConfigurationAttributeAnnotation(value = "client-cache-syncmode", appendText = "")
    public final void setClientCacheSyncMode(String value) {
        _clientCacheSyncMode = value;
    }

    @ConfigurationAttributeAnnotation(value = "default-readthru-provider", appendText = "")
    public final String getDefaultReadThruProvider() {
        return _defaultReadThruProvider;
    }

    @ConfigurationAttributeAnnotation(value = "default-readthru-provider", appendText = "")
    public final void setDefaultReadThruProvider(String value) {
        _defaultReadThruProvider = value;
    }

    @ConfigurationAttributeAnnotation(value = "default-writethru-provider", appendText = "")
    public final String getDefaultWriteThruProvider() {
        return _defaultWriteThruProvider;
    }

    @ConfigurationAttributeAnnotation(value = "default-writethru-provider", appendText = "")
    public final void setDefaultWriteThruProvider(String value) {
        _defaultWriteThruProvider = value;
    }

    @ConfigurationAttributeAnnotation(value = "load-balance", appendText = "")
    public final boolean getLoadBalance() {
        return _loadBalance;
    }

    @ConfigurationAttributeAnnotation(value = "load-balance", appendText = "")
    public final void setLoadBalance(boolean value) {
        _loadBalance = value;
    }

    @ConfigurationAttributeAnnotation(value = "enable-client-logs", appendText = "")
    public final boolean getEnableClientLogs() {
        return _enableClientLogs;
    }

    @ConfigurationAttributeAnnotation(value = "enable-client-logs", appendText = "")
    public final void setEnableClientLogs(boolean value) {
        _enableClientLogs = value;
    }

    @ConfigurationAttributeAnnotation(value = "log-level", appendText = "")
    public final String getLogLevel() {
        return _logLevel;
    }

    @ConfigurationAttributeAnnotation(value = "log-level", appendText = "")
    public final void setLogLevel(String value) {
        _logLevel = value;
    }

    @ConfigurationAttributeAnnotation(value = "skip-client-cache-if-unavailable", appendText = "")
    public boolean isSkipUnAvailableClientCache() { return _skipUnavailableClientCache; }

    @ConfigurationAttributeAnnotation(value = "skip-client-cache-if-unavailable", appendText = "")
    public void setSkipUnAvailableClientCache(boolean skipUnAvailableClientCache) { _skipUnavailableClientCache = skipUnAvailableClientCache; }

    @ConfigurationAttributeAnnotation(value = "reconnect-client-cache-interval", appendText = "")
    public int getRetryL1ConnectionInterval() { return _retryL1ConnectionInterval; }

    @ConfigurationAttributeAnnotation(value = "reconnect-client-cache-interval", appendText = "")
    public void setRetryL1ConnectionInterval(int retryL1ConnectionInterval) { _retryL1ConnectionInterval = _retryL1ConnectionInterval; }

    public final RtContextValue getServerRuntimeContext() {
        return _serverRuntimeContext;
    }

    public final void setServerRuntimeContext(RtContextValue serverRtContext) {
        _serverRuntimeContext = serverRtContext;
    }

    //@ConfigurationAttributeAnnotation(value = "server-runtime-context", appendText = "")
    public final String getServerRuntimeContextString() {
        if (_serverRuntimeContext == RtContextValue.JVCACHE)
            return "JVCACHE";
        else
            return "NCACHE";
    }

    //@ConfigurationAttributeAnnotation(value="server-runtime-context", appendText = "")
    public final void setServerRuntimeContextString(String value) {
        if ("JVCACHE".equals(value))
            _serverRuntimeContext = RtContextValue.JVCACHE;
        else if ("NCACHE".equals(value))
            _serverRuntimeContext = RtContextValue.NCACHE;
    }

    @ConfigurationSectionAnnotation(value = "server")
    public final CacheServer[] getServers() {
        //BringLocalServerToFirstPriority();
        CacheServer[] servers = new CacheServer[_serversPriorityList.getServersList().size()];
        for (java.util.Map.Entry<Integer, CacheServer> pair : _serversPriorityList.getServersList().entrySet()) {
            int priority = pair.getKey();
            CacheServer server = pair.getValue();
            server.setPriority(priority);
            servers[priority] = server;
        }

        return servers;
    }

    @ConfigurationSectionAnnotation(value = "server")
    public final void setServers(Object[] value) {
        for (int i = 0; i < value.length; i++) {
            _serversPriorityList.getServersList().put(i, (CacheServer) value[i]);
        }
    }

    @ConfigurationSectionAnnotation(value = "security")
    public final SecurityConfiguration getSecurityConfiguration() {
        return _securityConfig;
    }

    @ConfigurationSectionAnnotation(value = "security")
    public final void setSecurityConfiguration(SecurityConfiguration value) {
        _securityConfig = value;
    }

    public final CacheServerList getServersPriorityList() {
        return _serversPriorityList;
    }

    public final void setServersPriorityList(CacheServerList value) {
        _serversPriorityList = value;
    }

    public final String getBindIp() {
        return _bindIp;
    }

    public final void setBindIp(String value) {
        _bindIp = value;
    }

    public final boolean getClientCacheIsOptimistic() {
        return getClientCacheSyncMode().toLowerCase().compareTo("optimistic") == 0;
    }

    public final void setClientCacheIsOptimistic(boolean value) {
        if (value) {
            setClientCacheSyncMode("optimistic");
        } else {
            setClientCacheSyncMode("pessimistic");
        }
    }

    public final boolean RemoveServer(String serverName) {
        int serverPriority = 0;
        boolean found = false;

        if (_serversPriorityList != null) {
            for (CacheServer server : _serversPriorityList.getServersList().values()) {
                if (server.getServerName().toLowerCase().equals(serverName.toLowerCase())) {
                    serverPriority = server.getPriority();
                    found = true;
                    break;
                }
            }

            if (found) {
                _serversPriorityList.getServersList().remove(serverPriority);
                return true;
            }
        }

        return false;
    }

    public final boolean AddServer(String serverName, int priority) {
        CacheServer server = new CacheServer();
        server.setServerName(serverName);
        server.setPriority(priority);
        _serversPriorityList.getServersList().put(priority, server);
        return true;
    }

    public final boolean AddLocalServer(String bindedIp) {
        //using _serverName adds local machineName which is not what we want instead using bindedIp
        //return AddServer(!tangible.DotNetToJavaStringHelper.isNullOrEmpty(getBindIp()) ? getBindIp() : _serverName, 0);
        return AddServer(!tangible.DotNetToJavaStringHelper.isNullOrEmpty(getBindIp()) ? getBindIp() : bindedIp, 0);
    }

    private void BringLocalServerToFirstPriority() {
        java.util.HashMap<Integer, CacheServer> tempList = new java.util.HashMap<Integer, CacheServer>();
        int localServerPriority = 0;
        boolean localServerFound = false;

        for (java.util.Map.Entry<Integer, CacheServer> pair : _serversPriorityList.getServersList().entrySet()) {
            String serverName = pair.getValue().getServerName().toLowerCase();
            if ((serverName.compareTo(_serverName.toLowerCase()) == 0) || (serverName.compareTo(_bindIp.toLowerCase()) == 0)) {
                localServerFound = true;
                localServerPriority = pair.getKey();
                break;
            }
        }

        if (localServerFound) {
            tempList.put(0, _serversPriorityList.getServersList().get(localServerPriority));
            int priority = 1;
            for (java.util.Map.Entry<Integer, CacheServer> pair : _serversPriorityList.getServersList().entrySet()) {
                if (pair.getKey() != localServerPriority) {
                    tempList.put(priority++, pair.getValue());
                }
            }
            _serversPriorityList.setServersList(tempList);
        }
    }

    public final Alachisoft.NCache.Config.NewDom.Encryption getEncryptionConfiguration() {
        return _encryption;
    }

    public final void setEncryptionConfiguration(Alachisoft.NCache.Config.NewDom.Encryption value) {
        _encryption = value;
    }

    ///#region ICloneable Members
    public final Object clone() {
        CacheConfiguration configuration = new CacheConfiguration();
        configuration.setBindIp(_bindIp);
        configuration._cacheId = _cacheId;
        configuration._clientCacheId = _clientCacheId;
        configuration._clientCacheSyncMode = _clientCacheSyncMode;
        configuration._defaultReadThruProvider = _defaultReadThruProvider;
        configuration._defaultWriteThruProvider = _defaultWriteThruProvider;
        configuration._loadBalance = _loadBalance;

//        Object tempVar = _securityConfig.clone();
        configuration._securityConfig = _securityConfig != null ? (SecurityConfiguration) ((_securityConfig.clone() instanceof SecurityConfiguration) ? _securityConfig.clone() : null) : null;

        //Object tempVar2 = getServers().clone();
        configuration.setServers(getServers() != null ? (CacheServer[]) ((getServers().clone() instanceof CacheServer[]) ? getServers().clone() : null) : null);
        configuration._serverRuntimeContext = _serverRuntimeContext;
        configuration._enableClientLogs = _enableClientLogs;
        configuration._logLevel = _logLevel;
        configuration._retryL1ConnectionInterval =_retryL1ConnectionInterval;
        configuration._skipUnavailableClientCache= _skipUnavailableClientCache;
        return configuration;
    }
//C# TO JAVA CONVERTER TODO TASK: There is no preprocessor in Java:
    ///#endregion

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _cacheId = (String) Common.readAs(reader.ReadObject(), String.class);
        _clientCacheId = (String) Common.readAs(reader.ReadObject(), String.class);
        _clientCacheSyncMode = (String) Common.readAs(reader.ReadObject(), String.class);
        _defaultReadThruProvider = (String) Common.readAs(reader.ReadObject(), String.class);
        _defaultWriteThruProvider = (String) Common.readAs(reader.ReadObject(), String.class);
        _loadBalance = reader.ReadBoolean();
        _isRegisteredLocal = reader.ReadBoolean();
        _securityConfig = (SecurityConfiguration) Common.readAs(reader.ReadObject(), SecurityConfiguration.class);
        int length = reader.ReadInt32();
        for (int i = 0; i < length; i++) {
            _serversPriorityList.setServersList(reader.ReadInt32(), (CacheServer) Common.readAs(reader.ReadObject(), CacheServer.class));
        }
        _serverName = (String) Common.readAs(reader.ReadObject(), String.class);
        _bindIp = (String) Common.readAs(reader.ReadObject(), String.class);
        _serverRuntimeContext = "1".equals(Common.as(reader.ReadObject(), String.class)) ? RtContextValue.JVCACHE : RtContextValue.NCACHE;
        reader.ReadBoolean();
        _enableClientLogs = reader.ReadBoolean();
        _logLevel = (String) Common.readAs(reader.ReadObject(), String.class);
        _skipUnavailableClientCache = reader.ReadBoolean();
        _retryL1ConnectionInterval= reader.ReadInt32();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(_cacheId);
        writer.WriteObject(_clientCacheId);
        writer.WriteObject(_clientCacheSyncMode);
        writer.WriteObject(_defaultReadThruProvider);
        writer.WriteObject(_defaultWriteThruProvider);
        writer.Write(_loadBalance);
        writer.Write(_isRegisteredLocal);
        writer.WriteObject(_securityConfig);
        writer.Write(this._serversPriorityList.getServersList().size());
        Map.Entry current = null;
        Iterator ite = this._serversPriorityList.getServersList().entrySet().iterator();
        while (ite.hasNext()) {
            current = (Map.Entry) ite.next();
            writer.Write(((Integer) current.getKey()).intValue());
            writer.WriteObject(current.getValue());
        }
        writer.WriteObject(_serverName);
        writer.WriteObject(_bindIp);
        writer.WriteObject(_serverRuntimeContext == RtContextValue.JVCACHE ? "1" : "0");
        writer.Write(false);
        writer.Write(_enableClientLogs);
        writer.WriteObject(_logLevel);
        writer.Write(_skipUnavailableClientCache);
        writer.Write(_retryL1ConnectionInterval);
    }
}
