package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Monitoring.ClientProcessStats;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheConfiguration;
import Alachisoft.NCache.ServiceControl.NCacheService;
import Alachisoft.NCache.Common.ErrorHandling.ErrorCodes;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.ncactivate.utils.EnvironmentUtil;
import com.alachisoft.ncache.runtime.cachemanagement.CacheContext;
import com.alachisoft.ncache.runtime.cachemanagement.ServerNode;
import com.alachisoft.ncache.runtime.caching.ClientInfo;
import com.alachisoft.ncache.runtime.util.TimeSpan;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class CacheServerModerator {
    private static final int _port = 8250;
    private static final int JvCacheManagementPort = 8270;
    private static final int NCacheManagementPort = 8250;
    private static String config = "client.ncconf";
    private static String LOCALCACHE = "local-cache";
    private static String CLUSTEREDCACHE = "clustered-cache";
    private static NCacheRPCService _ncacheService;


    public CacheServerModerator() throws UnknownHostException {
//        _ncacheService = new NCacheService(null, true);
    }

    public static void StartCache(String cacheId, String serverName, int port, String userId, String password) throws UnknownHostException, ManagementException {
        ICacheServer cs = null;

        NCacheService cacheService = new NCacheRPCService(null);
        CacheServerConfig config = null;
        try {
            cacheService.setServerName(serverName);
            cacheService.setPort(port);
            cs = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));
            cs.StartCache(cacheId, EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password));
            if (cs != null)
                cs.StartCache(cacheId, EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password));
            
            // TODO (IN FUTURE) 5.0 SP3: StartCache in InProc Cache needs to be tested
            /*if (cs != null) {
                config = cs.GetCacheConfiguration(cacheId);
                if (config != null) {
                    if (!config.getInProc()) {
                        cs.StartCache(cacheId, EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password));
                    }
                } else {
                    throw new ManagementException("Unable to Start Cache. Specified cache is not registered.");
                }
            }*/
        } catch (Exception ex) {
            if (cs != null) {
                cs.dispose();
                cs = null;
            }
            throw new ManagementException(ex.getMessage());
        } finally {
            if (cs != null) {
                cs.dispose();
            }
            cacheService.dispose();
        }
    }

    public static void StopCache(String cacheId, String serverName, int port, String userId, String password, boolean isGracefulShutdown) throws UnknownHostException, ManagementException {
        ICacheServer cs = null;

        NCacheService cacheService = new NCacheRPCService(null);
        try {

            cacheService.setServerName(serverName);
            cacheService.setPort(port);
            cs = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));
            if (cs != null) {

                cs.StopCache(cacheId, EncryptionUtil.Encrypt(userId), EncryptionUtil.Encrypt(password), isGracefulShutdown);

            }
        } catch (Exception ex) {
            if (cs != null) {
                cs.dispose();
                cs = null;
            }
            throw new ManagementException(ex.getMessage());
        } finally {
            if (cs != null) {
                cs.dispose();
            }
            cacheService.dispose();
        }
    }

    public static Map<ServerNode, List<ClientInfo>> getCacheClients(String cacheName, String initialNodeName, CacheContext context, int port) throws ManagementException {
        NCacheService cacheService = GetCacheService(context);
        if (port != 0) {
            cacheService.setPort(port);
        }
        String startingNode = initialNodeName;
        CacheServerConfig cacheServerConfig = null;
        ICacheServer cacheServer = null;
        Map<ServerNode,List<ClientInfo>> clientList = new HashMap<ServerNode, List<ClientInfo>>();

        try {
            if (initialNodeName.equals("")) {
                cacheServerConfig = getCacheConfigThroughClientConfig(cacheName, port, context);

                if (cacheServerConfig == null) {
                    throw new ManagementException("cache with name " + cacheName + " not found in " + config);
                }
            } else {
                //if initial node not up then ???
                cacheService.setServerName(initialNodeName);
                cacheServer = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));
                if (cacheServer == null) {
                    throw new ManagementException("provided initial node not available");
                }

                cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);
                if (cacheServerConfig == null) {
                    throw new ManagementException(ErrorCodes.CacheInit.CACHE_NOT_REGISTERED_ON_NODE, ErrorMessages.getErrorMessage(ErrorCodes.CacheInit.CACHE_NOT_REGISTERED_ON_NODE, cacheName));
                }
            }

            //Copied Code from NCManager

            //For Local Cache
            if (cacheServerConfig.getCacheType().equalsIgnoreCase(LOCALCACHE)) {
                if (cacheServerConfig.getInProc()) {
                    throw new IllegalArgumentException("API is not supported for Local Inproc Cache");
                }

                cacheService.setServerName(EnvironmentUtil.getComputerName());
                cacheServer = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));

                if (cacheServer != null) {

                    if (cacheServer.IsRunning(cacheName)) {
                        ServerNode serverNode = new ServerNode();
                        serverNode.setServerIP(EnvironmentUtil.getComputerName());

                        ArrayList<ClientProcessStats> clients = cacheServer.GetClientProcessStats(cacheServerConfig.getName());
                        ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                        for (ClientProcessStats clientNode : clients) {
                            ClientInfo clientInfo = new ClientInfo();
                            clientInfo.setIPAddress(clientNode.getAddress().getIpAddress());
                            // cacheClient.Port = clientNode.Address.Port;
                            clientInfo.setProcessID(Integer.parseInt(clientNode.getProcessID()));
                            list.add(clientInfo);
                        }
                        clientList.put(serverNode, list);
                    }

                }
                return clientList;

            }
            //For Clustered Cache
            else {
                java.util.ArrayList initialHost = InitialHostList(cacheServerConfig.getCluster().getChannel().getInitialHosts());
                for (Object host : initialHost) {
                    try {
                        cacheService.setServerName((String) host);
                        cacheServer = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));
                        if (cacheServer.IsRunning(cacheName)) {
                            ServerNode serverNode = new ServerNode();
                            serverNode.setServerIP((String) ((host instanceof String) ? host : null));
                            serverNode.setPort(cacheServerConfig.getCluster().getChannel().getTcpPort());

                            ArrayList<ClientProcessStats> clients = cacheServer.GetClientProcessStats(cacheServerConfig.getName());
                            ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                            for (ClientProcessStats clientNode : clients) {
                                ClientInfo clientInfo = new ClientInfo();
                                clientInfo.setIPAddress(clientNode.getAddress().getIpAddress());
                                clientInfo.setProcessID(Integer.parseInt(clientNode.getProcessID()));
                                list.add(clientInfo);
                            }
                            clientList.put(serverNode, list);
                        }
                    } catch (Exception e) {

                    }
                }
                return clientList;
            }
        } catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        } finally {
            if (cacheServer != null) {
                cacheServer.dispose();
            }
            cacheService.dispose();
        }
    }


    public static com.alachisoft.ncache.runtime.cachemanagement.CacheHealth getCacheHealth(String cacheName, String initialNodeName, com.alachisoft.ncache.runtime.cachemanagement.CacheContext context, int port) throws ManagementException {
        _ncacheService = GetCacheService(context);

        if (port != 0) {
            _ncacheService.setPort(port);
        }

        String startingNode = initialNodeName;
        int _runningNodes = 0;
        Alachisoft.NCache.Config.Dom.CacheServerConfig cacheServerConfig = null;
        Alachisoft.NCache.Management.ICacheServer cacheServer = null;
        com.alachisoft.ncache.runtime.cachemanagement.CacheHealth cacheHealth = new com.alachisoft.ncache.runtime.cachemanagement.CacheHealth();

        try {
            if (initialNodeName.equals("")) {
                cacheServerConfig = getCacheConfigThroughClientConfig(cacheName, port, context);

                if (cacheServerConfig == null) {
                    return cacheHealth;
                    //throw new ManagementException("unable to get cache "+cacheName+" info from server or cache does not exist");
                }
            } else {
                //if initial node not up then ???
                _ncacheService.setServerName(initialNodeName);
                cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));

                if (cacheServer == null) {
                    throw new ManagementException("provided initial node not available");
                }

                cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);

                if (cacheServerConfig == null) {
                    throw new ManagementException("cache with name " + cacheName + " not registered on specified node");
                }
            }

            //For Local Cache
            if (cacheServerConfig.getCacheType().equalsIgnoreCase(LOCALCACHE)) {
                if (cacheServerConfig.getInProc()) {
                    throw new IllegalArgumentException("API is not supported for Local Inproc Cache");
                }

                _ncacheService.setServerName(InetAddress.getLocalHost().getHostName());
                cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));

                if (cacheServer != null) {
                    cacheHealth.setCacheName(cacheServerConfig.getName());
                    cacheHealth.setTopology(com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.LocalOutproc);
                    cacheHealth.setStatus(com.alachisoft.ncache.runtime.cachemanagement.CacheStatus.Stopped);

                    if (cacheServer.IsRunning(cacheHealth.getCacheName())) {
                        cacheHealth.setStatus(com.alachisoft.ncache.runtime.cachemanagement.CacheStatus.Running);
                    }
                }

                return cacheHealth;
            } //For Clustered Cache
            else {
                cacheHealth.setCacheName(cacheServerConfig.getName());
                cacheHealth.setTopology(GetCacheTopology(cacheServerConfig.getCluster().getCacheType()));
                cacheHealth.setStatus(com.alachisoft.ncache.runtime.cachemanagement.CacheStatus.Stopped);

                java.util.ArrayList<com.alachisoft.ncache.runtime.cachemanagement.NodeStatus> serverNodesList = new java.util.ArrayList<com.alachisoft.ncache.runtime.cachemanagement.NodeStatus>();

                java.util.ArrayList initialHost = InitialHostList(cacheServerConfig.getCluster().getChannel().getInitialHosts());

                for (Object host : initialHost) {
                    com.alachisoft.ncache.runtime.cachemanagement.NodeStatus nodeStats = new com.alachisoft.ncache.runtime.cachemanagement.NodeStatus();
                    try {
                        nodeStats.setNodeInfo(new com.alachisoft.ncache.runtime.cachemanagement.ServerNode());
                        nodeStats.getNodeInfo().setServerIP((String) host);
                        nodeStats.getNodeInfo().setPort(cacheServerConfig.getCluster().getChannel().getTcpPort());
                        nodeStats.setConnectivityStatus(com.alachisoft.ncache.runtime.cachemanagement.ConnectivityStatus.CacheStoped);

                        _ncacheService.setServerName((String) host);

                        cacheServer = _ncacheService.GetCacheServer(new TimeSpan(0, 0, 30));

                        if (cacheServer.IsRunning(cacheName)) {
                            cacheHealth.setStatus(com.alachisoft.ncache.runtime.cachemanagement.CacheStatus.Running);

                            nodeStats.setConnectivityStatus(com.alachisoft.ncache.runtime.cachemanagement.ConnectivityStatus.Running);

                            Alachisoft.NCache.Caching.Statistics.CacheStatistics cacheStats = cacheServer.GetStatistics(cacheName);

                            Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics clusterCacheStats = (Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics) ((cacheStats instanceof Alachisoft.NCache.Caching.Statistics.ClusterCacheStatistics) ? cacheStats : null);

                            java.util.ArrayList<com.alachisoft.ncache.runtime.cachemanagement.ServerNode> connectedNodesList = new java.util.ArrayList<com.alachisoft.ncache.runtime.cachemanagement.ServerNode>();

                            nodeStats.getNodeInfo().setServerIP(clusterCacheStats.getLocalNode().getAddress().getIpAddress().toString());
                            nodeStats.getNodeInfo().setPort(clusterCacheStats.getLocalNode().getAddress().getPort());

                            if (clusterCacheStats.getLocalNode().getIsStartedAsMirror()) {
                                nodeStats.getNodeInfo().setIsReplica(true);
                            }

                            for (Object node : clusterCacheStats.getNodes()) {
                                Alachisoft.NCache.Caching.Statistics.NodeInfo connectedNode = (Alachisoft.NCache.Caching.Statistics.NodeInfo) node;
                                com.alachisoft.ncache.runtime.cachemanagement.ServerNode tempNode = new com.alachisoft.ncache.runtime.cachemanagement.ServerNode();

                                if (!clusterCacheStats.getLocalNode().getAddress().equals(connectedNode.getAddress())) {
                                    tempNode.setServerIP(connectedNode.getAddress().getIpAddress().toString());
                                    tempNode.setPort(connectedNode.getAddress().getPort());

                                    if (connectedNode.getIsStartedAsMirror()) {
                                        tempNode.setIsReplica(true);
                                    }

                                    connectedNodesList.add(tempNode);
                                }
                            }

                            nodeStats.setConnectedNodes(connectedNodesList.toArray(new com.alachisoft.ncache.runtime.cachemanagement.ServerNode[0]));

                            if (clusterCacheStats.getClassName().equals("partitioned-replicas-server")) {
                                _runningNodes = _runningNodes + 2;
                            } else {
                                _runningNodes++;
                            }
                        } else {
                            nodeStats.setConnectedNodes(null);
                        }

                    } catch (RuntimeException e) {
                        // nodeStats._status = "JvCache service not running";
                    }

                    serverNodesList.add(nodeStats);
                }

                for (int i = 0; i < serverNodesList.size(); i++) {
                    com.alachisoft.ncache.runtime.cachemanagement.NodeStatus node = (com.alachisoft.ncache.runtime.cachemanagement.NodeStatus) serverNodesList.get(i);

                    if (node.getConnectedNodes() != null) {
                        if (node.getConnectedNodes().length == (_runningNodes - 1)) {
                            node.setConnectivityStatus(com.alachisoft.ncache.runtime.cachemanagement.ConnectivityStatus.FullyConnected);
                        } else if (node.getConnectedNodes().length < (_runningNodes - 1)) {
                            node.setConnectivityStatus(com.alachisoft.ncache.runtime.cachemanagement.ConnectivityStatus.PartialConnected);
                        }
                    }
                }
                cacheHealth.setServerNodesStatus(serverNodesList.toArray(new com.alachisoft.ncache.runtime.cachemanagement.NodeStatus[0]));

            }
            //End
        } catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        } finally {
            _ncacheService.dispose();
            _ncacheService = null;
        }

        return cacheHealth;
    }

    private static NCacheRPCService GetCacheService(com.alachisoft.ncache.runtime.cachemanagement.CacheContext context) {
        try {
            switch (context) {
                case TayzGrid:
                    return new NCacheRPCService("", JvCacheManagementPort);
                case NCache:
                    return new NCacheRPCService("", NCacheManagementPort);
            }
        } catch (Exception ex) {
        }

        return null;
    }

    private static java.util.ArrayList InitialHostList(String initialHostsColl) {
        java.util.ArrayList list = new java.util.ArrayList(5);
        String[] commaSplit = initialHostsColl.split("[,]", -1);
        for (String initialHost : commaSplit) {
            String[] split = initialHost.split("\\[");
            list.add(split[0]);
        }
        return list;
    }

    private static com.alachisoft.ncache.runtime.cachemanagement.CacheTopology GetCacheTopology(String topologyType) {

        if (topologyType.equals("replicated") || topologyType.equals("replicated-server")) {
            return com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.Replicated;

        } else if (topologyType.equals("partitioned") || topologyType.equals("partitioned-server")) {
            return com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.Partitioned;

        } else if (topologyType.equals("partition-replica") || topologyType.equals("partitioned-replicas-server")) {
            return com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.PartitionReplica;
        } else if (topologyType.equals("mirror") || topologyType.equals("mirror-server")) {
            return com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.Mirrored;

        } else {
            return com.alachisoft.ncache.runtime.cachemanagement.CacheTopology.None;
        }
    }

    private static CacheServerConfig getCacheConfigThroughClientConfig(String cacheName, int port, CacheContext context) throws ManagementException {
        CacheServerConfig cacheServerConfig = null;
        Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer[] serverNodes = null;
        ICacheServer cacheServer = null;

        NCacheService cacheService = GetCacheService(context);

        if (port != 0) {
            cacheService.setPort(port);
        }

        try {
            Alachisoft.NCache.Management.ClientConfiguration.Dom.ClientConfiguration clientConfiguration = Alachisoft.NCache.Management.ClientConfiguration.ClientConfigManager.GetClientConfiguration(cacheName);
            if (clientConfiguration != null) {
                HashMap<String, CacheConfiguration> cacheConfigurationMap = clientConfiguration.getCacheConfigurationsMap();
                CacheConfiguration cacheClientConfiguration = null;
                cacheClientConfiguration = cacheConfigurationMap.get(cacheName);
                if (cacheClientConfiguration == null) {
                    throw new ManagementException("cache not found in " + config);
                }

                serverNodes = cacheClientConfiguration.getServers();

                for (Alachisoft.NCache.Management.ClientConfiguration.Dom.CacheServer node : serverNodes) {
                    try {
                        cacheService.setServerName(node.getServerName());
                        cacheServer = cacheService.GetCacheServer(new TimeSpan(0, 0, 0, 30));
                        if (cacheServer != null) {
                            cacheServerConfig = cacheServer.GetCacheConfiguration(cacheName);
                            cacheServer.dispose();
                            cacheServer = null;

                            if (cacheServerConfig != null) {
                                break;
                            }
                        }

                    } catch (Exception ex) {

                    }
                }

            } else {
                throw new ManagementException("error while fetching info from " + config);
            }
        } catch (Exception e) {
        } finally {
            if (cacheServer != null) {
                cacheServer.dispose();
            }
            if (cacheService != null) {
                cacheService.dispose();
            }
        }
        return cacheServerConfig;

    }

}