package Alachisoft.NCache.Management;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;

import java.io.IOException;
import java.util.ArrayList;

public class CacheRegisterationInfo implements InternalCompactSerializable {
    private CacheServerConfig _updatedCacheConfig;
    private java.util.ArrayList _affectedNodesList;
    private java.util.ArrayList _affectedPartitions;

    public CacheRegisterationInfo() {
    }

    public CacheRegisterationInfo(CacheServerConfig cacheConfig, java.util.ArrayList nodesList, java.util.ArrayList affectedPartitions) {
        _updatedCacheConfig = cacheConfig;
        _affectedNodesList = nodesList;
        _affectedPartitions = affectedPartitions;
    }

    public final CacheServerConfig getUpdatedCacheConfig() {
        return _updatedCacheConfig;
    }

    public final java.util.ArrayList getAffectedNodes() {
        return _affectedNodesList;
    }

    public final java.util.ArrayList getAffectedPartitions() {
        return _affectedPartitions;
    }


    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        _updatedCacheConfig = (CacheServerConfig) Common.readAs(reader.ReadObject(), CacheServerConfig.class);
        _affectedNodesList = (ArrayList) Common.readAs(reader.ReadObject(), ArrayList.class);
        _affectedPartitions = (ArrayList) Common.readAs(reader.ReadObject(), ArrayList.class);
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject(_updatedCacheConfig);
        writer.WriteObject(_affectedNodesList);
        writer.WriteObject(_affectedPartitions);
    }
}