/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.util.HashMap;
import java.util.Map;
import net.sf.launch4j.config.LanguageID;

public class VersionInfo {
    private static Map<String, LanguageID> LANGUAGE_TO_LANGUAGE_ID = new HashMap<String, LanguageID>();
    String fileVersion;
    String txtFileVersion;
    String fileDescription;
    String copyright;
    String productVersion;
    String txtProductVersion;
    String productName;
    String companyName;
    String internalName;
    String originalFilename;
    String language;
    String trademarks;
    int languageIndex;

    net.sf.launch4j.config.VersionInfo toL4j() {
        net.sf.launch4j.config.VersionInfo ret = new net.sf.launch4j.config.VersionInfo();
        ret.setFileVersion(this.fileVersion);
        ret.setTxtFileVersion(this.txtFileVersion);
        ret.setFileDescription(this.fileDescription);
        ret.setCopyright(this.copyright);
        ret.setProductVersion(this.productVersion);
        ret.setTxtProductVersion(this.txtProductVersion);
        ret.setProductName(this.productName);
        ret.setCompanyName(this.companyName);
        ret.setInternalName(this.internalName);
        ret.setOriginalFilename(this.originalFilename);
        ret.setLanguage(LANGUAGE_TO_LANGUAGE_ID.get(this.language));
        if (this.isLanguageIndex()) {
            ret.setLanguageIndex(this.languageIndex);
        }
        ret.setTrademarks(this.trademarks);
        return ret;
    }

    private boolean isLanguageIndex() {
        for (LanguageID languageID : LanguageID.values()) {
            if (languageID.getIndex() != this.languageIndex) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "VersionInfo{fileVersion='" + this.fileVersion + '\'' + ", txtFileVersion='" + this.txtFileVersion + '\'' + ", fileDescription='" + this.fileDescription + '\'' + ", copyright='" + this.copyright + '\'' + ", productVersion='" + this.productVersion + '\'' + ", txtProductVersion='" + this.txtProductVersion + '\'' + ", productName='" + this.productName + '\'' + ", companyName='" + this.companyName + '\'' + ", internalName='" + this.internalName + '\'' + ", originalFilename='" + this.originalFilename + '\'' + ", language='" + this.language + '\'' + ", trademarks='" + this.trademarks + '\'' + ", languageIndex=" + this.languageIndex + '}';
    }

    static {
        for (LanguageID languageID : LanguageID.values()) {
            LANGUAGE_TO_LANGUAGE_ID.put(languageID.name(), languageID);
        }
    }
}

