/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import com.akamai.android.sdk.util.AnaUtils;

public class AnaBitRateCalculator {
    private static AnaBitRateCalculator sInstance;
    private long mStartTimeMills;
    private static final int REFRESH_TIME_THRESHOLD_MILLIS = 60000;
    private long mBitrateSum;
    private long mAverageBitRate;
    private long mAverageRTT;
    private long mRTTSum;
    private int mBitRateCount;

    public static synchronized AnaBitRateCalculator getInstance() {
        if (sInstance == null) {
            sInstance = new AnaBitRateCalculator();
        }
        return sInstance;
    }

    public synchronized void addBitRate(long l2, long l3, long l4) {
        long l5 = l2 / l3;
        if (this.mBitRateCount == 0) {
            this.mStartTimeMills = System.currentTimeMillis();
        }
        if (AnaUtils.getCurrentUTCTimeInMillis() - this.mStartTimeMills >= 60000L) {
            this.mStartTimeMills = System.currentTimeMillis();
            this.mBitRateCount = 1;
            this.mBitrateSum = l5;
            this.mRTTSum = l4;
        } else {
            this.mBitrateSum += l5;
            this.mRTTSum += l4;
            ++this.mBitRateCount;
        }
        this.mAverageBitRate = this.mBitrateSum / (long)this.mBitRateCount;
        this.mAverageRTT = this.mRTTSum / (long)this.mBitRateCount;
    }

    public synchronized long getAverageBitRate() {
        if (System.currentTimeMillis() - this.mStartTimeMills < 60000L) {
            return this.mAverageBitRate;
        }
        return 0L;
    }

    public synchronized long getAverageRTT() {
        if (System.currentTimeMillis() - this.mStartTimeMills < 60000L) {
            return this.mAverageRTT;
        }
        return 0L;
    }

    public synchronized void clear() {
        this.mBitRateCount = 0;
        this.mBitrateSum = 0L;
        this.mAverageBitRate = 0L;
        this.mAverageRTT = 0L;
        this.mRTTSum = 0L;
        this.mStartTimeMills = 0L;
    }
}

