/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaConfigHandler;
import com.akamai.android.sdk.internal.AkaInterceptorHandler;
import com.akamai.android.sdk.internal.AkaSegmentManifestDownloader;
import com.akamai.android.sdk.internal.AkaSessionHandler;

public class AkaResetSdkController
extends Worker {
    public static final String LOG_TAG = "AkaResetSdkController";
    static final String SUBSCRIBED_SEGMENTS = "subscribed_segments";
    private Context mContext;

    public AkaResetSdkController(@NonNull Context context, @NonNull WorkerParameters workerParameters) {
        super(context, workerParameters);
        this.mContext = context;
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        try {
            AkaInterceptorHandler.removeCookies();
            AkaConfigHandler.removeData(this.mContext);
            AkaSegmentManifestDownloader.removeData(this.mContext);
            String string = this.getInputData().getString(SUBSCRIBED_SEGMENTS);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                AkaSessionHandler.setUserSegments(this.mContext, string, false);
            }
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaResetSdkController MAP segments are:" + string));
            return ListenableWorker.Result.success();
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)LOG_TAG, (Throwable)exception);
            return ListenableWorker.Result.failure();
        }
    }
}

