/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.db;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.util.VocUtils;

class AnaDatabaseSchema
extends SQLiteOpenHelper {
    public static final String TABLE_FEEDITEM = "feeditem";
    public static final String TABLE_FEEDITEM_TMP = "feeditem_tmp";
    public static final String TABLE_FEEDPOLICY = "feedpolicy";
    public static final String TABLE_CONTENT_SOURCE = "contentsource";
    private static final String TABLE_CONSUMPTION_STATS = "consumptionstats";
    private static final String TABLE_ADS_CONSUMPTION_STATS = "adsconsumptionstats";
    private static final String TABLE_DOWNLOAD_STATS = "downloadstats";
    private static final String TABLE_RATING_STATS = "ratingstats";
    private static final String TABLE_FEEDCATEGORY = "feedcategory";
    private static final String TABLE_FEEDTAG = "feedtag";
    private static final String TABLE_FEEDSTREAM = "feedstream";
    private static final String TABLE_CATEGORYKEYWORDS = "categorykeywords";
    private static final String TABLE_FEEDTOPICS = "feedtopics";
    private static final String TABLE_SEARCHWORDS = "searchwords";
    public static final String TABLE_HTTP_STATS = "httpstats";
    public static final String TABLE_SESSION_STATS = "sessionstats";
    public static final String TABLE_USER_EVENTS = "userevents";
    public static final String TABLE_EVENT_LOG = "eventlog";
    public static final String TABLE_SEGMENT = "segment";
    public static final String TABLE_DELETED_FEEDS = "deletedfeeds";
    private static final String TABLE_FILE_GROUP = "filegroup";
    public static final String TABLE_MESSAGE_LIST = "messagelist";
    private static final String TABLE_HLS_TRACK = "track";
    private static final String TABLE_DASH_TRACK = "dashtrack";
    private static final String TABLE_HLS_VARIANT = "variant";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_PROVIDER = "provider";
    public static final String COLUMN_LANGUAGE = "language";
    public static final String COLUMN_URL = "url";
    public static final String COLUMN_VIDEOFILE = "videofile";
    public static final String COLUMN_FEEDTYPE = "feedtype";
    private static final String COLUMN_FEED_SUBTYPE = "feedsubtype";
    private static final String COLUMN_ATTRIBUTE = "attribute";
    private static final String COLUMN_AUTO_DOWNLOAD = "autodownload";
    private static final String COLUMN_FILE_NAME = "filename";
    public static final String COLUMN_SIZE = "size";
    public static final String COLUMN_TIMESTAMP = "timestamp";
    public static final String COLUMN_RESOURCEREADY = "resourceready";
    public static final String COLUMN_DURATION = "duration";
    public static final String COLUMN_VIEWCOUNT = "viewcount";
    public static final String COLUMN_SUBSCRIBED = "subscribed";
    public static final String COLUMN_PRIORITY = "priority";
    private static final String COLUMN_STREAM_QUALITY = "quality";
    public static final String COLUMN_PREFERRED_QUALITY = "preferredquality";
    public static final String COLUMN_AVAILABILITY_TS = "availability_ts";
    public static final String COLUMN_CREATION_TIMESTAMP = "creationtimestamp";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_SOURCE_PATH = "sourcePath";
    public static final String COLUMN_SYNC_PENDING = "syncPending";
    public static final String COLUMN_DOWNLOAD_STATE = "downloadState";
    public static final String COLUMN_BYTES_DOWNLOADED = "bytesDownloaded";
    public static final String COLUMN_DOWNLOAD_FAILURE_ERROR_CODE = "downloadFailureErrorCode";
    public static final String COLUMN_MARK_FOR_DOWNLOAD_TIMESTAMP = "markForDownloadTimestamp";
    public static final String COLUMN_DOWNLOAD_COMPLETION_TIMESTAMP = "downloadCompletionTimestamp";
    public static final String COLUMN_STORAGE_PREFERENCE = "storagePreference";
    public static final String COLUMN_DOWNLOAD_INITIATED_TIMESTAMP = "downloadInitiatedTimestamp";
    public static final String COLUMN_DL_URL = "dlUrl";
    public static final String COLUMN_DOWNLOADTYPE = "downloadtype";
    private static final String COLUMN_DOWNLOADQUALITY = "downloadquality";
    private static final String COLUMN_NETWORK_TYPE = "network";
    public static final String COLUMN_FEED_ID = "feedid";
    public static final String COLUMN_RESP_HEADERS = "responseheaders";
    public static final String COLUMN_REFRESH_TIMESTAMP = "refreshtimestamp";
    public static final String COLUMN_MAX_AGE = "maxage";
    public static final String COLUMN_TTFB = "ttfb";
    public static final String COLUMN_BATTERY_LEVEL = "batterylevel";
    public static final String COLUMN_CHARGING = "ischarging";
    public static final String COLUMN_CONNECTION_TYPE = "connectiontype";
    public static final String COLUMN_LOCATION = "location";
    public static final String COLUMN_SIG_STRENGTH = "signalstrength";
    public static final String COLUMN_RESPONSE_CODE = "respcode";
    public static final String COLUMN_REQUEST_HEADER_SIZE = "requestheadersize";
    public static final String COLUMN_RESPONSE_HEADER_SIZE = "responseheadersize";
    public static final String COLUMN_CONTENT_LENGTH = "contentlength";
    public static final String COLUMN_START_TIME = "starttime";
    public static final String COLUMN_STOP_TIME = "stoptime";
    public static final String COLUMN_MIME_TYPE = "mimetype";
    public static final String COLUMN_MULTIPATH_TYPE = "mptype";
    public static final String COLUMN_MULTIPATH_WINNER = "mpwinner";
    public static final String COLUMN_MULTIPATH_METHOD = "mpmethod";
    public static final String COLUMN_SERVER_PROFILE = "serverprofile";
    public static final String COLUMN_AMC_ID = "amcid";
    public static final String COLUMN_REQUEST_TYPE = "requestType";
    public static final String COLUMN_IPV4_TRIES = "v4Tries";
    public static final String COLUMN_IPV6_TRIES = "v6Tries";
    public static final String COLUMN_SEGMENT_LONG_NAME = "sgmntlname";
    public static final String COLUMN_SEGMENT_SHORT_NAME = "sgmntsname";
    public static final String COLUMN_SEGMENT_HTTP_TS = "httpts";
    private static final String COLUMN_LAST_MODIFIED_TS = "lastModified";
    public static final String COLUMN_ACCESS_TS = "accessts";
    public static final String COLUMN_DRM_FILE = "drmfile";
    public static final String COLUMN_MAX_CACHE_DURATION = "maxdurationtocache";
    public static final String COLUMN_ENDPOINT = "endpoint";
    public static final String COLUMN_FREQUENCY = "frequency";
    public static final String COLUMN_DOWNLOAD_MANIFEST_TS = "downloadManifestTS";
    public static final String COLUMN_QUIC_ENABLED = "quicEnabled";
    public static final String COLUMN_CONTENT_LENGTH_HEADER = "contentLengthHeader";
    public static final String COLUMN_MAX_RWND = "maxRwnd";
    public static final String COLUMN_BROTLI_ENABLED = "brotliEnabled";
    public static final String COLUMN_BROTLI_USED = "brotliUsed";
    public static final String COLUMN_CACHEABLE = "cacheable";
    private static final String COLUMN_BASE_URL = "baseUrl";
    private static final String COLUMN_TRACK_TYPE = "type";
    private static final String COLUMN_GROUP_ID = "groupId";
    private static final String COLUMN_DEFAULT_RENDITION = "defaultRendition";
    private static final String COLUMN_AUTOSELECT = "autoselect";
    private static final String COLUMN_URI = "uri";
    private static final String COLUMN_ASSOC_LANGUAGE = "assocLanguage";
    private static final String COLUMN_FORCED = "forced";
    private static final String COLUMN_INSTREAM_ID = "inStreamId";
    private static final String COLUMN_CHARACTERISTICS = "characteristics";
    private static final String COLUMN_CHANNELS = "channels";
    private static final String COLUMN_SELECT = "userSelect";
    private static final String COLUMN_BANDWIDTH = "bandwidth";
    private static final String COLUMN_CODECS = "codecs";
    private static final String COLUMN_RESOLUTION = "resolution";
    private static final String COLUMN_AUDIO = "audioGroup";
    private static final String COLUMN_VIDEO = "videoGroup";
    private static final String COLUMN_SUBTITLES = "subtitlesGroup";
    private static final String COLUMN_AVG_BANDWIDTH = "avgBandwidth";
    private static final String COLUMN_FRAME_RATE = "frameRate";
    private static final String COLUMN_HDCP_LEVEL = "hdcpLevel";
    private static final String COLUMN_CLOSED_CAPTIONS = "closedCaptions";
    private static final String COLUMN_ADAPTATIONSET_IDX = "adaptationSetIdx";
    private static final String COLUMN_REPRESENTATION_IDX = "representationIdx";
    public static final String COLUMN_FG_SEGMENT = "fgSegment";
    public static final String COLUMN_FEED_SEGMENT = "segment";
    public static final String COLUMN_TPRESULT = "tpResult";
    public static final String COLUMN_SESSIONID = "sessionId";
    public static final String COLUMN_EXCEPTION_MESSAGE = "exceptionMessage";
    public static final String COLUMN_PRECACHED = "precached";
    public static final String COLUMN_REDIRECTED = "redirected";
    public static final String COLUMN_FEED_MUSTREVALIDATE = "mustRevalidate";
    public static final String COLUMN_NETWORK_SELECTION = "networkSelection";
    private static final int DB_VERSION_DELETED_FEEDS_TABLE = 55;
    private static final int DB_VERSION_CONTENT_MIGRATION = 62;
    private static final int DB_VERSION_ANALYTICS_CONTENT_TYPE = 63;
    private static final int DB_VERSION_DOWNLOAD_STATUS_COLUMNS = 64;
    private static final int DB_VERSION_FILEGROUP = 65;
    private static final int DB_VERSION_DOWNLOAD_COMPLETION_TIMESTAMP_COLUMN = 66;
    private static final int DB_VERSION_UNIVERSAL_CACHE = 75;
    private static final int DB_VERSION_DRM_FILE = 80;
    private static final int DB_VERSION_COOKIE_MANAGER_UPGRADE = 81;
    private static final int DB_VERSION_TCP_OPTIMIZATIONS = 85;
    private static final int DB_VERSION_MAX_CACHE_DURATION = 90;
    private static final int DB_VERSION_SDCARD_UPGRADE = 95;
    private static final int DB_DOWNLOAD_INITIATED_TIMESTAMP = 96;
    private static final int DB_VERSION_AMC_ID = 100;
    private static final int DB_VERSION_MESSAGE_LIST = 105;
    private static final int DB_VERSION_ENHANCED_STATS = 110;
    private static final int DB_VERSION_TTFB_IN_DOWNLOAD_STATS = 115;
    private static final int DB_VERSION_SEGMENT_DOWNLOAD_MANIFEST_TS = 116;
    private static final int DB_QUIC_ANALYTICS_CHANGES = 117;
    private static final int DB_VERSION_IPTRIES = 118;
    private static final int DB_VERSION_FEED_PREFERRED_QUALITY_AND_AVAILABILITY_TS = 119;
    private static final int DB_VERSION_FEED_PREFERRED_TRACK = 125;
    private static final int DB_VERSION_CONTENT_LENGTH = 126;
    private static final int DB_VERSION_DASH_TRACK = 127;
    private static final int DB_VERSION_FEED_CATEGORY_LAST_MODIFIED = 128;
    private static final int DB_VERSION_BROTLI_CHANGES = 130;
    private static final int DB_VERSION_CACHABLE_HTTP_STATS = 135;
    private static final int DB_VERSION_FG_SEGMENTS = 140;
    private static final int DB_VERSION_FEED_SEGMENT = 141;
    private static final int DB_VERSION_TPRESULT_HTTP_STATS = 146;
    private static final int DB_VERSION_TPRESULT_HTTP_SESSIONSID = 150;
    private static final int DB_VERSION_HTTP_EXCEPTION_MESSAGE = 155;
    private static final int DB_VERSION_HTTP_PRECACHED = 160;
    private static final int DB_VERSION_HTTP_REDIRECT = 165;
    private static final int DB_VERSION_MUSTREVALIDATE = 170;
    private static final int DB_VERSION_CLEANUP = 175;
    static final String DATABASE_NAME = "feed.db";
    private static final int DATABASE_VERSION = 175;
    private static final String LOG_TAG = "AnaDatabaseSchema";
    private final Context mContext;
    private static final String FEEDITEM_CREATE = "create table feeditem(_id text not null primary key, provider text not null, url text not null unique, videofile text not null, feedtype text not null, size integer, timestamp integer, resourceready integer, viewcount integer, priority integer, creationtimestamp integer,status integer default 0,responseheaders text, refreshtimestamp integer, maxage integer, syncPending integer default 0, accessts integer, segment text default '', mustRevalidate integer default 0 , dlUrl text , networkSelection integer default 0 );";
    private static final String HTTP_STATS_CREATE = "create table httpstats(_id integer primary key AUTOINCREMENT,feedid text,url text not null,downloadtype text not null,timestamp integer not null, duration integer not null, ttfb integer, batterylevel integer, ischarging text, connectiontype text, location text, signalstrength integer, respcode integer, requestheadersize integer, responseheadersize integer, mptype integer default -1, mpwinner integer default -1, mpmethod integer default -1, contentlength integer, mimetype text, serverprofile text default '', amcid text default '', quicEnabled integer default 0, requestType text default '', v4Tries integer default 0, v6Tries integer default 0, contentLengthHeader text default '', maxRwnd integer default 0, brotliEnabled integer default 0, brotliUsed integer default 0, cacheable integer default -1, tpResult integer default -1, sessionId text default '', exceptionMessage text default '',precached text default 'false',redirected text default 'false');";
    private static final String SESSION_STATS_CREATE = "create table sessionstats(_id integer primary key AUTOINCREMENT,timestamp integer not null, duration integer not null, name text not null, sessionId text default '');";
    private static final String USER_EVENTS_CREATE = "create table userevents(_id integer primary key AUTOINCREMENT,name text not null, starttime integer not null, stoptime integer not null, connectiontype text default '', sessionId text default '');";
    private static final String EVENT_LOG_CREATE = "create table eventlog(_id integer primary key AUTOINCREMENT,name text not null, timestamp integer not null, sessionId text default '');";
    private static final String SEGMENT_TABLE_CREATE = "create table segment(sgmntlname text not null unique, sgmntsname text not null unique, timestamp integer default 0, httpts text default '', subscribed integer default 0, downloadManifestTS integer default 0, fgSegment integer default 0);";
    private static final String DELETED_FEED_TABLE_CREATE = "create table deletedfeeds(_id text not null primary key, timestamp integer default 0);";
    private static final String FILEGROUP_CREATE = "create table filegroup(feedid text not null, feedtype text not null, feedsubtype text not null, filename text not null, resourceready integer default 0, attribute text default '', url text not null, size integer, autodownload integer default 0, FOREIGN KEY(feedid) REFERENCES feeditem(_id) ON DELETE CASCADE);";
    private static final String MESSAGELIST_CREATE = "create table messagelist(endpoint text not null primary key, frequency integer default 0, timestamp integer default 0);";
    private static final String TRACKS_CREATE = "create table track(baseUrl text not null, type text not null, groupId text not null, name text not null, defaultRendition text default 'NO', autoselect text default 'NO', language text default '', uri text default '', assocLanguage text default '', forced text default 'NO', inStreamId text default '', characteristics text default '', channels text default '', userSelect integer default 0, PRIMARY KEY(uri), FOREIGN KEY(baseUrl) REFERENCES feeditem(url) ON DELETE CASCADE);";
    private static final String DASH_TRACKS_CREATE = "create table dashtrack(baseUrl text not null, type text not null, adaptationSetIdx integer default 0, representationIdx integer default 0, bandwidth integer not null, language text default '', userSelect integer default 0, FOREIGN KEY(baseUrl) REFERENCES feeditem(url) ON DELETE CASCADE);";
    private static final String VARIANTS_CREATE = "create table variant(baseUrl text not null, uri text not null primary key, bandwidth integer not null, avgBandwidth integer default 0, audioGroup text default '', videoGroup text default '', subtitlesGroup text default '', resolution text default '', codecs text not null, closedCaptions text default '', frameRate text default '', hdcpLevel text default '', userSelect integer default 0, quality integer default 0, FOREIGN KEY(baseUrl) REFERENCES feeditem(url) ON DELETE CASCADE);";

    @TargetApi(value=11)
    public AnaDatabaseSchema(Context context, DatabaseErrorHandler databaseErrorHandler) {
        super(context, DATABASE_NAME, null, 175, databaseErrorHandler);
        this.mContext = context;
    }

    private AnaDatabaseSchema(Context context) {
        super(context, DATABASE_NAME, null, 175);
        this.mContext = context;
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("PRAGMA foreign_keys=ON");
        sQLiteDatabase.execSQL(FEEDITEM_CREATE);
        sQLiteDatabase.execSQL(HTTP_STATS_CREATE);
        sQLiteDatabase.execSQL(SESSION_STATS_CREATE);
        sQLiteDatabase.execSQL(USER_EVENTS_CREATE);
        sQLiteDatabase.execSQL(EVENT_LOG_CREATE);
        sQLiteDatabase.execSQL(SEGMENT_TABLE_CREATE);
        sQLiteDatabase.execSQL(DELETED_FEED_TABLE_CREATE);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
        Logger.d((String)"AkaSdkLogger-map", (String)(AnaDatabaseSchema.class.getName() + ": Upgrading database from version " + n2 + " to " + n3));
        if (n3 > n2) {
            this.toDbVersion55(sQLiteDatabase, n2);
            this.toDbVersion62(sQLiteDatabase, n2);
            this.toDbVersion63(sQLiteDatabase, n2);
            this.toDbVersion64(sQLiteDatabase, n2);
            this.toDbVersion65(sQLiteDatabase, n2);
            this.toDbVersion66(sQLiteDatabase, n2);
            this.toDbVersion75(sQLiteDatabase, n2);
            this.toDbVersion80(sQLiteDatabase, n2);
            this.toDbVersion81(sQLiteDatabase, n2);
            this.toDbVersion85(sQLiteDatabase, n2);
            this.toDbVersion90(sQLiteDatabase, n2);
            this.toDbVersion95(sQLiteDatabase, n2);
            this.toDbVersion96(sQLiteDatabase, n2);
            this.toDbVersion100(sQLiteDatabase, n2);
            this.toDbVersion105(sQLiteDatabase, n2);
            this.toDbVersion110(sQLiteDatabase, n2);
            this.toDbVersion115(sQLiteDatabase, n2);
            this.toDbVersion116(sQLiteDatabase, n2);
            this.toDbVersion117(sQLiteDatabase, n2);
            this.toDbVersion118(sQLiteDatabase, n2);
            this.toDbVersion119(sQLiteDatabase, n2);
            this.toDbVersion125(sQLiteDatabase, n2);
            this.toDbVersion126(sQLiteDatabase, n2);
            this.toDbVersion127(sQLiteDatabase, n2);
            this.toDbVersion128(sQLiteDatabase, n2);
            this.toDbVersion130(sQLiteDatabase, n2);
            this.toDbVersion135(sQLiteDatabase, n2);
            this.toDbVersion140(sQLiteDatabase, n2);
            this.toDbVersion141(sQLiteDatabase, n2);
            this.toDbVersion146(sQLiteDatabase, n2);
            this.toDbVersion150(sQLiteDatabase, n2);
            this.toDbVersion155(sQLiteDatabase, n2);
            this.toDbVersion160(sQLiteDatabase, n2);
            this.toDbVersion165(sQLiteDatabase, n2);
            this.toDbVersion170(sQLiteDatabase, n2);
            this.toDbVersion175(sQLiteDatabase, n2);
        } else {
            this.dropAllTables(sQLiteDatabase);
            this.onCreate(sQLiteDatabase);
        }
    }

    private void dropAllTables(SQLiteDatabase sQLiteDatabase) {
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feeditem");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedpolicy");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS httpstats");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS sessionstats");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS userevents");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS eventlog");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS segment");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS deletedfeeds");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedcategory");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS contentsource");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS ratingstats");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS adsconsumptionstats");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedtag");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedstream");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS categorykeywords");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedtopics");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS searchwords");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS filegroup");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS messagelist");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS track");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS variant");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS dashtrack");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedpolicy");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS consumptionstats");
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS downloadstats");
    }

    private void toDbVersion55(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 55) {
            try {
                sQLiteDatabase.execSQL(DELETED_FEED_TABLE_CREATE);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion55", (Throwable)exception);
            }
        }
    }

    private void toDbVersion62(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 62) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN sourcePath TEXT DEFAULT ''");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN syncPending INTEGER DEFAULT 0");
                String string = VocUtils.getMediaPath(this.mContext);
                sQLiteDatabase.execSQL("update feeditem set sourcePath = '" + string + "'");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion62", (Throwable)exception);
            }
        }
    }

    private void toDbVersion63(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 63) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE userevents ADD COLUMN connectiontype TEXT DEFAULT ''");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion63", (Throwable)exception);
            }
        }
    }

    private void toDbVersion64(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 64) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN downloadState integer default -1");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN bytesDownloaded integer default 0");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN downloadFailureErrorCode integer default -1");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN markForDownloadTimestamp integer");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion64", (Throwable)exception);
            }
        }
    }

    private void toDbVersion65(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 65) {
            try {
                sQLiteDatabase.execSQL(FILEGROUP_CREATE);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion65", (Throwable)exception);
            }
        }
    }

    private void toDbVersion66(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 66) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN downloadCompletionTimestamp integer");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion66", (Throwable)exception);
            }
        }
    }

    private void toDbVersion75(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 75) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN accessts integer");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion75", (Throwable)exception);
            }
        }
    }

    private void toDbVersion80(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 80) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN drmfile text default ''");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion80", (Throwable)exception);
            }
        }
    }

    private void toDbVersion81(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 81) {
            try {
                sQLiteDatabase.execSQL("update feeditem set resourceready = 0 where responseheaders like '%set-cookie%'");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion81", (Throwable)exception);
            }
        }
    }

    private void toDbVersion85(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 85) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN serverprofile text default ''");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion85", (Throwable)exception);
            }
        }
    }

    private void toDbVersion90(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 90) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN maxdurationtocache integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion90", (Throwable)exception);
            }
        }
    }

    private void toDbVersion95(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 95) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN storagePreference TEXT DEFAULT PCD_DEFAULT");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion95", (Throwable)exception);
            }
        }
    }

    private void toDbVersion96(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 96) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN downloadInitiatedTimestamp INTEGER DEFAULT 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion96", (Throwable)exception);
            }
        }
    }

    private void toDbVersion100(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 100) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN amcid text default ''");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion100", (Throwable)exception);
            }
        }
    }

    private void toDbVersion105(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 105) {
            try {
                sQLiteDatabase.execSQL(MESSAGELIST_CREATE);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion105", (Throwable)exception);
            }
        }
    }

    private void toDbVersion110(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 110) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE consumptionstats ADD COLUMN network text default ''");
                sQLiteDatabase.execSQL("ALTER TABLE downloadstats ADD COLUMN downloadquality integer default 5");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion110", (Throwable)exception);
            }
        }
    }

    private void toDbVersion115(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 115) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE downloadstats ADD COLUMN ttfb integer default -1 ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion115", (Throwable)exception);
            }
        }
    }

    private void toDbVersion116(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 116) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE segment ADD COLUMN downloadManifestTS integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion116", (Throwable)exception);
            }
        }
    }

    private void toDbVersion117(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 117) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN quicEnabled integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion117", (Throwable)exception);
            }
        }
    }

    private void toDbVersion118(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 118) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN requestType text default ''");
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN v4Tries integer default 0");
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN v6Tries integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion118", (Throwable)exception);
            }
        }
    }

    private void toDbVersion119(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 119) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN preferredquality integer default -1");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN availability_ts integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion119", (Throwable)exception);
            }
        }
    }

    private void toDbVersion125(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 125) {
            try {
                sQLiteDatabase.execSQL(TRACKS_CREATE);
                sQLiteDatabase.execSQL(VARIANTS_CREATE);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion125", (Throwable)exception);
            }
        }
    }

    private void toDbVersion126(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 126) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN contentLengthHeader text default ''");
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN maxRwnd integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion126", (Throwable)exception);
            }
        }
    }

    private void toDbVersion127(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 127) {
            try {
                sQLiteDatabase.execSQL(DASH_TRACKS_CREATE);
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion127", (Throwable)exception);
            }
        }
    }

    private void toDbVersion128(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 128) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feedcategory ADD COLUMN lastModified text default '' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion128", (Throwable)exception);
            }
        }
    }

    private void toDbVersion130(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 130) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN brotliEnabled integer default 0");
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN brotliUsed integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion130", (Throwable)exception);
            }
        }
    }

    private void toDbVersion135(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 135) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN cacheable integer default -1");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion135", (Throwable)exception);
            }
        }
    }

    private void toDbVersion140(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 140) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE segment ADD COLUMN fgSegment integer default 0");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion140", (Throwable)exception);
            }
        }
    }

    private void toDbVersion141(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 141) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN segment text default '' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion141", (Throwable)exception);
            }
        }
    }

    private void toDbVersion146(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 146) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN tpResult integer default -1");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion146", (Throwable)exception);
            }
        }
    }

    private void toDbVersion150(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 150) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN sessionId text default '' ");
                sQLiteDatabase.execSQL("ALTER TABLE eventlog ADD COLUMN sessionId text default '' ");
                sQLiteDatabase.execSQL("ALTER TABLE userevents ADD COLUMN sessionId text default '' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion150", (Throwable)exception);
            }
        }
    }

    private void toDbVersion155(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 155) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN exceptionMessage text default '' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion155", (Throwable)exception);
            }
        }
    }

    private void toDbVersion160(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 160) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN precached text default 'false' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion160", (Throwable)exception);
            }
        }
    }

    private void toDbVersion165(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 165) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE httpstats ADD COLUMN redirected text default 'false' ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion165", (Throwable)exception);
            }
        }
    }

    private void toDbVersion170(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 170) {
            try {
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN mustRevalidate integer default 0 ");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion170", (Throwable)exception);
            }
        }
    }

    private void toDbVersion175(SQLiteDatabase sQLiteDatabase, int n2) {
        if (n2 < 175) {
            try {
                String string = "_id text not null primary key, provider text not null, url text not null unique, videofile text not null, feedtype text not null, size integer, timestamp integer, resourceready integer, viewcount integer, priority integer, creationtimestamp integer,status integer default 0,responseheaders text, refreshtimestamp integer, maxage integer, syncPending integer default 0, accessts integer, segment text default '', mustRevalidate integer default 0";
                String string2 = "_id, provider, url, videofile, feedtype, size, timestamp, resourceready, viewcount, priority, creationtimestamp, status, responseheaders, refreshtimestamp, maxage, syncPending, accessts, segment, mustRevalidate";
                sQLiteDatabase.execSQL("CREATE TEMPORARY TABLE feeditem_tmp(_id text not null primary key, provider text not null, url text not null unique, videofile text not null, feedtype text not null, size integer, timestamp integer, resourceready integer, viewcount integer, priority integer, creationtimestamp integer,status integer default 0,responseheaders text, refreshtimestamp integer, maxage integer, syncPending integer default 0, accessts integer, segment text default '', mustRevalidate integer default 0 )");
                sQLiteDatabase.execSQL("INSERT INTO feeditem_tmp SELECT _id, provider, url, videofile, feedtype, size, timestamp, resourceready, viewcount, priority, creationtimestamp, status, responseheaders, refreshtimestamp, maxage, syncPending, accessts, segment, mustRevalidate FROM feeditem");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feeditem");
                sQLiteDatabase.execSQL("CREATE TABLE feeditem(_id text not null primary key, provider text not null, url text not null unique, videofile text not null, feedtype text not null, size integer, timestamp integer, resourceready integer, viewcount integer, priority integer, creationtimestamp integer,status integer default 0,responseheaders text, refreshtimestamp integer, maxage integer, syncPending integer default 0, accessts integer, segment text default '', mustRevalidate integer default 0)");
                sQLiteDatabase.execSQL("INSERT INTO feeditem SELECT _id, provider, url, videofile, feedtype, size, timestamp, resourceready, viewcount, priority, creationtimestamp, status, responseheaders, refreshtimestamp, maxage, syncPending, accessts, segment, mustRevalidate FROM feeditem_tmp");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN dlUrl text ");
                sQLiteDatabase.execSQL("ALTER TABLE feeditem ADD COLUMN networkSelection integer default 0 ");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feeditem_tmp");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedcategory");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS contentsource");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS ratingstats");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS adsconsumptionstats");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedtag");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedstream");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS categorykeywords");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedtopics");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS searchwords");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS filegroup");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS messagelist");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS track");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS variant");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS dashtrack");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS feedpolicy");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS consumptionstats");
                sQLiteDatabase.execSQL("DROP TABLE IF EXISTS downloadstats");
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AnaDatabaseSchema: toDbVersion175", (Throwable)exception);
            }
        }
    }

    public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
    }
}

