/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.AkaCommon;
import com.akamai.android.sdk.AkaMap;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.brotliinter.IAkaBrotli;
import com.akamai.android.sdk.cronet.IAkaCronetEngine;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.internal.AkaNetworkQualityHandler;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaWebAnalyticsHandler;
import com.akamai.android.sdk.model.AnaFeedItem;
import com.akamai.android.sdk.net.AkaCryptoHandler;
import com.akamai.android.sdk.net.AkaDefHttpProtocolBinder;
import com.akamai.android.sdk.net.AkaFeedManager;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.AkaMultiPathHandler;
import com.akamai.android.sdk.net.AkaNetUtils;
import com.akamai.android.sdk.net.SecurePreferenceReadHandler;
import com.akamai.android.sdk.util.AnaDiskUtils;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VocAccelerator
implements AkaCommon.AkaCommonInitialization {
    @SuppressLint(value={"StaticFieldLeak"})
    private static final VocAccelerator sInstance = new VocAccelerator();
    private Context mContext;
    private long mActivityStartTime = -1L;
    private Application.ActivityLifecycleCallbacks mActivityLifeCycleCallback;
    private boolean mInitialized = false;
    private final HashMap<String, EventInfo> mUserEventMap = new HashMap();
    private SecurePreferenceReadHandler mPrefs;
    private final ExecutorService mHandler = Executors.newSingleThreadExecutor();
    private volatile boolean mIsAppInForeground;
    private final Hashtable<String, Boolean> mSDKCapabilities = new Hashtable();
    private AkaMultiPathHandler mMultiPathHandler;
    private ConnectivityManager mConnectivityManager;
    private TelephonyManager mTelephonyManager;
    private PhoneStateListener mSignalStrengthListener;
    private SharedPreferences mSharedPreferences;
    private AkaNetUtils mNetUtils;
    public static String sPackageName;
    private volatile transient String mStaticParams;
    private volatile transient int mSignalQuality = -1;
    private final AkaFeedManager mFeedManager = new AkaFeedManager();
    private IAkaCronetEngine mAkaCronetEngine;
    private final ConcurrentHashMap<String, Long> mQuicMaxAgeMap = new ConcurrentHashMap();
    private static final int DEFAULT_STAT_UPLOAD = 100;
    private int mActiveStatCounter;
    private volatile String mSessionId = "";
    private static final Runnable ACTIVITY_ON_RESUME_TASK;
    private static final String LOG_TAG = "VocAccelerator";
    private IAkaBrotli mAkaBrotliDecoder;

    private VocAccelerator() {
    }

    public static VocAccelerator getInstance() {
        return sInstance;
    }

    public synchronized void init(final Context context, AkaMap akaMap) {
        if (!this.mInitialized) {
            this.mContext = context.getApplicationContext();
            this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            this.mPrefs = new SecurePreferenceReadHandler(this.mContext);
            this.registerActivityLifecyleListener();
            this.mMultiPathHandler = new AkaMultiPathHandler(this.mContext);
            this.mSharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
            this.mNetUtils = new AkaNetUtils(this.mConnectivityManager);
            String string = AnaUtils.getHostAppVersion(this.mContext);
            sPackageName = this.mContext.getPackageName() + (TextUtils.isEmpty((CharSequence)string) ? "" : "/" + string);
            AkaCommon.addListener((AkaCommon.AkaCommonInitialization)this);
            this.mHandler.submit(new Runnable(){

                @Override
                public void run() {
                    Logger.d((String)"AkaSdkLogger-map", (String)("VocAcceleratorMAP instance created with api Key:" + AkaSessionHandler.getLicense(context)));
                    VocAccelerator.this.initCronetEngine();
                    AkaCryptoHandler akaCryptoHandler = new AkaCryptoHandler(VocAccelerator.this.mContext);
                    akaCryptoHandler.storeKey();
                    VocAccelerator.this.mNetUtils.init(VocAccelerator.this.mContext);
                    VocAccelerator.this.initStaticParams();
                    VocAccelerator.this.addOrRemoveSigStrengthListener(true);
                    VocAccelerator.this.initBrotli();
                    VocAccelerator.this.mSessionId = UUID.randomUUID().toString();
                }
            });
            this.initializeFeedManager();
            this.mInitialized = true;
        }
    }

    public void initializationStatus(boolean bl2) {
        if (bl2) {
            this.setupInterceptor();
        }
    }

    public IAkaCronetEngine getCronetEngine() {
        return this.mAkaCronetEngine;
    }

    public void updateQuicMaxAge(String string, long l2) {
        this.mQuicMaxAgeMap.put(string, l2);
    }

    private void initCronetEngine() {
        try {
            Class<?> clazz = Class.forName("com.akamai.android.sdk.quic.AkaCronetEngineImpl");
            this.mAkaCronetEngine = (IAkaCronetEngine)clazz.getConstructor(Context.class).newInstance(this.mContext);
            boolean bl2 = this.getSecurePreferenceBoolean("use_brotli", false);
            this.mAkaCronetEngine.buildEngine(null, bl2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.d((String)"AkaSdkLogger-map", (String)"VocAccelerator: akamai-cronet-lib not added to class path");
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("VocAccelerator:  Unable to fullSync cronet library " + exception));
        }
    }

    public void initCronetWithHints(boolean bl2) {
        boolean bl3 = this.getSecurePreferenceBoolean("use_brotli", false);
        if (this.mAkaCronetEngine != null && !this.mQuicMaxAgeMap.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, Long> entry : this.mQuicMaxAgeMap.entrySet()) {
                if (entry.getValue() <= System.currentTimeMillis()) continue;
                arrayList.add(entry.getKey());
            }
            this.mAkaCronetEngine.buildEngine(arrayList, bl3);
        } else if (this.mAkaCronetEngine != null && bl2) {
            this.mAkaCronetEngine.buildEngine(null, bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStaticParams() {
        float f2;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getCarrierInfo();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("carrier=");
            stringBuilder.append(string);
        }
        if ((f2 = this.getPhysicalMemorySz()) > 0.0f) {
            int n2 = f2 <= 1.0f ? 1 : (f2 <= 2.0f ? 2 : 3);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append("devicetype=");
            stringBuilder.append(n2);
        }
        Class<VocAccelerator> clazz = VocAccelerator.class;
        synchronized (VocAccelerator.class) {
            this.mStaticParams = stringBuilder.toString();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getPhysicalMemorySz() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/meminfo")));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.toLowerCase().startsWith("memtotal")) continue;
                String[] stringArray = string.split("\\s+");
                float f2 = Integer.parseInt(stringArray[1]);
                float f3 = (f2 /= 1048576.0f) > 0.0f ? f2 : -1.0f;
                return f3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return -1.0f;
    }

    public void setupInterceptor() {
        if (AkaDefHttpProtocolBinder.init()) {
            AkaLogger.in((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, "Http/s protocol handler setup successful"});
        } else {
            AkaLogger.in((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, "Http/s protocol handler setup unsuccessful"});
        }
    }

    public ExecutorService getHandler() {
        return this.mHandler;
    }

    public void initializeFeedManager() {
        this.mHandler.submit(new Runnable(){

            @Override
            public void run() {
                VocAccelerator.this.mFeedManager.init(VocAccelerator.this.mContext);
            }
        });
    }

    public void onInsert(String string, String string2) {
        this.mFeedManager.insert(string, string2);
    }

    public void onUpdate(String string, boolean bl2) {
        this.mFeedManager.updateResourceReady(string, bl2);
    }

    public void onDelete(final Set<String> set) {
        this.mHandler.submit(new Runnable(){

            @Override
            public void run() {
                if (set != null) {
                    for (String string : set) {
                        VocAccelerator.this.mFeedManager.removeFeedWithID(string);
                    }
                }
            }
        });
    }

    public void onClearCache() {
        this.mHandler.submit(new Runnable(){

            @Override
            public void run() {
                VocAccelerator.this.mFeedManager.clearAll();
            }
        });
    }

    public boolean isURLCachedAndReady(String string) {
        return this.mFeedManager.isURLCachedAndReady(string);
    }

    public SharedPreferences getSharedPreferences() {
        return this.mSharedPreferences;
    }

    public AkaNetUtils getNetUtils() {
        return this.mNetUtils;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.mConnectivityManager;
    }

    public boolean getSecurePreferenceBoolean(String string, boolean bl2) {
        boolean bl3;
        if (this.mSDKCapabilities.containsKey(string)) {
            return this.mSDKCapabilities.get(string);
        }
        try {
            bl3 = this.mPrefs.getBoolean(string, bl2);
            this.mSDKCapabilities.put(string, bl3);
        }
        catch (Exception exception) {
            if (this.mPrefs == null) {
                Logger.e((String)"AkaSdkLogger-map", (String)"SDK not initialized. Refer integration guide to see if there is any missing setup.");
            }
            bl3 = bl2;
        }
        return bl3;
    }

    public String getSecurePreferenceString(String string, String string2) {
        String string3;
        try {
            string3 = this.mPrefs.getString(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string3 = string2;
        }
        return string3;
    }

    public AkaFeedManager getFeedManager() {
        return this.mFeedManager;
    }

    public void clearCapabilities() {
        this.mSDKCapabilities.clear();
    }

    public AkaMultiPathHandler getMultiPathHandler() {
        return this.mMultiPathHandler;
    }

    private String getCarrierInfo() {
        if (this.mTelephonyManager != null) {
            try {
                String string;
                String string2 = this.mTelephonyManager.getNetworkOperatorName();
                if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string = this.mTelephonyManager.getNetworkOperator()))) {
                    String string3 = string.substring(0, 3);
                    String string4 = string.substring(3);
                    return string2 + "/" + string3 + "," + string4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void submitTask(Runnable runnable) {
        this.mHandler.submit(runnable);
    }

    int getSignalStrength() {
        return this.mSignalQuality;
    }

    String getStaticParams() {
        return this.mStaticParams;
    }

    public synchronized void registerActivityLifecyleListener() {
        if (this.mActivityLifeCycleCallback == null) {
            this.initActivityLifecycleHandler();
            Application application = (Application)this.mContext;
            application.registerActivityLifecycleCallbacks(this.mActivityLifeCycleCallback);
        }
    }

    private synchronized void unregisterActivityLifecyleListener() {
        if (this.mActivityLifeCycleCallback != null) {
            Application application = (Application)this.mContext;
            application.unregisterActivityLifecycleCallbacks(this.mActivityLifeCycleCallback);
            this.mActivityLifeCycleCallback = null;
        }
        this.mIsAppInForeground = false;
    }

    public synchronized void addOrRemoveSigStrengthListener(boolean bl2) {
        if (bl2) {
            boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("transport_opt", false);
            if (!bl3) {
                return;
            }
            this.registerSignalStrengthListener();
        } else {
            this.unregisterSignalStrengthListener();
        }
    }

    private synchronized void registerSignalStrengthListener() {
        if (this.mTelephonyManager != null && this.mSignalStrengthListener == null && Build.VERSION.SDK_INT >= 23) {
            this.initSignalStrengthListener();
        }
    }

    private synchronized void unregisterSignalStrengthListener() {
        try {
            this.mSignalQuality = -1;
            if (this.mTelephonyManager != null && this.mSignalStrengthListener != null) {
                this.mTelephonyManager.listen(this.mSignalStrengthListener, 0);
                this.mSignalStrengthListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSignalStrengthListener() {
        if (Looper.myLooper() != null) {
            this.createSignalStrengthListener();
        } else {
            Handler handler = new Handler(this.mContext.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    VocAccelerator.this.createSignalStrengthListener();
                }
            });
        }
    }

    private synchronized void createSignalStrengthListener() {
        try {
            if (this.mSignalStrengthListener == null) {
                this.mSignalStrengthListener = new PhoneStateListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                        7 var2_2 = this;
                        synchronized (var2_2) {
                            try {
                                VocAccelerator.this.mSignalQuality = VocAccelerator.this.getSignalQuality(signalStrength);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                this.mTelephonyManager.listen(this.mSignalStrengthListener, 256);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getSignalQuality(SignalStrength signalStrength) {
        int n2 = -1;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                n2 = signalStrength.getLevel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    @TargetApi(value=14)
    private void initActivityLifecycleHandler() {
        this.mActivityStartTime = AnaUtils.getCurrentUTCTimeInMillis();
        this.mActivityLifeCycleCallback = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                VocAccelerator.this.mActivityStartTime = AnaUtils.getCurrentUTCTimeInMillis();
                VocAccelerator.this.mIsAppInForeground = true;
                VocAccelerator.this.mHandler.submit(ACTIVITY_ON_RESUME_TASK);
                AkaSessionHandler.updateLastFgTs(VocAccelerator.this.mContext, VocAccelerator.this.mActivityStartTime);
                VocAccelerator.this.mSessionId = UUID.randomUUID().toString();
            }

            public void onActivityPaused(Activity activity) {
                long l2 = AnaUtils.getCurrentUTCTimeInMillis() - VocAccelerator.this.mActivityStartTime;
                VocAccelerator.this.mHandler.submit(VocAccelerator.this.getRunnable(VocAccelerator.this.mActivityStartTime, l2, activity.getLocalClassName()));
                VocAccelerator.this.mIsAppInForeground = false;
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        };
    }

    public boolean isAppInForeground() {
        return this.mIsAppInForeground;
    }

    public String getSessionId() {
        if (this.mIsAppInForeground) {
            return "FG_" + this.mSessionId;
        }
        return "BG_" + this.mSessionId;
    }

    private Runnable getRunnable(final long l2, final long l3, final String string) {
        return new Runnable(){

            @Override
            public void run() {
                if (VocAccelerator.this.getSecurePreferenceBoolean("store_session", false) || !AkaSessionHandler.isEnabled()) {
                    VocAccelerator.this.insertSessionStats(l2, l3, string);
                }
            }
        };
    }

    public Context getAppContext() {
        return this.mContext;
    }

    public synchronized void startEvent(String string, long l2) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.ts = l2;
        eventInfo.connectionType = AkaHttpUtils.getConnectionType();
        this.mUserEventMap.put(string, eventInfo);
    }

    public synchronized void stopEvent(String string, long l2) {
        EventInfo eventInfo = this.mUserEventMap.remove(string);
        if (eventInfo != null) {
            this.insertUserEventToDB(string, eventInfo.ts, l2, eventInfo.connectionType);
        }
    }

    private void insertUserEventToDB(final String string, final long l2, final long l3, final String string2) {
        this.mHandler.submit(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = VocAccelerator.this.getSecurePreferenceBoolean("log_analytics", false);
                if (VocAccelerator.this.mContext != null && (bl2 || !AkaSessionHandler.isEnabled())) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("name", string);
                    contentValues.put("starttime", Long.valueOf(l2));
                    contentValues.put("stoptime", Long.valueOf(l3));
                    contentValues.put("connectiontype", string2);
                    contentValues.put("sessionId", VocAccelerator.this.getSessionId());
                    VocAccelerator.this.mContext.getContentResolver().insert(AnaProviderContract.USER_EVENTS_URI, contentValues);
                    VocAccelerator.this.triggerAnalyticsIfNeeded();
                }
            }
        });
    }

    public void logEvent(final String string, final long l2) {
        this.mHandler.submit(new Runnable(){

            @Override
            public void run() {
                boolean bl2 = VocAccelerator.this.getSecurePreferenceBoolean("log_analytics", false);
                if (VocAccelerator.this.mContext != null && (bl2 || !AkaSessionHandler.isEnabled())) {
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("name", string);
                    contentValues.put("timestamp", Long.valueOf(l2));
                    contentValues.put("sessionId", VocAccelerator.this.getSessionId());
                    VocAccelerator.this.mContext.getContentResolver().insert(AnaProviderContract.EVENT_LOG_URI, contentValues);
                    VocAccelerator.this.triggerAnalyticsIfNeeded();
                }
            }
        });
    }

    private void insertSessionStats(long l2, long l3, String string) {
        if (this.mContext != null && l2 > 0L && l3 < l2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("timestamp", Long.valueOf(l2));
            contentValues.put("duration", Long.valueOf(l3));
            contentValues.put("name", string);
            this.mContext.getContentResolver().insert(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, contentValues);
            this.triggerAnalyticsIfNeeded();
        }
    }

    private void triggerAnalyticsIfNeeded() {
        ++this.mActiveStatCounter;
        if (this.mActiveStatCounter >= AnaUtils.getSDKSharedPreferences(this.mContext).getInt("upload_threshold", 100)) {
            this.mActiveStatCounter = 0;
            this.submitTask(new Runnable(){

                @Override
                public void run() {
                    AkaWebAnalyticsHandler.sendWebAnalytics(VocAccelerator.this.mContext);
                }
            });
        }
    }

    public void updateFeedStats(final AnaFeedItem anaFeedItem, final long l2, final boolean bl2) {
        this.submitTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<VocAccelerator> clazz = VocAccelerator.class;
                synchronized (VocAccelerator.class) {
                    if (anaFeedItem != null) {
                        long l22 = anaFeedItem.getAccessCount();
                        long l3 = Math.max(l2, anaFeedItem.getAccessTs());
                        try {
                            String string = "_id=?";
                            String[] stringArray = new String[]{anaFeedItem.getId()};
                            Cursor cursor = VocAccelerator.this.mContext.getContentResolver().query(AnaProviderContract.CONTENT_URI_FEEDS, new String[]{"viewcount", "accessts"}, string, stringArray, null);
                            if (cursor != null) {
                                if (cursor.moveToFirst()) {
                                    l22 = Math.max(cursor.getLong(0), l22);
                                    l3 = Math.max(l3, cursor.getLong(1));
                                }
                                cursor.close();
                            }
                            ContentValues contentValues = new ContentValues();
                            if (bl2) {
                                contentValues.put("viewcount", Long.valueOf(++l22));
                            }
                            contentValues.put("accessts", Long.valueOf(l3));
                            VocAccelerator.this.mContext.getContentResolver().update(AnaProviderContract.FEEDSTATS_URI, contentValues, string, stringArray);
                        }
                        catch (Exception exception) {
                            Logger.dd((String)"AkaSdkLogger-map", (String)(" Failed to update stats for id: " + anaFeedItem.getId() + ", ex: " + exception));
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private void initBrotli() {
        try {
            Class<?> clazz = Class.forName("com.akamai.android.sdk.brotli.AkaBrotliImpl");
            this.mAkaBrotliDecoder = (IAkaBrotli)clazz.getConstructor(Context.class).newInstance(this.mContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.d((String)"AkaSdkLogger-map", (String)"VocAccelerator: akamai-brotli-lib not added to class path");
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("VocAccelerator: Unable to fullSync brotli library " + exception));
        }
    }

    public IAkaBrotli getBrotliDecoder() {
        return this.mAkaBrotliDecoder;
    }

    public void putSecurePreferenceBooleanToCache(String string, boolean bl2) {
        this.mSDKCapabilities.put(string, bl2);
    }

    StringBuilder checkHeaderValue(StringBuilder stringBuilder) {
        try {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = stringBuilder.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = stringBuilder.charAt(i2);
                if (c2 <= '\u001f' && c2 != '\t' || c2 >= '\u007f') continue;
                stringBuilder2.append(c2);
            }
            return stringBuilder2;
        }
        catch (Exception exception) {
            return stringBuilder;
        }
    }

    public static void removeData(Context context) {
        VocAccelerator.getInstance().unregisterActivityLifecyleListener();
        VocAccelerator.getInstance().addOrRemoveSigStrengthListener(false);
    }

    static {
        ACTIVITY_ON_RESUME_TASK = new Runnable(){

            @Override
            public void run() {
                if (AkaSessionHandler.isKilled()) {
                    return;
                }
                if (VocAccelerator.getInstance().mContext != null) {
                    AkaNetworkQualityHandler.startNQDetection(VocAccelerator.getInstance().mContext);
                    if (!AkaSessionHandler.getLicense(VocAccelerator.getInstance().mContext).isEmpty()) {
                        AkaBackgroundService.getInstance(VocAccelerator.getInstance().mContext).performFullSync(VocAccelerator.getInstance().mContext, null);
                    }
                    VocAccelerator.getInstance().initCronetWithHints(false);
                    try {
                        String string = AnaDiskUtils.getInternalStoragePath(VocAccelerator.getInstance().mContext);
                        AnaDiskUtils.usedMemory(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private static class EventInfo {
        long ts;
        String connectionType;

        private EventInfo() {
        }
    }
}

