/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;

public class AkaNetUtils {
    private final NetworkChangeReceiver mReceiver = new NetworkChangeReceiver();
    private final ConnectivityManager mConnectivityManager;
    private WifiManager mWifiManager;
    private final Object mLock = new Object();
    private volatile transient String mLocalDns = "";
    private volatile transient String mWifiSubType = "";
    private volatile transient String mCellSubType = "";
    private volatile transient String mNetworkType = "";
    private volatile transient boolean mIsIPv6Supported = false;
    private static final String LOG_TAG = "AkaNetUtils";

    AkaNetUtils(ConnectivityManager connectivityManager) {
        this.mConnectivityManager = connectivityManager;
    }

    public void init(Context context) {
        this.mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mConnectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)new NetworkCallback());
            } else {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                context.getApplicationContext().registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
                if (this.isNetworkAvail()) {
                    this.initializeLocalDns();
                    this.initializeNetworkTypes();
                    this.initializeIPv6Support();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isNetworkAvail() {
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNetworkTypes() {
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1) {
            Object object = this.mLock;
            synchronized (object) {
                this.mWifiSubType = this.mapWifiSubType();
                this.mNetworkType = "wifi";
            }
        }
        if (networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0) {
            Object object = this.mLock;
            synchronized (object) {
                this.mNetworkType = "cell";
                this.mCellSubType = AnaUtils.getNetworkGen(networkInfo.getSubtype());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLocalDns() {
        NetworkInfo networkInfo;
        if (Build.VERSION.SDK_INT >= 21 && (networkInfo = this.mConnectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            for (Network network : this.mConnectivityManager.getAllNetworks()) {
                List list;
                LinkProperties linkProperties;
                NetworkInfo networkInfo2 = this.mConnectivityManager.getNetworkInfo(network);
                if (networkInfo2 == null || networkInfo2.getType() != networkInfo.getType() || !networkInfo2.isConnected() || (linkProperties = this.mConnectivityManager.getLinkProperties(network)) == null || (list = linkProperties.getDnsServers()) == null || list.isEmpty()) continue;
                Object object = this.mLock;
                synchronized (object) {
                    this.mLocalDns = ((InetAddress)list.get(0)).getHostAddress();
                    return;
                }
            }
        }
    }

    private String mapWifiSubType() {
        int n2;
        WifiInfo wifiInfo;
        if (this.mWifiManager != null && (wifiInfo = this.mWifiManager.getConnectionInfo()) != null && (n2 = wifiInfo.getLinkSpeed()) > 0) {
            if (n2 <= 11) {
                return "B";
            }
            if (n2 <= 54) {
                return "G";
            }
            if (n2 <= 600) {
                return "N";
            }
            if (n2 <= 6934) {
                return "AC";
            }
            return "AD";
        }
        return "";
    }

    public String getLocalDns() {
        return this.mLocalDns;
    }

    public String getWifiSubType() {
        return this.mWifiSubType;
    }

    public String getNetworkType() {
        return this.mNetworkType;
    }

    public String getCellSubType() {
        return this.mCellSubType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIPv6Support() {
        this.mIsIPv6Supported = false;
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    for (Network network : this.mConnectivityManager.getAllNetworks()) {
                        List list;
                        LinkProperties linkProperties;
                        NetworkInfo networkInfo2 = this.mConnectivityManager.getNetworkInfo(network);
                        if (networkInfo2 == null || networkInfo2.getType() != networkInfo.getType() || !networkInfo2.isConnected() || (linkProperties = this.mConnectivityManager.getLinkProperties(network)) == null || (list = linkProperties.getLinkAddresses()) == null || list.isEmpty()) continue;
                        for (LinkAddress linkAddress : list) {
                            if (linkAddress == null || !(linkAddress.getAddress() instanceof Inet6Address)) continue;
                            Object object = this.mLock;
                            synchronized (object) {
                                this.mIsIPv6Supported = true;
                                return;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logger.dd((String)"AkaNetUtils Exception determining IPv6 support", (Object[])new Object[0]);
            }
        }
    }

    public boolean isIPv6Supported() {
        return this.mIsIPv6Supported;
    }

    @RequiresApi(value=26)
    private class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private NetworkCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (networkCapabilities != null && networkCapabilities.hasTransport(0)) {
                Object object = AkaNetUtils.this.mLock;
                synchronized (object) {
                    AkaNetUtils.this.mNetworkType = "cell";
                    NetworkInfo networkInfo = AkaNetUtils.this.mConnectivityManager.getActiveNetworkInfo();
                    if (networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 0) {
                        AkaNetUtils.this.mCellSubType = AnaUtils.getNetworkGen(networkInfo.getSubtype());
                        AkaNetUtils.this.mWifiSubType = "";
                    }
                }
            }
            if (networkCapabilities.hasTransport(1)) {
                Object object = AkaNetUtils.this.mLock;
                synchronized (object) {
                    AkaNetUtils.this.mNetworkType = "wifi";
                    AkaNetUtils.this.mWifiSubType = AkaNetUtils.this.mapWifiSubType();
                    AkaNetUtils.this.mCellSubType = "";
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            AkaNetUtils.this.mIsIPv6Supported = false;
            if (linkProperties != null) {
                Object object;
                Object object2;
                List list = linkProperties.getLinkAddresses();
                if (list != null && !list.isEmpty()) {
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (LinkAddress)object2.next();
                        if (object == null || !(object.getAddress() instanceof Inet6Address)) continue;
                        Object object3 = AkaNetUtils.this.mLock;
                        synchronized (object3) {
                            AkaNetUtils.this.mIsIPv6Supported = true;
                        }
                    }
                }
                if ((object2 = linkProperties.getDnsServers()) != null && !object2.isEmpty()) {
                    object = AkaNetUtils.this.mLock;
                    synchronized (object) {
                        AkaNetUtils.this.mLocalDns = ((InetAddress)object2.get(0)).getHostAddress();
                    }
                }
            }
        }
    }

    private class NetworkChangeReceiver
    extends BroadcastReceiver {
        private NetworkChangeReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            try {
                if (!AkaNetUtils.this.isNetworkAvail()) {
                    Object object = AkaNetUtils.this.mLock;
                    synchronized (object) {
                        AkaNetUtils.this.mLocalDns = "";
                        AkaNetUtils.this.mWifiSubType = "";
                        AkaNetUtils.this.mIsIPv6Supported = false;
                    }
                    return;
                }
                AkaNetUtils.this.initializeLocalDns();
                AkaNetUtils.this.initializeNetworkTypes();
                VocAccelerator.getInstance().getMultiPathHandler().clearWinnerIps();
                AkaNetUtils.this.initializeIPv6Support();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

