/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Build;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import androidx.collection.LruCache;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.R;
import com.akamai.android.sdk.internal.AkaStatusHelper;
import com.akamai.android.sdk.internal.AnaBitRateCalculator;
import com.akamai.android.sdk.internal.AnaNetworkQualityStatus;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AkaNetworkQualityHandler {
    private final Context mContext;
    private final String LOGTAG = "CngDtctr";
    private final String CONGESTION_FLAG = "CongestionFlag";
    private static final int RESULT_RETRY = 3;
    private static final long TIME_DELTA_IN_MS = 60000L;
    private static final String PARAM_ECHO = "echo";
    private static final String sEchoPayload = AkaNetworkQualityHandler.randomString(40);
    @SuppressLint(value={"StaticFieldLeak"})
    private static AkaNetworkQualityHandler sInstance;
    private final Hashtable<String, AnaNetworkQualityStatus> mCongestionTable = new Hashtable();
    private final LruCache<String, LinkedList<Long>> mCongestionMap = new LruCache(10);
    private String mCurrentCellKey = "";
    private int mCurrentNetworkType = -1;
    private int mCurrentCellSubType = 0;
    private final Hashtable<String, Long[]> mTcpBufferTable = new Hashtable();
    private volatile boolean mCongRunning = false;
    private boolean mHostNameVerified = true;
    private final ConnectivityManager mConnectivityManager;
    private HostnameVerifier mHostnameVerifier;
    private static final long DEFAULT_RWIN_10_30MBPS = 511104L;
    private static final long DEFAULT_RWIN_2_15MBPS = 255552L;
    private static final long DEFAULT_RWIN_1_5MBPS = 127776L;
    private static final long DEFAULT_RWIN_2MPBS = 63888L;

    private AkaNetworkQualityHandler(Context context) {
        this.mContext = context.getApplicationContext();
        this.mCongestionTable.put("CongestionFlag", new AnaNetworkQualityStatus());
        this.mConnectivityManager = VocAccelerator.getInstance().getConnectivityManager();
    }

    public static synchronized AkaNetworkQualityHandler getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new AkaNetworkQualityHandler(context);
        }
        return sInstance;
    }

    public static AnaNetworkQualityStatus getNetworkQuality(Context context) {
        return AkaNetworkQualityHandler.getInstance(context).getStatus();
    }

    public static void startNQDetection(Context context) {
        AkaNetworkQualityHandler.getInstance(context).startDetection();
    }

    public synchronized void startDetection() {
        if (!AnaUtils.isCongestionControlEnabled()) {
            return;
        }
        if (!this.mCongRunning) {
            this.mCongRunning = true;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AkaNetworkQualityHandler.this.hasCongestion(1, true);
                        int n2 = AnaUtils.getNetworkQualityPingCount(AkaNetworkQualityHandler.this.mContext);
                        int n3 = AnaUtils.getNetworkQualityFrequency(AkaNetworkQualityHandler.this.mContext);
                        while (AnaUtils.isCongestionControlEnabled() && VocAccelerator.getInstance().isAppInForeground()) {
                            AkaNetworkQualityHandler.this.hasCongestion(n2, true);
                            Thread.sleep(n3 * 1000);
                        }
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: startDetection", (Throwable)exception);
                    }
                    finally {
                        AkaNetworkQualityHandler.this.setCongestionRunning(false);
                    }
                }
            });
            thread.start();
        }
    }

    private synchronized boolean isCongestionRunning() {
        return this.mCongRunning;
    }

    private synchronized void setCongestionRunning(boolean bl2) {
        this.mCongRunning = bl2;
    }

    public void reset() {
        this.mCongestionTable.put("CongestionFlag", new AnaNetworkQualityStatus());
    }

    private AnaNetworkQualityStatus getStatus() {
        AnaNetworkQualityStatus anaNetworkQualityStatus = this.mCongestionTable.get("CongestionFlag");
        long l2 = System.currentTimeMillis() - anaNetworkQualityStatus.timeStamp;
        if (l2 > 60000L) {
            anaNetworkQualityStatus.networkQuality = -1;
            VocAccelerator.getInstance().submitTask(new Runnable(){

                @Override
                public void run() {
                    AkaNetworkQualityHandler.this.startDetection();
                }
            });
        }
        return anaNetworkQualityStatus;
    }

    private int canDownload() {
        return this.mCongestionTable.get((Object)"CongestionFlag").networkQuality;
    }

    private int getReadTimeOutForNetwork(int n2) {
        int n3 = 600;
        String string = AnaUtils.getNetworkGen(n2);
        if (n2 == 0) {
            n3 = AnaUtils.get4GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("2g")) {
            n3 = AnaUtils.get2GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            n3 = AnaUtils.get3GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            n3 = AnaUtils.get3_5GTestTimeout(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            n3 = AnaUtils.get4GTestTimeout(this.mContext);
        }
        return n3;
    }

    public void detectCongestion() {
        try {
            if (!this.isCongestionRunning()) {
                this.hasCongestion(5, false);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: detectCongestion", (Throwable)exception);
        }
    }

    public String getResponseStr() {
        long l2 = -1L;
        long l3 = -1L;
        return l3 + "ms," + l2 + " ms, cong:" + this.canDownload();
    }

    private boolean isCongestionCheckEnabled() {
        return AnaUtils.isCongestionControlEnabled();
    }

    private void hasCongestion(int n2, boolean bl2) {
        int n3 = -1;
        int n4 = AnaUtils.getNetworkQualityPingFrequency(this.mContext) * 1000;
        String string = AnaUtils.getNetworkQualityMethod(this.mContext);
        CongResponse congResponse = new CongResponse();
        String string2 = "";
        int n5 = -1;
        long l2 = -1L;
        AnaBitRateCalculator anaBitRateCalculator = AnaBitRateCalculator.getInstance();
        AnaNetworkQualityStatus anaNetworkQualityStatus = new AnaNetworkQualityStatus();
        if (AnaUtils.isWifiConnected(this.mContext)) {
            n5 = 1;
        } else if (AnaUtils.isCellularConnected(this.mContext)) {
            n5 = 0;
        }
        anaNetworkQualityStatus.networkType = n5;
        int n6 = this.getCurrentNetworkSubType();
        if (this.mCurrentNetworkType != n5 || this.mCurrentCellSubType != n6) {
            anaBitRateCalculator.clear();
        }
        this.mCurrentCellSubType = n6;
        this.mCurrentNetworkType = n5;
        boolean bl3 = false;
        if (!this.isCongestionCheckEnabled()) {
            anaNetworkQualityStatus.networkQuality = -1;
            this.mCongestionTable.put("CongestionFlag", anaNetworkQualityStatus);
        } else if (!AnaUtils.isCongestionControlEnabledWifi(this.mContext) && AnaUtils.isWifiConnected(this.mContext)) {
            anaNetworkQualityStatus.networkQuality = -1;
        } else {
            long l3 = this.getHighThreshold(this.mCurrentCellSubType) / 1000L;
            long l4 = this.getLowThreshold(this.mCurrentCellSubType) / 1000L;
            string2 = AnaUtils.getNetworkGen(this.mCurrentCellSubType);
            double d2 = 0.0;
            Trendline trendline = null;
            long l5 = anaBitRateCalculator.getAverageBitRate();
            l2 = anaBitRateCalculator.getAverageRTT();
            if (l5 <= 0L || l2 <= 0L) {
                int n7;
                bl3 = true;
                int n8 = 3;
                long l6 = 0L;
                int n9 = 5;
                ArrayList<Long> arrayList = new ArrayList<Long>(n9);
                ArrayList<Long> arrayList2 = new ArrayList<Long>(n9);
                int n10 = 0;
                int n11 = 0;
                int n12 = 1;
                for (n7 = 0; n7 < n2; ++n7) {
                    try {
                        String string3 = this.prepareRequest();
                        congResponse = string.equalsIgnoreCase("tcp") ? this.invokeTcpRequest(string3) : this.invokeHttpRequest();
                        n8 = congResponse.congLevel;
                        l6 = congResponse.bitRate;
                        if (congResponse.responseTime > 0L) {
                            n11 = (int)((long)n11 + congResponse.responseTime);
                            n10 = n11 / n12;
                            ++n12;
                        }
                        if (l6 == 0L) {
                            this.updateNetworkQuality(anaNetworkQualityStatus, 2, -1, AnaUtils.getNetworkGen(this.mCurrentCellSubType), bl2);
                            n3 = 2;
                            continue;
                        }
                        if (l6 <= 0L || n7 <= 0 && n2 != 1) continue;
                        arrayList.add(l6);
                        arrayList2.add(System.currentTimeMillis() / 1000L);
                        if (this.mCongestionMap.get((Object)this.mCurrentCellKey) != null) {
                            LinkedList linkedList = (LinkedList)this.mCongestionMap.get((Object)this.mCurrentCellKey);
                            if (linkedList.size() == 30) {
                                linkedList.removeFirst();
                            }
                            linkedList.addLast(l6);
                        }
                        if (n8 != 3) {
                            n3 = n8;
                            break;
                        }
                        if (n7 + 1 >= n2) continue;
                        Thread.sleep(n4);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: hasCongestion(): ", (Throwable)exception);
                    }
                }
                if (n8 == 3 && n7 >= n2 && arrayList.size() > 0) {
                    trendline = new Trendline(arrayList, arrayList2);
                    long l7 = 0L;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) != null && (l7 = this.calculateAverage((LinkedList)this.mCongestionMap.get((Object)this.mCurrentCellKey))) > 0L) {
                        d2 = (double)(trendline.avg - l7) / (double)l7 * 100.0;
                    }
                    l5 = trendline.avg;
                }
                l2 = n10;
            }
            if (l5 > 0L) {
                if (l5 >= l3) {
                    n3 = 0;
                } else if (l5 <= l4) {
                    n3 = 2;
                } else {
                    n3 = 1;
                    if (bl3) {
                        long l8 = (l3 - l5) * 100L / (l3 - l4);
                        Random random = new Random();
                        int n13 = random.nextInt(100);
                        if (l8 >= 80L && n13 <= 40 || l8 >= 60L && n13 <= 20 || l8 >= 40L && n13 <= 5 || l8 <= 20L && n13 == 0) {
                            n3 = 2;
                        }
                        if (n3 == 1) {
                            if (this.mCongestionTable.get((Object)"CongestionFlag").networkQuality == 2 && d2 < 0.0) {
                                n3 = 2;
                            } else if (d2 < -30.0 && trendline.slope < -50.0) {
                                n3 = 2;
                            } else if (d2 < -60.0 && trendline.slope < 0.0) {
                                n3 = 2;
                            }
                        }
                    }
                }
            }
        }
        this.updateNetworkQuality(anaNetworkQualityStatus, n3, (int)l2, string2, bl2);
    }

    private void updateNetworkQuality(AnaNetworkQualityStatus anaNetworkQualityStatus, int n2, int n3, String string, boolean bl2) {
        AnaNetworkQualityStatus anaNetworkQualityStatus2 = this.mCongestionTable.get("CongestionFlag");
        if (n2 != anaNetworkQualityStatus2.networkQuality && bl2) {
            this.mContext.sendBroadcast(AkaStatusHelper.createCongestionStatusIntent(this.mContext, n2));
        }
        anaNetworkQualityStatus.networkQuality = n2;
        anaNetworkQualityStatus.rtt = n3;
        anaNetworkQualityStatus.networkSubType = this.mCurrentCellSubType;
        anaNetworkQualityStatus.networkGen = string;
        anaNetworkQualityStatus.timeStamp = System.currentTimeMillis();
        this.mCongestionTable.put("CongestionFlag", anaNetworkQualityStatus);
        Logger.dd((String)"AkaSdkLogger-map", (String)("NetworkQualityStatus: " + anaNetworkQualityStatus.toString()));
    }

    private long calculateAverage(LinkedList<Long> linkedList) {
        long l2 = 0L;
        if (linkedList.size() > 0) {
            long l3 = 0L;
            for (Long l4 : linkedList) {
                l3 += l4.longValue();
            }
            l2 = l3 / (long)linkedList.size();
        }
        return l2;
    }

    private int processResponse(String string) throws NumberFormatException {
        long l2 = Calendar.getInstance(TimeZone.getTimeZone("utc")).getTimeInMillis();
        int n2 = 3;
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                if (string2.startsWith("Cellload")) {
                    int n3 = Integer.parseInt(string2.split("=")[1]);
                    if (n3 <= 0) continue;
                    int n4 = AnaUtils.getCongestionControlHighThreshold(this.mContext);
                    int n5 = AnaUtils.getCongestionControlLowThreshold(this.mContext);
                    if (n3 >= n4) {
                        n2 = 2;
                        continue;
                    }
                    if (n3 <= n5) {
                        n2 = 0;
                        continue;
                    }
                    if (n3 <= n5 || n3 >= n4) continue;
                    n2 = 1;
                    continue;
                }
                if (!string2.startsWith("ServerTS")) continue;
                l2 = Long.parseLong(string2.split("=")[1]);
            }
        }
        return n2;
    }

    @SuppressLint(value={"MissingPermission"})
    private String prepareRequest() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            CellLocation cellLocation = null;
            if (telephonyManager != null) {
                cellLocation = telephonyManager.getCellLocation();
            }
            String string = this.getLocalIpAddress();
            if (cellLocation != null) {
                if (cellLocation instanceof GsmCellLocation) {
                    int n2;
                    int n3 = ((GsmCellLocation)cellLocation).getCid();
                    if (n3 > -1) {
                        stringBuilder.append(",Cellid=").append(n3);
                    }
                    if ((n2 = ((GsmCellLocation)cellLocation).getLac()) > -1) {
                        stringBuilder.append(",Lac=").append(n2);
                    }
                    this.mCurrentCellSubType = this.getCurrentNetworkSubType();
                    this.mCurrentCellKey = n3 + "-" + this.mCurrentCellSubType;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) == null) {
                        this.mCongestionMap.put((Object)this.mCurrentCellKey, new LinkedList());
                    }
                } else if (cellLocation instanceof CdmaCellLocation) {
                    int n4 = ((CdmaCellLocation)cellLocation).getBaseStationId();
                    int n5 = ((CdmaCellLocation)cellLocation).getBaseStationLatitude();
                    int n6 = ((CdmaCellLocation)cellLocation).getBaseStationLongitude();
                    if (n4 > -1) {
                        stringBuilder.append(",BaseId=").append(n4);
                    }
                    if (n5 > -1) {
                        stringBuilder.append(",BaseLat=").append(n5);
                    }
                    if (n6 > -1) {
                        stringBuilder.append(",BaseLong=").append(n6);
                    }
                    this.mCurrentCellSubType = this.getCurrentNetworkSubType();
                    this.mCurrentCellKey = n6 + "-" + this.mCurrentCellSubType;
                    if (this.mCongestionMap.get((Object)this.mCurrentCellKey) == null) {
                        this.mCongestionMap.put((Object)this.mCurrentCellKey, new LinkedList());
                    }
                }
            }
            if (string.length() > 0) {
                stringBuilder.append(",Ip=").append(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    private int getCurrentNetworkSubType() {
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.getSubtype();
        }
        return 0;
    }

    private String getLocalIpAddress() {
        String string = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    string = inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            Logger.e((String)"AkaSdkLogger-map", (String)("CngDtctr: " + socketException.toString()));
        }
        return string;
    }

    private CongResponse invokeTcpRequest(String string) {
        int n2 = this.getCurrentNetworkSubType();
        long l2 = 0L;
        String string2 = AnaUtils.getCongestionControlServer(this.mContext);
        int n3 = AnaUtils.getCongestionControlPort(this.mContext);
        long l3 = AnaUtils.getCongestionControlRetryInterval(this.mContext);
        int n4 = this.getCurrentNetworkSubType();
        int n5 = this.getReadTimeOutForNetwork(n4);
        long l4 = -1L;
        int n6 = 0;
        String string3 = "";
        long l5 = 0L;
        ConnectionHandler connectionHandler = ConnectionHandler.getInstance();
        long l6 = System.currentTimeMillis();
        int n7 = 0;
        try {
            connectionHandler.sendRequest(string2, n3, string, n5);
            string3 = connectionHandler.readResponse();
            l5 = System.currentTimeMillis();
            n7 = this.processResponse(string3);
            l2 = l5 - l6;
            if (l2 <= 0L) {
                l2 = 1L;
            }
            n6 = string3.getBytes().length * 8;
            l4 = this.downloadSpeed("tcp", n6 * 2, l2, n2);
        }
        catch (IOException iOException) {
            Logger.e((String)"AkaSdkLogger-map", (String)"CngDtctr: invokeTcpRequest(): ", (Throwable)iOException);
            if (iOException instanceof SocketTimeoutException) {
                l4 = 0L;
            }
            connectionHandler.forceNewSocketCreation();
        }
        CongResponse congResponse = new CongResponse(n7, l4, l2);
        return congResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CongResponse invokeHttpRequest() {
        Object object;
        int n2 = this.getCurrentNetworkSubType();
        String string = AnaUtils.getNetworkGen(this.getCurrentNetworkSubType());
        long l2 = -1L;
        int n3 = this.getReadTimeOutForNetwork(n2);
        long l3 = -1L;
        String string2 = "https://";
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            object = AnaUtils.getNetworkQualityMethod(this.mContext);
            if (!this.mHostNameVerified || ((String)object).equals("http")) {
                string2 = "http://";
            }
            Uri.Builder builder = new Uri.Builder().encodedPath(string2 + AnaUtils.getNetworkQualityUri(this.mContext));
            builder.appendQueryParameter(PARAM_ECHO, sEchoPayload);
            String string3 = builder.toString();
            URL uRL = new URL(string3);
            long l4 = TrafficStats.getUidRxBytes((int)this.mContext.getApplicationInfo().uid);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string4 = AkaHttpUtils.getAMCHeaderString(false);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                httpURLConnection.setRequestProperty("Akamai-Mobile-Connectivity", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)VocAccelerator.sPackageName)) {
                httpURLConnection.setRequestProperty("Akamai-Referrer", VocAccelerator.sPackageName);
            }
            httpURLConnection.setRequestProperty("x-akamai-log", "false");
            httpURLConnection.setRequestProperty("x-user-type", "sdk");
            if (httpURLConnection instanceof HttpsURLConnection) {
                if (!TextUtils.isEmpty((CharSequence)this.mCurrentCellKey)) {
                    String string5 = AnaUtils.getCarrier(this.mContext);
                    httpURLConnection.setRequestProperty("Akamai-Cell-Info", TextUtils.isEmpty((CharSequence)string5) ? this.mCurrentCellKey : string5 + "/" + this.mCurrentCellKey);
                }
                if (this.mHostnameVerifier == null) {
                    this.mHostnameVerifier = new HostnameVerifier(){

                        @Override
                        public boolean verify(String string, SSLSession sSLSession) {
                            AkaNetworkQualityHandler.this.mHostNameVerified = HttpsURLConnection.getDefaultHostnameVerifier().verify(string, sSLSession) || HttpsURLConnection.getDefaultHostnameVerifier().verify("a248.e.akamai.net", sSLSession);
                            return AkaNetworkQualityHandler.this.mHostNameVerified;
                        }
                    };
                }
                if ("production".equals("mock")) {
                    httpURLConnection = this.pinCertsForMocking((HttpsURLConnection)httpURLConnection);
                } else {
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.mHostnameVerifier);
                }
            }
            httpURLConnection.setReadTimeout(n3);
            httpURLConnection.setUseCaches(false);
            int n4 = httpURLConnection.getResponseCode();
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            if (n4 == 200 || n4 == 204) {
                int n5;
                inputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                byte[] byArray = new byte[8192];
                int n6 = 0;
                while ((n5 = inputStream.read(byArray)) != -1) {
                    n6 += n5;
                }
                long l5 = System.nanoTime();
                long l6 = Long.parseLong(httpURLConnection.getHeaderField("X-Android-Sent-Millis"));
                long l7 = Long.parseLong(httpURLConnection.getHeaderField("X-Android-Received-Millis"));
                long l8 = TrafficStats.getUidRxBytes((int)this.mContext.getApplicationInfo().uid);
                l2 = this.downloadSpeed("htp", n6, l7 - l6, n2);
                l3 = l7 - l6;
                editor.remove("last_ping_fail_ec");
                editor.remove("last_ping_fail_ts");
                editor.apply();
            } else {
                editor.putInt("last_ping_fail_ec", n4);
                editor.putLong("last_ping_fail_ts", System.currentTimeMillis());
                editor.apply();
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketTimeoutException) {
                l2 = 0L;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        object = new CongResponse(3, l2, l3);
        return object;
    }

    private long downloadSpeed(String string, long l2, long l3, int n2) {
        long l4 = this.getDefaultTcpBufferSize(this.getCurrentNetworkSubType());
        Long[] longArray = this.getTcpBufferSize();
        if (longArray.length > 0 && longArray[0] < l4) {
            l4 = longArray[0];
        }
        long l5 = l4 / l3;
        return l5;
    }

    private String displayString(long l2) {
        long l3 = 1024L;
        long l4 = l3 * 1024L;
        long l5 = l4 * 1024L;
        if (l2 < l3) {
            return l2 + " bit-sec";
        }
        if (l2 > l3 && l2 < l4) {
            return l2 / l3 + " Kbit-sec";
        }
        if (l2 > l4 && l2 < l5) {
            return l2 / l4 + " Mbit-sec";
        }
        if (l2 > l5) {
            return l2 / l5 + " Gbit-sec";
        }
        return "???";
    }

    private static String randomString(int n2) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(random.nextInt(9));
        }
        return stringBuilder.toString();
    }

    private long getHighThreshold(int n2) {
        long l2 = 0x100000L;
        String string = AnaUtils.getNetworkGen(n2);
        if (string.toLowerCase().contains("2g")) {
            l2 = AnaUtils.getEDGECongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            l2 = AnaUtils.get3GCongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            l2 = AnaUtils.getHSPACongHighThreshold(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            l2 = AnaUtils.getLTECongHighThreshold(this.mContext);
        }
        return l2;
    }

    private long getLowThreshold(int n2) {
        long l2 = 524288L;
        String string = AnaUtils.getNetworkGen(n2);
        if (string.toLowerCase().contains("2g")) {
            l2 = AnaUtils.getEDGECongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3g")) {
            l2 = AnaUtils.get3GCongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("3.5g")) {
            l2 = AnaUtils.getHSPACongLowThreshold(this.mContext);
        } else if (string.toLowerCase().contains("4g")) {
            l2 = AnaUtils.getLTECongLowThreshold(this.mContext);
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long[] getTcpBufferSize() {
        Long[] longArray;
        String string;
        block11: {
            int n2;
            Network[] networkArray;
            NetworkInfo networkInfo;
            block13: {
                int n3;
                block12: {
                    n3 = this.getCurrentNetworkSubType();
                    string = Integer.toString(n3);
                    if (this.mTcpBufferTable.containsKey(string)) {
                        return this.mTcpBufferTable.get(string);
                    }
                    long l2 = this.getDefaultTcpBufferSize(n3);
                    longArray = new Long[]{l2, l2, l2};
                    if (Build.VERSION.SDK_INT < 21) break block12;
                    networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
                    if (networkInfo == null || !networkInfo.isConnected()) break block11;
                    networkArray = this.mConnectivityManager.getAllNetworks();
                    n2 = networkArray.length;
                    break block13;
                }
                if (Build.VERSION.SDK_INT < 15) break block11;
                String string2 = "";
                if (AnaUtils.isWifiConnected(this.mContext)) {
                    string2 = "net.tcp.buffersize.wifi";
                } else if (AnaUtils.isCellularConnected(this.mContext)) {
                    string2 = AnaUtils.getTcpBufferProperty(n3);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    try {
                        String[] stringArray;
                        String string3 = AnaUtils.getProperty(string2);
                        if (!TextUtils.isEmpty((CharSequence)string3) && (stringArray = string3.split(",")).length > 0) {
                            longArray[0] = Long.parseLong(stringArray[0]) * 8L;
                            longArray[1] = Long.parseLong(stringArray[1]) * 8L;
                            longArray[2] = Long.parseLong(stringArray[2]) * 8L;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        Logger.d((String)"AkaSdkLogger-map", (String)("CngDtctr: getTcpBufferSize(): " + exception));
                    }
                }
                break block11;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Network network = networkArray[i2];
                NetworkInfo networkInfo2 = this.mConnectivityManager.getNetworkInfo(network);
                if (networkInfo2 == null || networkInfo2.getType() != networkInfo.getType() || !networkInfo2.isConnected()) continue;
                LinkProperties linkProperties = this.mConnectivityManager.getLinkProperties(network);
                try {
                    String[] stringArray;
                    Method method = linkProperties.getClass().getMethod("getTcpBufferSizes", null);
                    String string4 = (String)method.invoke((Object)linkProperties, (Object[])null);
                    if (TextUtils.isEmpty((CharSequence)string4) || (stringArray = string4.split(",")).length <= 0) break;
                    longArray[0] = Long.parseLong(stringArray[0]) * 8L;
                    longArray[1] = Long.parseLong(stringArray[1]) * 8L;
                    longArray[2] = Long.parseLong(stringArray[2]) * 8L;
                }
                catch (Exception exception) {
                    Logger.d((String)"AkaSdkLogger-map", (String)("CngDtctr: getTcpBufferSize(): " + exception));
                }
                break;
            }
        }
        this.mTcpBufferTable.put(string, longArray);
        return longArray;
    }

    private long getDefaultTcpBufferSize(int n2) {
        long l2 = 63888L;
        if (n2 != 0) {
            String string = AnaUtils.getNetworkGen(this.getCurrentNetworkSubType());
            if (string.equalsIgnoreCase("4g")) {
                l2 = 511104L;
            }
            if (string.equalsIgnoreCase("3.5g")) {
                l2 = 255552L;
            }
            if (string.equalsIgnoreCase("3g")) {
                l2 = 127776L;
            }
            if (string.equalsIgnoreCase("2g")) {
                l2 = 63888L;
            }
        } else if (AnaUtils.isWifiConnected(this.mContext)) {
            l2 = 511104L;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection pinCertsForMocking(HttpsURLConnection httpsURLConnection) throws CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        Certificate certificate;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        try (InputStream inputStream = this.mContext.getResources().openRawResource(R.raw.map);){
            certificate = certificateFactory.generateCertificate(inputStream);
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("ca=" + ((X509Certificate)certificate).getSubjectDN()));
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] x509CertificateArray = new X509Certificate[]{};
                x509CertificateArray[0] = (X509Certificate)certificate;
                return x509CertificateArray;
            }
        }}, null);
        httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
        httpsURLConnection.setHostnameVerifier(new NullHostNameVerifier());
        return httpsURLConnection;
    }

    class NullHostNameVerifier
    implements HostnameVerifier {
        NullHostNameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            if (string.equals("127.0.0.1")) {
                AkaLogger.in((String)"AkaSdkLogger-map", (String)("NullHostNameVerifier Approving certificate for " + string));
                return true;
            }
            return false;
        }
    }

    private static final class CongResponse {
        int congLevel = -1;
        long bitRate = -1L;
        long responseTime = -1L;

        CongResponse() {
        }

        CongResponse(int n2, long l2, long l3) {
            this.congLevel = n2;
            this.bitRate = l2;
            this.responseTime = l3;
        }
    }

    private class Trendline {
        private final ArrayList<Long> xAxisValues;
        private final ArrayList<Long> yAxisValues;
        private int count;
        private long xAxisValuesSum;
        private long xxSum;
        private long xySum;
        private long yAxisValuesSum;
        long avg;
        double slope;
        double intercept;
        double start;
        double stop;

        Trendline(ArrayList<Long> arrayList, ArrayList<Long> arrayList2) {
            this.yAxisValues = arrayList;
            this.xAxisValues = arrayList2;
            this.Initialize();
        }

        private void Initialize() {
            this.count = this.yAxisValues.size();
            long l2 = 0L;
            for (Long l3 : this.yAxisValues) {
                l2 += l3.longValue();
            }
            this.avg = l2 / (long)this.count;
            this.yAxisValuesSum = l2;
            l2 = 0L;
            for (Long l3 : this.xAxisValues) {
                l2 += l3.longValue();
            }
            this.xAxisValuesSum = l2;
            this.xxSum = 0L;
            this.xySum = 0L;
            for (int i2 = 0; i2 < this.count; ++i2) {
                this.xySum += this.xAxisValues.get(i2) * this.yAxisValues.get(i2);
                this.xxSum += this.xAxisValues.get(i2) * this.xAxisValues.get(i2);
            }
            this.slope = this.CalculateSlope();
            this.intercept = this.CalculateIntercept();
            this.start = this.CalculateStart();
            this.stop = this.CalculateEnd();
        }

        private double CalculateSlope() {
            try {
                double d2 = (long)this.count * this.xySum - this.xAxisValuesSum * this.yAxisValuesSum;
                double d3 = (long)this.count * this.xxSum - this.xAxisValuesSum * this.xAxisValuesSum;
                if (d2 > 0.0 && d3 > 0.0) {
                    this.slope = d2 / d3;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return this.slope;
        }

        private double CalculateIntercept() {
            return ((double)this.yAxisValuesSum - this.slope * (double)this.xAxisValuesSum) / (double)this.count;
        }

        private double CalculateStart() {
            return this.slope * (double)this.xAxisValues.get(0).longValue() + this.intercept;
        }

        private double CalculateEnd() {
            return this.slope * (double)this.xAxisValues.get(this.count - 1).longValue() + this.intercept;
        }
    }

    private static class ConnectionHandler {
        private Socket mSocket = null;
        private DataOutputStream mOutputToServer = null;
        private BufferedReader mInputFromServer = null;
        private static ConnectionHandler sInstance = null;
        private final String LOGTAG = "ConnectionHandler";

        private ConnectionHandler() {
        }

        static synchronized ConnectionHandler getInstance() {
            if (sInstance == null) {
                sInstance = new ConnectionHandler();
            }
            return sInstance;
        }

        boolean sendRequest(String string, int n2, String string2, int n3) throws IOException {
            if (!this.openConnection(string, n2, n3)) {
                return false;
            }
            this.mOutputToServer.writeBytes(string2 + '\n');
            return true;
        }

        String readResponse() throws IOException {
            return this.mInputFromServer.readLine();
        }

        synchronized void forceNewSocketCreation() {
            if (this.mSocket != null) {
                try {
                    this.mInputFromServer.close();
                    this.mOutputToServer.close();
                    this.mSocket.close();
                }
                catch (IOException iOException) {
                    Logger.e((String)"AkaSdkLogger-map", (String)"ConnectionHandler: forceNewSocketCreation(): ", (Throwable)iOException);
                }
            }
            this.mInputFromServer = null;
            this.mOutputToServer = null;
            this.mSocket = null;
        }

        synchronized boolean openConnection(String string, int n2, int n3) {
            try {
                if (this.requiresNewConnection()) {
                    this.mSocket = new Socket(string, n2);
                    this.mSocket.setSoTimeout(n3);
                    this.mOutputToServer = new DataOutputStream(this.mSocket.getOutputStream());
                    this.mInputFromServer = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream()));
                }
            }
            catch (IOException iOException) {
                Logger.e((String)"AkaSdkLogger-map", (String)"ConnectionHandler: openConnection(): ", (Throwable)iOException);
                return false;
            }
            return true;
        }

        private boolean requiresNewConnection() throws IOException {
            boolean bl2 = false;
            if (this.mSocket == null) {
                bl2 = true;
            } else if (!this.mSocket.isConnected()) {
                this.mInputFromServer.close();
                this.mOutputToServer.close();
                this.mSocket.close();
                bl2 = true;
            }
            return bl2;
        }

        public void setTimeOut(int n2) throws IOException {
            if (this.mSocket != null) {
                this.mSocket.setSoTimeout(n2);
            }
        }
    }
}

