/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.MapSdkInfo;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.internal.AkaSegmentManifestParser;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaStatusHelper;
import com.akamai.android.sdk.internal.AppBatteryTestConnection;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import com.akamai.android.sdk.util.VocUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class AkaSegmentManifestDownloader {
    private static final String LOG_TAG = "AkaSegmentManifestDownloader";
    private static final int HTTP_SUCCESS = 200;
    private static final int HTTP_REDIRECTION = 300;
    private static final int HTTP_NOT_MODIFIED = 304;
    private static AkaSegmentManifestDownloader sInstance;

    public static synchronized AkaSegmentManifestDownloader getInstance() {
        if (sInstance == null) {
            sInstance = new AkaSegmentManifestDownloader();
        }
        return sInstance;
    }

    private AkaSegmentManifestDownloader() {
    }

    public boolean downloadMetaData() {
        boolean bl2 = this.downloadManifests();
        if (bl2) {
            Context context = VocAccelerator.getInstance().getAppContext();
            context.sendBroadcast(AkaStatusHelper.createManifestDownloadedIntent(context));
        }
        return bl2;
    }

    private boolean downloadManifests() {
        List<SegmentInfo> list = AkaSegmentManifestDownloader.getExistingSubscribedSegments(VocAccelerator.getInstance().getAppContext());
        boolean bl2 = false;
        if (list != null) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader: segmentList: " + list));
            for (SegmentInfo segmentInfo : list) {
                boolean bl3 = this.getDownloadManifestForSegment(segmentInfo.mLongName, segmentInfo.mHttpTS, segmentInfo.mServerTS);
                bl2 |= bl3;
            }
            return bl2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDownloadManifestForSegment(String string, String string2, long l2) {
        Context context = VocAccelerator.getInstance().getAppContext();
        boolean bl2 = false;
        BufferedWriter bufferedWriter = null;
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        HttpsURLConnection httpsURLConnection = null;
        try {
            URL uRL = new URL(AkaSessionHandler.getManifestUrl(context, string));
            httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            if (httpsURLConnection != null) {
                String string4;
                httpsURLConnection.setDoInput(true);
                httpsURLConnection.setRequestMethod("GET");
                if ("production".equals("dev")) {
                    httpsURLConnection = new AppBatteryTestConnection().updateHttpsURLConnection(context, httpsURLConnection, "map-manifest.default.abattery.appbattery.nss1.tn.akamai.com");
                } else if ("production".equals("mock")) {
                    httpsURLConnection = new AppBatteryTestConnection().updateHttpsURLConnection(context, httpsURLConnection, "127.0.0.1");
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    httpsURLConnection.setRequestProperty("If-Modified-Since", string2);
                }
                AkaHttpUtils.setControlPathHeaders(httpsURLConnection);
                inputStream = httpsURLConnection.getInputStream();
                if (inputStream == null) {
                    inputStream = httpsURLConnection.getErrorStream();
                }
                int n2 = httpsURLConnection.getResponseCode();
                Logger.d((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader: getDownloadManifest: Status code: " + n2 + ", name: " + string));
                if (n2 >= 200 && n2 < 300) {
                    Object object;
                    Object object2;
                    string4 = VocUtils.getDataPath(context);
                    File file = new File(string4 + "temp_" + System.currentTimeMillis());
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                    if (n2 == 200) {
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        inputStreamReader = new InputStreamReader(bufferedInputStream);
                        bufferedReader = new BufferedReader(inputStreamReader);
                        while ((object2 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write((String)object2);
                        }
                        object = new ContentValues();
                        object.put("downloadManifestTS", Long.valueOf(l2));
                        context.getApplicationContext().getContentResolver().update(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), object, "sgmntlname=?", new String[]{string});
                    } else {
                        bufferedWriter.write("[]");
                    }
                    bufferedWriter.flush();
                    object2 = new File(string4 + string + ".json");
                    if (((File)object2).exists()) {
                        object = new File(string4 + string + ".json.old");
                        ((File)object2).renameTo((File)object);
                    }
                    file.renameTo((File)object2);
                    string3 = httpsURLConnection.getHeaderField("Last-Modified");
                    bl2 = true;
                } else if (n2 == 304) {
                    Logger.dd((String)"AkaSdkLogger-map", (Object[])new Object[]{LOG_TAG, " manifest " + string + " not modified"});
                    string3 = httpsURLConnection.getHeaderField("Last-Modified");
                } else {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader: getDownloadManifestForSegment: " + stringBuilder.toString() + ", name: " + string));
                }
                if (string3 != null && !string3.equalsIgnoreCase(string2)) {
                    string4 = new ContentValues(1);
                    string4.put("httpts", string3);
                    context.getApplicationContext().getContentResolver().update(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), (ContentValues)string4, "sgmntlname=?", new String[]{string});
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader: Exception downloading manifest " + exception.toString()));
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (httpsURLConnection != null) {
                    httpsURLConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    public static void updateUserSegments(Context context, Set<String> set, String string, boolean bl2) {
        Object object;
        String[] stringArray = string.split(",");
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        boolean bl3 = false;
        for (String string2 : stringArray) {
            if (TextUtils.isEmpty((CharSequence)(string2 = string2.trim())) || set.contains(string2)) continue;
            bl3 = true;
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader subscribing the segment-" + string2));
            object = new ContentValues();
            object.put("subscribed", Integer.valueOf(1));
            object.put("downloadManifestTS", Long.valueOf(0L));
            int n2 = context.getApplicationContext().getContentResolver().update(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), (ContentValues)object, "sgmntlname=?", new String[]{string2});
            if (n2 != 0) continue;
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader creating new segment record for " + string2));
            object.put("sgmntlname", string2);
            object.put("sgmntsname", string2);
            object.put("fgSegment", Integer.valueOf(0));
            object.put("timestamp", Integer.valueOf(0));
            object.put("subscribed", Integer.valueOf(1));
            object.put("downloadManifestTS", Integer.valueOf(0));
            context.getApplicationContext().getContentResolver().insert(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), (ContentValues)object);
        }
        for (String string3 : set) {
            String string2;
            if (hashSet.contains(string3)) continue;
            AkaSegmentManifestParser.deleteUrlsAssociatedWithSegment(string3, context);
            ContentValues contentValues = new ContentValues();
            contentValues.put("subscribed", Integer.valueOf(0));
            contentValues.put("downloadManifestTS", Long.valueOf(0L));
            contentValues.put("httpts", "");
            context.getApplicationContext().getContentResolver().update(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), contentValues, "sgmntlname=?", new String[]{string3});
            AkaLogger.in((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader unsubscribing the segment-" + string3));
            string2 = VocUtils.getDataPath(context);
            try {
                File file;
                object = new File(string2 + string3 + ".json");
                if (((File)object).exists()) {
                    ((File)object).delete();
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)"AkaSegmentManifestDownloader segment files deleted");
                }
                if (!(file = new File(string2 + string3 + ".json.old")).exists()) continue;
                file.delete();
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloader addSegments: " + exception.toString()));
            }
        }
        Logger.d((String)"AkaSdkLogger-map", (String)("AkaSegmentManifestDownloaderMAP segments are:" + MapSdkInfo.getSegments(context)));
        if (bl3 && bl2) {
            AkaLogger.in((String)"AkaSdkLogger-map", (String)"AkaSegmentManifestDownloader Performing cache fill");
            AkaBackgroundService.getInstance(context).performFullSync(context, null, true);
        }
    }

    private static void append(LinkedList<String> linkedList, String[] stringArray, int n2) {
        while (n2 < stringArray.length) {
            linkedList.add(stringArray[n2]);
            ++n2;
        }
    }

    @NonNull
    public static List<SegmentInfo> getExistingSubscribedSegments(@NonNull Context context) {
        ArrayList<SegmentInfo> arrayList = new ArrayList<SegmentInfo>();
        Cursor cursor = context.getApplicationContext().getContentResolver().query(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), null, "subscribed=? AND timestamp>?", new String[]{"1", "0"}, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    arrayList.add(new SegmentInfo(cursor));
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        return arrayList;
    }

    public static void removeData(@NonNull Context context) {
        SharedPreferences.Editor editor = AnaUtils.getSDKSharedPreferences(context).edit();
        editor.putInt("http_stats_count", 0);
        editor.putInt("log_events_count", 0);
        editor.putInt("user_events_count", 0);
        editor.apply();
        context.getContentResolver().delete(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, null, null);
        context.getContentResolver().delete(AnaProviderContract.USER_EVENTS_URI, null, null);
        context.getContentResolver().delete(AnaProviderContract.EVENT_LOG_URI, null, null);
        context.getContentResolver().delete(Uri.parse((String)AnaProviderContract.CONTENT_URI_SEGMENT_SUBSCRIPTION.toString()), null, null);
        context.getContentResolver().delete(AnaProviderContract.DELETED_FEEDS_URI, null, null);
        context.getContentResolver().delete(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, null, null);
    }

    static class SegmentInfo {
        final String mLongName;
        final String mHttpTS;
        final long mServerTS;
        final boolean mIsSubscribed;
        final boolean mIsFgSegment;

        SegmentInfo(@NonNull Cursor cursor) {
            this.mLongName = cursor.getString(cursor.getColumnIndex("sgmntlname"));
            this.mHttpTS = cursor.getString(cursor.getColumnIndex("httpts"));
            this.mServerTS = cursor.getLong(cursor.getColumnIndex("timestamp"));
            int n2 = cursor.getInt(cursor.getColumnIndex("subscribed"));
            this.mIsSubscribed = n2 == 1;
            int n3 = cursor.getInt(cursor.getColumnIndex("fgSegment"));
            this.mIsFgSegment = n3 == 1;
        }

        public String toString() {
            return this.mLongName;
        }
    }
}

