/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.expression.ExpressionFactory;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.JobTaskConfigRequest;
import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.ExpressionTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.GraphUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.job.task.support.expression.ExpressionInvocationHandler;
import com.aizuda.snailjob.server.service.convert.WorkflowConverter;
import com.aizuda.snailjob.server.service.kit.WorkflowKit;
import com.aizuda.snailjob.server.service.service.impl.AbstractWorkflowService;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.CheckDecisionVO;
import com.aizuda.snailjob.server.web.model.request.ExportWorkflowVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowQueryVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseWebVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowResponseVO;
import com.aizuda.snailjob.server.web.service.WorkflowWebService;
import com.aizuda.snailjob.server.web.service.convert.WorkflowWebConverter;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.service.handler.WorkflowWebHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.SystemUserMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.SystemUser;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service(value="workflowWebCommonService")
@Validated
public class WorkflowWebServiceImpl
extends AbstractWorkflowService
implements WorkflowWebService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowWebServiceImpl.class);
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final SystemProperties systemProperties;
    private final WorkflowWebHandler workflowWebHandler;
    private final JobMapper jobMapper;
    private final GroupHandler groupHandler;
    private final SystemUserMapper systemUserMapper;

    @Override
    @Transactional
    public boolean saveWorkflow(WorkflowRequestVO workflowRequestVO) {
        log.info("Saved workflow information: {}", (Object)JsonUtil.toJsonString((Object)workflowRequestVO));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        Workflow workflow = WorkflowWebConverter.INSTANCE.convert(workflowRequestVO);
        this.checkTriggerInterval(workflowRequestVO);
        workflow.setVersion(Integer.valueOf(1));
        workflowRequestVO.setTriggerInterval(workflow.getTriggerInterval());
        workflow.setNextTriggerAt(WorkflowKit.calculateNextTriggerAt((Integer)workflowRequestVO.getTriggerType(), (String)workflowRequestVO.getTriggerInterval(), (Long)DateUtils.toNowMilli()));
        workflow.setFlowInfo("");
        workflow.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(workflowRequestVO.getGroupName() + workflowRequestVO.getWorkflowName())) % this.systemProperties.getBucketTotal()));
        workflow.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        workflow.setId(null);
        Assert.isTrue((1 == this.workflowMapper.insert((Object)workflow) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to add workflow"));
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        this.workflowWebHandler.buildGraph(Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque<Long>(), workflowRequestVO.getGroupName(), workflow.getId(), nodeConfig, graph, workflow.getVersion(), workflow.getNamespaceId());
        log.info("Graph construction complete. graph:[{}]", graph);
        workflow.setVersion(null);
        workflow.setOwnerId(Optional.ofNullable(workflowRequestVO.getOwnerId()).orElse(0L));
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        Assert.isTrue((1 == this.workflowMapper.updateById((Object)workflow) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to save workflow graph"));
        return true;
    }

    private void checkTriggerInterval(WorkflowRequestVO workflowRequestVO) {
        TriggerIntervalUtils.checkTriggerInterval((String)workflowRequestVO.getTriggerInterval(), (Integer)workflowRequestVO.getTriggerType());
    }

    private MutableGraph<Long> createGraph() {
        return GraphBuilder.directed().nodeOrder(ElementOrder.sorted(Long::compare)).incidentEdgeOrder(ElementOrder.stable()).allowsSelfLoops(false).build();
    }

    @Override
    public WorkflowDetailResponseWebVO getWorkflowDetail(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getId, (Object)id)).eq(Workflow::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId()));
        if (Objects.isNull(workflow)) {
            return null;
        }
        return this.doGetWorkflowDetail(workflow);
    }

    @Override
    public PageResult<List<WorkflowResponseVO>> listPage(WorkflowQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        PageDTO page = (PageDTO)this.workflowMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(Workflow::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), Workflow::getGroupName, groupNames)).like(StrUtil.isNotBlank((CharSequence)queryVO.getWorkflowName()), Workflow::getWorkflowName, (Object)queryVO.getWorkflowName())).eq(Objects.nonNull(queryVO.getWorkflowStatus()), Workflow::getWorkflowStatus, (Object)queryVO.getWorkflowStatus())).eq(Objects.nonNull(queryVO.getOwnerId()), Workflow::getOwnerId, (Object)queryVO.getOwnerId())).orderByDesc(Workflow::getId));
        List<WorkflowResponseVO> workflowResponseVOList = WorkflowWebConverter.INSTANCE.convertListToWorkflowList(page.getRecords());
        for (WorkflowResponseVO responseVO : workflowResponseVOList) {
            if (!Objects.nonNull(responseVO.getOwnerId()) || responseVO.getOwnerId() <= 0L) continue;
            SystemUser systemUser = (SystemUser)this.systemUserMapper.selectById((Serializable)responseVO.getOwnerId());
            responseVO.setOwnerName(systemUser.getUsername());
        }
        return new PageResult<List<WorkflowResponseVO>>(pageDTO, workflowResponseVOList);
    }

    @Override
    @Transactional
    public Boolean updateWorkflow(WorkflowRequestVO workflowRequestVO) {
        Assert.notNull((Object)workflowRequestVO.getId(), () -> new SnailJobServerException("Workflow ID cannot be null"));
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowRequestVO.getId());
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("Workflow does not exist"));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        int version = workflow.getVersion();
        this.workflowWebHandler.buildGraph(Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque<Long>(), workflowRequestVO.getGroupName(), workflowRequestVO.getId(), nodeConfig, graph, version + 1, workflow.getNamespaceId());
        log.info("Graph construction complete. graph:[{}]", graph);
        workflow = WorkflowWebConverter.INSTANCE.convert(workflowRequestVO);
        this.checkTriggerInterval(workflowRequestVO);
        workflow.setId(workflowRequestVO.getId());
        workflow.setVersion(Integer.valueOf(version));
        workflowRequestVO.setTriggerInterval(workflow.getTriggerInterval());
        workflow.setNextTriggerAt(WorkflowKit.calculateNextTriggerAt((Integer)workflowRequestVO.getTriggerType(), (String)workflowRequestVO.getTriggerInterval(), (Long)DateUtils.toNowMilli()));
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        workflow.setGroupName(null);
        workflow.setOwnerId(Optional.ofNullable(workflowRequestVO.getOwnerId()).orElse(0L));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Workflow::getId, (Object)workflow.getId());
        updateWrapper.eq(Workflow::getVersion, (Object)version);
        Assert.isTrue((this.workflowMapper.update((Object)workflow, (Wrapper)updateWrapper) > 0 ? 1 : 0) != 0, () -> new SnailJobServerException("Update failed"));
        return Boolean.TRUE;
    }

    @Override
    public List<WorkflowResponseVO> getWorkflowNameList(String keywords, Long workflowId, String groupName) {
        PageDTO selectPage = (PageDTO)this.workflowMapper.selectPage((IPage)new PageDTO(1L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Workflow::getId, Workflow::getWorkflowName}).like(StrUtil.isNotBlank((CharSequence)keywords), Workflow::getWorkflowName, (Object)StrUtil.trim((CharSequence)keywords))).eq(Objects.nonNull(workflowId), Workflow::getId, (Object)workflowId)).eq(StrUtil.isNotBlank((CharSequence)groupName), Workflow::getGroupName, (Object)groupName)).eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Workflow::getId));
        return WorkflowWebConverter.INSTANCE.convertListToWorkflowList(selectPage.getRecords());
    }

    @Override
    public Pair<Integer, Object> checkNodeExpression(CheckDecisionVO decisionVO) {
        try {
            ExpressionEngine realExpressionEngine = ExpressionTypeEnum.valueOf((Integer)decisionVO.getExpressionType());
            Assert.notNull((Object)realExpressionEngine, () -> new SnailJobServerException("Expression engine does not exist"));
            ExpressionInvocationHandler invocationHandler = new ExpressionInvocationHandler((Object)realExpressionEngine);
            ExpressionEngine expressionEngine = ExpressionFactory.getExpressionEngine((InvocationHandler)invocationHandler);
            Object eval = expressionEngine.eval(decisionVO.getNodeExpression(), new Object[]{decisionVO.getCheckContent()});
            return Pair.of((Object)StatusEnum.YES.getStatus(), (Object)eval);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Expression exception. [{}]", new Object[]{decisionVO.getNodeExpression(), e});
            return Pair.of((Object)StatusEnum.NO.getStatus(), (Object)e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importWorkflowTask(List<WorkflowRequestVO> requests) {
        this.batchSaveWorkflowTask(requests, UserSessionUtils.currentUserSession().getNamespaceId());
    }

    @Override
    public String exportWorkflowTask(ExportWorkflowVO exportVO) {
        ArrayList resultList = new ArrayList();
        PartitionTaskUtils.process(startId -> {
            List workflowList = ((PageDTO)this.workflowMapper.selectPage((IPage)new PageDTO(0L, 100L, Boolean.FALSE.booleanValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(StrUtil.isNotBlank((CharSequence)exportVO.getGroupName()), Workflow::getGroupName, (Object)exportVO.getGroupName())).eq(Objects.nonNull(exportVO.getWorkflowStatus()), Workflow::getWorkflowStatus, (Object)exportVO.getWorkflowStatus())).likeRight(StrUtil.isNotBlank((CharSequence)exportVO.getWorkflowName()), Workflow::getWorkflowName, (Object)exportVO.getWorkflowName())).in(CollUtil.isNotEmpty(exportVO.getWorkflowIds()), Workflow::getId, exportVO.getWorkflowIds())).ge(Workflow::getId, (Object)startId)).orderByAsc(Workflow::getId))).getRecords();
            return workflowList.stream().map(this::doGetWorkflowDetail).map(WorkflowPartitionTask::new).collect(Collectors.toList());
        }, partitionTasks -> {
            List workflowPartitionTasks = partitionTasks;
            resultList.addAll(StreamUtils.toList((Collection)workflowPartitionTasks, WorkflowPartitionTask::getResponseVO));
        }, (long)0L);
        return JsonUtil.toJsonString(resultList);
    }

    private void batchSaveWorkflowTask(List<WorkflowRequestVO> workflowRequestVOList, String namespaceId) {
        Set groupNameSet = StreamUtils.toSet(workflowRequestVOList, WorkflowRequestVO::getGroupName);
        this.groupHandler.validateGroupExistence(groupNameSet, namespaceId);
        for (WorkflowRequestVO workflowRequestVO : workflowRequestVOList) {
            WorkflowKit.checkExecuteInterval((Integer)workflowRequestVO.getTriggerType(), (String)workflowRequestVO.getTriggerInterval());
            workflowRequestVO.setId(null);
            this.saveWorkflow(workflowRequestVO);
        }
    }

    private WorkflowDetailResponseWebVO doGetWorkflowDetail(Workflow workflow) {
        WorkflowDetailResponseWebVO responseVO = WorkflowWebConverter.INSTANCE.convert(workflow);
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)0)).eq(WorkflowNode::getVersion, (Object)workflow.getVersion())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId())).orderByAsc(WorkflowNode::getPriorityLevel));
        List jobIds = StreamUtils.toList((Collection)workflowNodes, WorkflowNode::getJobId);
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, new HashSet(jobIds)));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        List nodeInfos = WorkflowConverter.INSTANCE.convertList(workflowNodes);
        Map<Long, WorkflowDetailResponse.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            JobTaskConfigRequest jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
                jobTask.setLabels(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getLabels());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponse.NodeInfo::getId, i -> i));
        String flowInfo = workflow.getFlowInfo();
        try {
            MutableGraph graph = GraphUtils.deserializeJsonToGraph((String)flowInfo);
            WorkflowDetailResponse.NodeConfig config = this.workflowWebHandler.buildNodeConfig((MutableGraph<Long>)graph, SystemConstants.ROOT, new HashMap<Long, WorkflowDetailResponse.NodeConfig>(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            log.error("Deserialization failed. json:[{}]", (Object)flowInfo, (Object)e);
            throw new SnailJobServerException("Failed to query workflow details");
        }
        return responseVO;
    }

    protected String getNamespaceId() {
        return UserSessionUtils.currentUserSession().getNamespaceId();
    }

    @Generated
    public WorkflowWebServiceImpl(WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, SystemProperties systemProperties, WorkflowWebHandler workflowWebHandler, JobMapper jobMapper, GroupHandler groupHandler, SystemUserMapper systemUserMapper) {
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.systemProperties = systemProperties;
        this.workflowWebHandler = workflowWebHandler;
        this.jobMapper = jobMapper;
        this.groupHandler = groupHandler;
        this.systemUserMapper = systemUserMapper;
    }

    private static class WorkflowPartitionTask
    extends PartitionTask {
        private final WorkflowDetailResponseWebVO responseVO;

        public WorkflowPartitionTask(WorkflowDetailResponseWebVO responseVO) {
            this.responseVO = responseVO;
            this.setId(responseVO.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkflowPartitionTask)) {
                return false;
            }
            WorkflowPartitionTask other = (WorkflowPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WorkflowDetailResponseWebVO this$responseVO = this.getResponseVO();
            WorkflowDetailResponseWebVO other$responseVO = other.getResponseVO();
            return !(this$responseVO == null ? other$responseVO != null : !((Object)((Object)this$responseVO)).equals((Object)other$responseVO));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WorkflowPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            WorkflowDetailResponseWebVO $responseVO = this.getResponseVO();
            result = result * 59 + ($responseVO == null ? 43 : ((Object)((Object)$responseVO)).hashCode());
            return result;
        }

        @Generated
        public WorkflowDetailResponseWebVO getResponseVO() {
            return this.responseVO;
        }
    }
}

